/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.command.UpdateRoleCommandStep1;
import io.camunda.client.api.response.UpdateRoleResponse;
import io.camunda.client.impl.command.ArgumentUtil;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.response.UpdateRoleResponseImpl;
import io.camunda.client.protocol.rest.RoleUpdateRequest;
import io.camunda.client.protocol.rest.RoleUpdateResult;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class UpdateRoleCommandImpl
implements UpdateRoleCommandStep1 {
    private final String roleId;
    private final RoleUpdateRequest request;
    private final JsonMapper jsonMapper;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public UpdateRoleCommandImpl(HttpClient httpClient, String roleId, JsonMapper jsonMapper) {
        this.roleId = roleId;
        this.request = new RoleUpdateRequest();
        this.httpClient = httpClient;
        this.jsonMapper = jsonMapper;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public UpdateRoleCommandStep1 name(String name) {
        this.request.setName(name);
        return this;
    }

    @Override
    public UpdateRoleCommandStep1 description(String description) {
        this.request.setDescription(description);
        return this;
    }

    @Override
    public FinalCommandStep<UpdateRoleResponse> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<UpdateRoleResponse> send() {
        ArgumentUtil.ensureNotNullNorEmpty("name", this.request.getName());
        ArgumentUtil.ensureNotNull("description", this.request.getDescription());
        HttpCamundaFuture<UpdateRoleResponse> result = new HttpCamundaFuture<UpdateRoleResponse>();
        UpdateRoleResponseImpl response = new UpdateRoleResponseImpl();
        this.httpClient.put("/roles/" + this.roleId, this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), RoleUpdateResult.class, response::setResponse, result);
        return result;
    }
}

