/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.CredentialsProvider;
import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.command.ThrowErrorCommandStep1;
import io.camunda.client.impl.RetriableClientFutureImpl;
import io.camunda.client.impl.command.CommandWithVariables;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.protocol.rest.JobErrorRequest;
import io.camunda.zeebe.gateway.protocol.GatewayGrpc;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import io.grpc.stub.StreamObserver;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.hc.client5.http.config.RequestConfig;

public final class ThrowErrorCommandImpl
extends CommandWithVariables<ThrowErrorCommandStep1.ThrowErrorCommandStep2>
implements ThrowErrorCommandStep1,
ThrowErrorCommandStep1.ThrowErrorCommandStep2 {
    private final GatewayGrpc.GatewayStub asyncStub;
    private final GatewayOuterClass.ThrowErrorRequest.Builder grpcRequestObjectBuilder;
    private final Predicate<CredentialsProvider.StatusCode> retryPredicate;
    private Duration requestTimeout;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private final JobErrorRequest httpRequestObject;
    private boolean useRest;
    private final long jobKey;

    public ThrowErrorCommandImpl(GatewayGrpc.GatewayStub asyncStub, JsonMapper jsonMapper, long key, Duration requestTimeout, Predicate<CredentialsProvider.StatusCode> retryPredicate, HttpClient httpClient, boolean preferRestOverGrpc) {
        super(jsonMapper);
        this.asyncStub = asyncStub;
        this.requestTimeout = requestTimeout;
        this.retryPredicate = retryPredicate;
        this.grpcRequestObjectBuilder = GatewayOuterClass.ThrowErrorRequest.newBuilder();
        this.grpcRequestObjectBuilder.setJobKey(key);
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.httpRequestObject = new JobErrorRequest();
        this.useRest = preferRestOverGrpc;
        this.jobKey = key;
    }

    @Override
    public ThrowErrorCommandStep1.ThrowErrorCommandStep2 errorCode(String errorCode) {
        this.grpcRequestObjectBuilder.setErrorCode(errorCode);
        this.httpRequestObject.setErrorCode(errorCode);
        return this;
    }

    @Override
    public ThrowErrorCommandStep1.ThrowErrorCommandStep2 errorMessage(String errorMsg) {
        this.grpcRequestObjectBuilder.setErrorMessage(errorMsg);
        this.httpRequestObject.setErrorMessage(errorMsg);
        return this;
    }

    @Override
    public ThrowErrorCommandStep1.ThrowErrorCommandStep2 setVariablesInternal(String variables) {
        this.grpcRequestObjectBuilder.setVariables(variables);
        if (this.useRest) {
            this.httpRequestObject.setVariables(this.objectMapper.fromJsonAsMap(variables));
        }
        return this;
    }

    @Override
    public FinalCommandStep<Void> requestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<Void> send() {
        if (this.useRest) {
            return this.sendRestRequest();
        }
        return this.sendGrpcRequest();
    }

    private CamundaFuture<Void> sendRestRequest() {
        HttpCamundaFuture<Void> result = new HttpCamundaFuture<Void>();
        this.httpClient.post("/jobs/" + this.jobKey + "/error", this.objectMapper.toJson(this.httpRequestObject), this.httpRequestConfig.build(), result);
        return result;
    }

    private CamundaFuture<Void> sendGrpcRequest() {
        GatewayOuterClass.ThrowErrorRequest request = this.grpcRequestObjectBuilder.build();
        RetriableClientFutureImpl future = new RetriableClientFutureImpl(this.retryPredicate, streamObserver -> this.sendGrpcRequest(request, (StreamObserver<GatewayOuterClass.ThrowErrorResponse>)streamObserver));
        this.sendGrpcRequest(request, (StreamObserver<GatewayOuterClass.ThrowErrorResponse>)future);
        return future;
    }

    private void sendGrpcRequest(GatewayOuterClass.ThrowErrorRequest request, StreamObserver<GatewayOuterClass.ThrowErrorResponse> streamObserver) {
        ((GatewayGrpc.GatewayStub)this.asyncStub.withDeadlineAfter(this.requestTimeout.toMillis(), TimeUnit.MILLISECONDS)).throwError(request, streamObserver);
    }

    @Override
    public ThrowErrorCommandStep1 useRest() {
        this.useRest = true;
        return this;
    }

    @Override
    public ThrowErrorCommandStep1 useGrpc() {
        this.useRest = false;
        return this;
    }
}

