/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.command.DeleteGroupCommandStep1;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.response.DeleteGroupResponse;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class DeleteGroupCommandImpl
implements DeleteGroupCommandStep1 {
    private final String groupId;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public DeleteGroupCommandImpl(String groupId, HttpClient httpClient) {
        this.groupId = groupId;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public FinalCommandStep<DeleteGroupResponse> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<DeleteGroupResponse> send() {
        HttpCamundaFuture<DeleteGroupResponse> result = new HttpCamundaFuture<DeleteGroupResponse>();
        this.httpClient.delete("/groups/" + this.groupId, this.httpRequestConfig.build(), result);
        return result;
    }
}

