/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.command.DeleteAuthorizationCommandStep1;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.response.DeleteAuthorizationResponse;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class DeleteAuthorizationCommandImpl
implements DeleteAuthorizationCommandStep1 {
    private final long authorizationKey;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public DeleteAuthorizationCommandImpl(HttpClient httpClient, long authorizationKey) {
        this.httpClient = httpClient;
        this.authorizationKey = authorizationKey;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public FinalCommandStep<DeleteAuthorizationResponse> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<DeleteAuthorizationResponse> send() {
        HttpCamundaFuture<DeleteAuthorizationResponse> result = new HttpCamundaFuture<DeleteAuthorizationResponse>();
        this.httpClient.delete("/authorizations/" + this.authorizationKey, this.httpRequestConfig.build(), result);
        return result;
    }
}

