/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.CamundaClientConfiguration;
import io.camunda.client.CredentialsProvider;
import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.command.CreateProcessInstanceCommandStep1;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.response.ProcessInstanceEvent;
import io.camunda.client.impl.RetriableClientFutureImpl;
import io.camunda.client.impl.command.CommandWithVariables;
import io.camunda.client.impl.command.CreateProcessInstanceWithResultCommandImpl;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.response.CreateProcessInstanceResponseImpl;
import io.camunda.client.impl.util.ParseUtil;
import io.camunda.client.protocol.rest.CreateProcessInstanceResult;
import io.camunda.client.protocol.rest.ProcessInstanceCreationInstruction;
import io.camunda.client.protocol.rest.ProcessInstanceCreationStartInstruction;
import io.camunda.zeebe.gateway.protocol.GatewayGrpc;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import io.grpc.stub.StreamObserver;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.hc.client5.http.config.RequestConfig;

public final class CreateProcessInstanceCommandImpl
extends CommandWithVariables<CreateProcessInstanceCommandImpl>
implements CreateProcessInstanceCommandStep1,
CreateProcessInstanceCommandStep1.CreateProcessInstanceCommandStep2,
CreateProcessInstanceCommandStep1.CreateProcessInstanceCommandStep3 {
    private final GatewayGrpc.GatewayStub asyncStub;
    private final GatewayOuterClass.CreateProcessInstanceRequest.Builder grpcRequestObjectBuilder;
    private final Predicate<CredentialsProvider.StatusCode> retryPredicate;
    private final JsonMapper jsonMapper;
    private Duration requestTimeout;
    private boolean useRest;
    private HttpClient httpClient;
    private RequestConfig.Builder httpRequestConfig;
    private final ProcessInstanceCreationInstruction httpRequestObject = new ProcessInstanceCreationInstruction();

    public CreateProcessInstanceCommandImpl(GatewayGrpc.GatewayStub asyncStub, JsonMapper jsonMapper, CamundaClientConfiguration config, Predicate<CredentialsProvider.StatusCode> retryPredicate, HttpClient httpClient, boolean preferRestOverGrpc) {
        super(jsonMapper);
        this.asyncStub = asyncStub;
        this.requestTimeout = config.getDefaultRequestTimeout();
        this.retryPredicate = retryPredicate;
        this.jsonMapper = jsonMapper;
        this.grpcRequestObjectBuilder = GatewayOuterClass.CreateProcessInstanceRequest.newBuilder();
        this.tenantId(config.getDefaultTenantId());
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.requestTimeout(this.requestTimeout);
        this.useRest = preferRestOverGrpc;
    }

    public CreateProcessInstanceCommandImpl(GatewayGrpc.GatewayStub asyncStub, JsonMapper jsonMapper, Duration requestTimeout, Predicate<CredentialsProvider.StatusCode> retryPredicate) {
        super(jsonMapper);
        this.asyncStub = asyncStub;
        this.requestTimeout = requestTimeout;
        this.retryPredicate = retryPredicate;
        this.jsonMapper = jsonMapper;
        this.grpcRequestObjectBuilder = GatewayOuterClass.CreateProcessInstanceRequest.newBuilder();
        this.tenantId("<default>");
    }

    @Override
    protected CreateProcessInstanceCommandImpl setVariablesInternal(String variables) {
        this.grpcRequestObjectBuilder.setVariables(variables);
        if (this.useRest) {
            this.httpRequestObject.setVariables(this.jsonMapper.fromJsonAsMap(variables));
        }
        return this;
    }

    @Override
    public CreateProcessInstanceCommandStep1.CreateProcessInstanceCommandStep3 startBeforeElement(String elementId) {
        this.grpcRequestObjectBuilder.addStartInstructions(GatewayOuterClass.ProcessInstanceCreationStartInstruction.newBuilder().setElementId(elementId).build());
        this.httpRequestObject.addStartInstructionsItem(new ProcessInstanceCreationStartInstruction().elementId(elementId));
        return this;
    }

    @Override
    public CreateProcessInstanceCommandStep1.CreateProcessInstanceWithResultCommandStep1 withResult() {
        return new CreateProcessInstanceWithResultCommandImpl(this.jsonMapper, this.asyncStub, this.grpcRequestObjectBuilder, this.retryPredicate, this.requestTimeout, this.httpClient, this.useRest, this.httpRequestObject);
    }

    @Override
    public CreateProcessInstanceCommandStep1.CreateProcessInstanceCommandStep2 bpmnProcessId(String id) {
        this.grpcRequestObjectBuilder.setBpmnProcessId(id);
        this.httpRequestObject.setProcessDefinitionId(id);
        return this;
    }

    @Override
    public CreateProcessInstanceCommandStep1.CreateProcessInstanceCommandStep3 processDefinitionKey(long processDefinitionKey) {
        this.grpcRequestObjectBuilder.setProcessDefinitionKey(processDefinitionKey);
        this.httpRequestObject.setProcessDefinitionKey(ParseUtil.keyToString(processDefinitionKey));
        return this;
    }

    @Override
    public CreateProcessInstanceCommandStep1.CreateProcessInstanceCommandStep3 version(int version) {
        this.grpcRequestObjectBuilder.setVersion(version);
        this.httpRequestObject.setProcessDefinitionVersion(version);
        return this;
    }

    @Override
    public CreateProcessInstanceCommandStep1.CreateProcessInstanceCommandStep3 latestVersion() {
        return this.version(-1);
    }

    @Override
    public FinalCommandStep<ProcessInstanceEvent> requestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<ProcessInstanceEvent> send() {
        if (this.useRest) {
            return this.sendRestRequest();
        }
        return this.sendGrpcRequest();
    }

    private CamundaFuture<ProcessInstanceEvent> sendRestRequest() {
        HttpCamundaFuture<ProcessInstanceEvent> result = new HttpCamundaFuture<ProcessInstanceEvent>();
        this.httpClient.post("/process-instances", this.jsonMapper.toJson(this.httpRequestObject), this.httpRequestConfig.build(), CreateProcessInstanceResult.class, CreateProcessInstanceResponseImpl::new, result);
        return result;
    }

    private CamundaFuture<ProcessInstanceEvent> sendGrpcRequest() {
        GatewayOuterClass.CreateProcessInstanceRequest request = this.grpcRequestObjectBuilder.build();
        RetriableClientFutureImpl<ProcessInstanceEvent, GatewayOuterClass.CreateProcessInstanceResponse> future = new RetriableClientFutureImpl<ProcessInstanceEvent, GatewayOuterClass.CreateProcessInstanceResponse>(CreateProcessInstanceResponseImpl::new, this.retryPredicate, streamObserver -> this.sendGrpcRequest(request, (StreamObserver<GatewayOuterClass.CreateProcessInstanceResponse>)streamObserver));
        this.sendGrpcRequest(request, (StreamObserver<GatewayOuterClass.CreateProcessInstanceResponse>)future);
        return future;
    }

    @Override
    public CreateProcessInstanceCommandStep1.CreateProcessInstanceCommandStep3 tenantId(String tenantId) {
        this.grpcRequestObjectBuilder.setTenantId(tenantId);
        this.httpRequestObject.setTenantId(tenantId);
        return this;
    }

    private void sendGrpcRequest(GatewayOuterClass.CreateProcessInstanceRequest request, StreamObserver<GatewayOuterClass.CreateProcessInstanceResponse> future) {
        ((GatewayGrpc.GatewayStub)this.asyncStub.withDeadlineAfter(this.requestTimeout.toMillis(), TimeUnit.MILLISECONDS)).createProcessInstance(request, future);
    }

    @Override
    public CreateProcessInstanceCommandStep1 useRest() {
        this.useRest = true;
        return this;
    }

    @Override
    public CreateProcessInstanceCommandStep1 useGrpc() {
        this.useRest = false;
        return this;
    }
}

