/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.command.CreateMappingCommandStep1;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.response.CreateMappingResponse;
import io.camunda.client.impl.command.ArgumentUtil;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.response.CreateMappingResponseImpl;
import io.camunda.client.protocol.rest.MappingRuleCreateRequest;
import io.camunda.client.protocol.rest.MappingRuleCreateResult;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class CreateMappingCommandImpl
implements CreateMappingCommandStep1 {
    private final MappingRuleCreateRequest mappingRequest;
    private final JsonMapper jsonMapper;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public CreateMappingCommandImpl(HttpClient httpClient, JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.mappingRequest = new MappingRuleCreateRequest();
    }

    @Override
    public CreateMappingCommandStep1 claimName(String claimName) {
        this.mappingRequest.claimName(claimName);
        return this;
    }

    @Override
    public CreateMappingCommandStep1 claimValue(String claimValue) {
        this.mappingRequest.claimValue(claimValue);
        return this;
    }

    @Override
    public CreateMappingCommandStep1 name(String name) {
        this.mappingRequest.name(name);
        return this;
    }

    @Override
    public CreateMappingCommandStep1 mappingId(String mappingId) {
        this.mappingRequest.mappingId(mappingId);
        return this;
    }

    @Override
    public FinalCommandStep<CreateMappingResponse> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<CreateMappingResponse> send() {
        ArgumentUtil.ensureNotNull("claimName", this.mappingRequest.getClaimName());
        ArgumentUtil.ensureNotNull("claimValue", this.mappingRequest.getClaimValue());
        ArgumentUtil.ensureNotNull("name", this.mappingRequest.getName());
        ArgumentUtil.ensureNotNull("mappingId", this.mappingRequest.getMappingId());
        HttpCamundaFuture<CreateMappingResponse> result = new HttpCamundaFuture<CreateMappingResponse>();
        CreateMappingResponseImpl response = new CreateMappingResponseImpl();
        this.httpClient.post("/mapping-rules", this.jsonMapper.toJson(this.mappingRequest), this.httpRequestConfig.build(), MappingRuleCreateResult.class, response::setResponse, result);
        return result;
    }
}

