/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.command.AssignRoleToMappingCommandStep1;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.response.AssignRoleToMappingResponse;
import io.camunda.client.impl.command.ArgumentUtil;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class AssignRoleToMappingCommandImpl
implements AssignRoleToMappingCommandStep1,
AssignRoleToMappingCommandStep1.AssignRoleToMappingCommandStep2 {
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private String roleId;
    private String mappingId;

    public AssignRoleToMappingCommandImpl(HttpClient httpClient) {
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public AssignRoleToMappingCommandStep1.AssignRoleToMappingCommandStep2 roleId(String roleId) {
        this.roleId = roleId;
        return this;
    }

    @Override
    public AssignRoleToMappingCommandStep1.AssignRoleToMappingCommandStep2 mappingId(String mappingId) {
        this.mappingId = mappingId;
        return this;
    }

    @Override
    public FinalCommandStep<AssignRoleToMappingResponse> requestTimeout(Duration timeout) {
        this.httpRequestConfig.setResponseTimeout(timeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<AssignRoleToMappingResponse> send() {
        ArgumentUtil.ensureNotNullNorEmpty("roleId", this.roleId);
        ArgumentUtil.ensureNotNullNorEmpty("mappingId", this.mappingId);
        HttpCamundaFuture<AssignRoleToMappingResponse> result = new HttpCamundaFuture<AssignRoleToMappingResponse>();
        this.httpClient.put("/roles/" + this.roleId + "/mappings/" + this.mappingId, null, this.httpRequestConfig.build(), result);
        return result;
    }
}

