/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.command.AssignRoleToGroupCommandStep1;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.response.AssignRoleToGroupResponse;
import io.camunda.client.impl.command.ArgumentUtil;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class AssignRoleToGroupCommandImpl
implements AssignRoleToGroupCommandStep1,
AssignRoleToGroupCommandStep1.AssignRoleToGroupCommandStep2 {
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private String groupId;
    private String roleId;

    public AssignRoleToGroupCommandImpl(HttpClient httpClient) {
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public AssignRoleToGroupCommandStep1.AssignRoleToGroupCommandStep2 roleId(String roleId) {
        this.roleId = roleId;
        return this;
    }

    @Override
    public AssignRoleToGroupCommandStep1.AssignRoleToGroupCommandStep2 groupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    @Override
    public FinalCommandStep<AssignRoleToGroupResponse> requestTimeout(Duration timeout) {
        this.httpRequestConfig.setResponseTimeout(timeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<AssignRoleToGroupResponse> send() {
        ArgumentUtil.ensureNotNullNorEmpty("roleId", this.roleId);
        ArgumentUtil.ensureNotNullNorEmpty("groupId", this.groupId);
        HttpCamundaFuture<AssignRoleToGroupResponse> result = new HttpCamundaFuture<AssignRoleToGroupResponse>();
        this.httpClient.put("/roles/" + this.roleId + "/groups/" + this.groupId, null, this.httpRequestConfig.build(), result);
        return result;
    }
}

