/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.api.command;

import io.camunda.client.api.command.JobResultCorrections;
import java.util.List;
import java.util.function.UnaryOperator;

public class CompleteJobResult {
    private boolean isDenied;
    private String deniedReason;
    private JobResultCorrections corrections = new JobResultCorrections();

    public CompleteJobResult deny(boolean isDenied) {
        this.isDenied = isDenied;
        return this;
    }

    public CompleteJobResult deniedReason(String deniedReason) {
        this.deniedReason = deniedReason;
        return this;
    }

    public CompleteJobResult correct(JobResultCorrections corrections) {
        this.corrections = corrections == null ? new JobResultCorrections() : corrections;
        return this;
    }

    public CompleteJobResult correct(UnaryOperator<JobResultCorrections> corrections) {
        return this.correct((JobResultCorrections)corrections.apply(this.corrections));
    }

    public CompleteJobResult correctAssignee(String assignee) {
        this.corrections.assignee(assignee);
        return this;
    }

    public CompleteJobResult correctDueDate(String dueDate) {
        this.corrections.dueDate(dueDate);
        return this;
    }

    public CompleteJobResult correctFollowUpDate(String followUpDate) {
        this.corrections.followUpDate(followUpDate);
        return this;
    }

    public CompleteJobResult correctCandidateGroups(List<String> candidateGroups) {
        this.corrections.candidateGroups(candidateGroups);
        return this;
    }

    public CompleteJobResult correctCandidateUsers(List<String> candidateUsers) {
        this.corrections.candidateUsers(candidateUsers);
        return this;
    }

    public CompleteJobResult correctPriority(Integer priority) {
        this.corrections.priority(priority);
        return this;
    }

    public boolean isDenied() {
        return this.isDenied;
    }

    public String getDeniedReason() {
        return this.deniedReason;
    }

    public JobResultCorrections getCorrections() {
        return this.corrections;
    }
}

