/*
 * Camunda 8 REST API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.camunda.client.protocol.rest;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * The type of resource to add/remove permissions to/from.
 */
public enum ResourceTypeEnum {
  
  AUTHORIZATION("AUTHORIZATION"),
  
  MAPPING_RULE("MAPPING_RULE"),
  
  MESSAGE("MESSAGE"),
  
  BATCH("BATCH"),
  
  BATCH_OPERATION("BATCH_OPERATION"),
  
  APPLICATION("APPLICATION"),
  
  SYSTEM("SYSTEM"),
  
  TENANT("TENANT"),
  
  RESOURCE("RESOURCE"),
  
  PROCESS_DEFINITION("PROCESS_DEFINITION"),
  
  DECISION_REQUIREMENTS_DEFINITION("DECISION_REQUIREMENTS_DEFINITION"),
  
  DECISION_DEFINITION("DECISION_DEFINITION"),
  
  GROUP("GROUP"),
  
  USER("USER"),
  
  ROLE("ROLE"),
  
  UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

  private String value;

  ResourceTypeEnum(String value) {
    this.value = value;
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static ResourceTypeEnum fromValue(String value) {
    for (ResourceTypeEnum b : ResourceTypeEnum.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    return UNKNOWN_DEFAULT_OPEN_API;
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    if (prefix == null) {
      prefix = "";
    }

    return String.format("%s=%s", prefix, this.toString());
  }
}

