/*
 * Camunda 8 REST API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.camunda.client.protocol.rest;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * ResourceResult
 */
@JsonPropertyOrder({
  ResourceResult.JSON_PROPERTY_RESOURCE_NAME,
  ResourceResult.JSON_PROPERTY_VERSION,
  ResourceResult.JSON_PROPERTY_VERSION_TAG,
  ResourceResult.JSON_PROPERTY_RESOURCE_ID,
  ResourceResult.JSON_PROPERTY_TENANT_ID,
  ResourceResult.JSON_PROPERTY_RESOURCE_KEY
})
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-04T12:01:10.435788262Z[GMT]", comments = "Generator version: 7.12.0")
public class ResourceResult {
  public static final String JSON_PROPERTY_RESOURCE_NAME = "resourceName";
  @javax.annotation.Nullable
  private String resourceName;

  public static final String JSON_PROPERTY_VERSION = "version";
  @javax.annotation.Nullable
  private Integer version;

  public static final String JSON_PROPERTY_VERSION_TAG = "versionTag";
  @javax.annotation.Nullable
  private String versionTag;

  public static final String JSON_PROPERTY_RESOURCE_ID = "resourceId";
  @javax.annotation.Nullable
  private String resourceId;

  public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
  @javax.annotation.Nullable
  private String tenantId;

  public static final String JSON_PROPERTY_RESOURCE_KEY = "resourceKey";
  @javax.annotation.Nullable
  private String resourceKey;

  public ResourceResult() {
  }

  public ResourceResult resourceName(@javax.annotation.Nullable String resourceName) {
    
    this.resourceName = resourceName;
    return this;
  }

  /**
   * The resource name from which this resource was parsed.
   * @return resourceName
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RESOURCE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getResourceName() {
    return resourceName;
  }


  @JsonProperty(JSON_PROPERTY_RESOURCE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setResourceName(@javax.annotation.Nullable String resourceName) {
    this.resourceName = resourceName;
  }

  public ResourceResult version(@javax.annotation.Nullable Integer version) {
    
    this.version = version;
    return this;
  }

  /**
   * The assigned resource version.
   * @return version
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getVersion() {
    return version;
  }


  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVersion(@javax.annotation.Nullable Integer version) {
    this.version = version;
  }

  public ResourceResult versionTag(@javax.annotation.Nullable String versionTag) {
    
    this.versionTag = versionTag;
    return this;
  }

  /**
   * The version tag of this resource.
   * @return versionTag
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_VERSION_TAG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getVersionTag() {
    return versionTag;
  }


  @JsonProperty(JSON_PROPERTY_VERSION_TAG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVersionTag(@javax.annotation.Nullable String versionTag) {
    this.versionTag = versionTag;
  }

  public ResourceResult resourceId(@javax.annotation.Nullable String resourceId) {
    
    this.resourceId = resourceId;
    return this;
  }

  /**
   * The resource ID of this resource.
   * @return resourceId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RESOURCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getResourceId() {
    return resourceId;
  }


  @JsonProperty(JSON_PROPERTY_RESOURCE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setResourceId(@javax.annotation.Nullable String resourceId) {
    this.resourceId = resourceId;
  }

  public ResourceResult tenantId(@javax.annotation.Nullable String tenantId) {
    
    this.tenantId = tenantId;
    return this;
  }

  /**
   * The tenant ID of this resource.
   * @return tenantId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTenantId() {
    return tenantId;
  }


  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTenantId(@javax.annotation.Nullable String tenantId) {
    this.tenantId = tenantId;
  }

  public ResourceResult resourceKey(@javax.annotation.Nullable String resourceKey) {
    
    this.resourceKey = resourceKey;
    return this;
  }

  /**
   * The unique key of this resource.
   * @return resourceKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RESOURCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getResourceKey() {
    return resourceKey;
  }


  @JsonProperty(JSON_PROPERTY_RESOURCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setResourceKey(@javax.annotation.Nullable String resourceKey) {
    this.resourceKey = resourceKey;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ResourceResult resourceResult = (ResourceResult) o;
    return Objects.equals(this.resourceName, resourceResult.resourceName) &&
        Objects.equals(this.version, resourceResult.version) &&
        Objects.equals(this.versionTag, resourceResult.versionTag) &&
        Objects.equals(this.resourceId, resourceResult.resourceId) &&
        Objects.equals(this.tenantId, resourceResult.tenantId) &&
        Objects.equals(this.resourceKey, resourceResult.resourceKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(resourceName, version, versionTag, resourceId, tenantId, resourceKey);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ResourceResult {\n");
    sb.append("    resourceName: ").append(toIndentedString(resourceName)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    versionTag: ").append(toIndentedString(versionTag)).append("\n");
    sb.append("    resourceId: ").append(toIndentedString(resourceId)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    resourceKey: ").append(toIndentedString(resourceKey)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `resourceName` to the URL query string
    if (getResourceName() != null) {
      try {
        joiner.add(String.format("%sresourceName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getResourceName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `version` to the URL query string
    if (getVersion() != null) {
      try {
        joiner.add(String.format("%sversion%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getVersion()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `versionTag` to the URL query string
    if (getVersionTag() != null) {
      try {
        joiner.add(String.format("%sversionTag%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getVersionTag()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `resourceId` to the URL query string
    if (getResourceId() != null) {
      try {
        joiner.add(String.format("%sresourceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getResourceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `tenantId` to the URL query string
    if (getTenantId() != null) {
      try {
        joiner.add(String.format("%stenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `resourceKey` to the URL query string
    if (getResourceKey() != null) {
      try {
        joiner.add(String.format("%sresourceKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getResourceKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

