/*
 * Camunda 8 REST API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.camunda.client.protocol.rest;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.camunda.client.protocol.rest.JobResultCorrections;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * The result of the completed job as determined by the worker. This functionality is currently supported only by user task listeners. 
 */
@JsonPropertyOrder({
  JobResult.JSON_PROPERTY_DENIED,
  JobResult.JSON_PROPERTY_DENIED_REASON,
  JobResult.JSON_PROPERTY_CORRECTIONS
})
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-06-04T12:01:10.435788262Z[GMT]", comments = "Generator version: 7.12.0")
public class JobResult {
  public static final String JSON_PROPERTY_DENIED = "denied";
  @javax.annotation.Nullable
  private Boolean denied;

  public static final String JSON_PROPERTY_DENIED_REASON = "deniedReason";
  @javax.annotation.Nullable
  private String deniedReason;

  public static final String JSON_PROPERTY_CORRECTIONS = "corrections";
  @javax.annotation.Nullable
  private JobResultCorrections corrections;

  public JobResult() {
  }

  public JobResult denied(@javax.annotation.Nullable Boolean denied) {
    
    this.denied = denied;
    return this;
  }

  /**
   * Indicates whether the worker denies the work, i.e. explicitly doesn&#39;t approve it. For example, a user task listener can deny the completion of a task by setting this flag to true. In this example, the completion of a task is represented by a job that the worker can complete as denied. As a result, the completion request is rejected and the task remains active. Defaults to false. 
   * @return denied
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DENIED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getDenied() {
    return denied;
  }


  @JsonProperty(JSON_PROPERTY_DENIED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDenied(@javax.annotation.Nullable Boolean denied) {
    this.denied = denied;
  }

  public JobResult deniedReason(@javax.annotation.Nullable String deniedReason) {
    
    this.deniedReason = deniedReason;
    return this;
  }

  /**
   * The reason provided by the user task listener for denying the work.
   * @return deniedReason
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DENIED_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDeniedReason() {
    return deniedReason;
  }


  @JsonProperty(JSON_PROPERTY_DENIED_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeniedReason(@javax.annotation.Nullable String deniedReason) {
    this.deniedReason = deniedReason;
  }

  public JobResult corrections(@javax.annotation.Nullable JobResultCorrections corrections) {
    
    this.corrections = corrections;
    return this;
  }

  /**
   * Get corrections
   * @return corrections
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CORRECTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JobResultCorrections getCorrections() {
    return corrections;
  }


  @JsonProperty(JSON_PROPERTY_CORRECTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCorrections(@javax.annotation.Nullable JobResultCorrections corrections) {
    this.corrections = corrections;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    JobResult jobResult = (JobResult) o;
    return Objects.equals(this.denied, jobResult.denied) &&
        Objects.equals(this.deniedReason, jobResult.deniedReason) &&
        Objects.equals(this.corrections, jobResult.corrections);
  }

  @Override
  public int hashCode() {
    return Objects.hash(denied, deniedReason, corrections);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class JobResult {\n");
    sb.append("    denied: ").append(toIndentedString(denied)).append("\n");
    sb.append("    deniedReason: ").append(toIndentedString(deniedReason)).append("\n");
    sb.append("    corrections: ").append(toIndentedString(corrections)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `denied` to the URL query string
    if (getDenied() != null) {
      try {
        joiner.add(String.format("%sdenied%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDenied()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `deniedReason` to the URL query string
    if (getDeniedReason() != null) {
      try {
        joiner.add(String.format("%sdeniedReason%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDeniedReason()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `corrections` to the URL query string
    if (getCorrections() != null) {
      joiner.add(getCorrections().toUrlQueryString(prefix + "corrections" + suffix));
    }

    return joiner.toString();
  }

}

