/*
 * Camunda 8 REST API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.camunda.client.protocol.rest;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.camunda.client.protocol.rest.BasicStringFilterProperty;
import io.camunda.client.protocol.rest.DateTimeFilterProperty;
import io.camunda.client.protocol.rest.IntegerFilterProperty;
import io.camunda.client.protocol.rest.ProcessInstanceStateFilterProperty;
import io.camunda.client.protocol.rest.ProcessInstanceVariableFilterRequest;
import io.camunda.client.protocol.rest.StringFilterProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * Process instance search filter.
 */
@JsonPropertyOrder({
  ProcessInstanceFilter.JSON_PROPERTY_PROCESS_DEFINITION_ID,
  ProcessInstanceFilter.JSON_PROPERTY_PROCESS_DEFINITION_NAME,
  ProcessInstanceFilter.JSON_PROPERTY_PROCESS_DEFINITION_VERSION,
  ProcessInstanceFilter.JSON_PROPERTY_PROCESS_DEFINITION_VERSION_TAG,
  ProcessInstanceFilter.JSON_PROPERTY_START_DATE,
  ProcessInstanceFilter.JSON_PROPERTY_END_DATE,
  ProcessInstanceFilter.JSON_PROPERTY_STATE,
  ProcessInstanceFilter.JSON_PROPERTY_HAS_INCIDENT,
  ProcessInstanceFilter.JSON_PROPERTY_TENANT_ID,
  ProcessInstanceFilter.JSON_PROPERTY_VARIABLES,
  ProcessInstanceFilter.JSON_PROPERTY_PROCESS_INSTANCE_KEY,
  ProcessInstanceFilter.JSON_PROPERTY_PROCESS_DEFINITION_KEY,
  ProcessInstanceFilter.JSON_PROPERTY_PARENT_PROCESS_INSTANCE_KEY,
  ProcessInstanceFilter.JSON_PROPERTY_PARENT_FLOW_NODE_INSTANCE_KEY
})
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-25T13:39:08.081076719Z[GMT]", comments = "Generator version: 7.10.0")
public class ProcessInstanceFilter {
  public static final String JSON_PROPERTY_PROCESS_DEFINITION_ID = "processDefinitionId";
  @javax.annotation.Nullable
  private StringFilterProperty processDefinitionId;

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_NAME = "processDefinitionName";
  @javax.annotation.Nullable
  private StringFilterProperty processDefinitionName;

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_VERSION = "processDefinitionVersion";
  @javax.annotation.Nullable
  private IntegerFilterProperty processDefinitionVersion;

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_VERSION_TAG = "processDefinitionVersionTag";
  @javax.annotation.Nullable
  private StringFilterProperty processDefinitionVersionTag;

  public static final String JSON_PROPERTY_START_DATE = "startDate";
  @javax.annotation.Nullable
  private DateTimeFilterProperty startDate;

  public static final String JSON_PROPERTY_END_DATE = "endDate";
  @javax.annotation.Nullable
  private DateTimeFilterProperty endDate;

  public static final String JSON_PROPERTY_STATE = "state";
  @javax.annotation.Nullable
  private ProcessInstanceStateFilterProperty state;

  public static final String JSON_PROPERTY_HAS_INCIDENT = "hasIncident";
  @javax.annotation.Nullable
  private Boolean hasIncident;

  public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
  @javax.annotation.Nullable
  private StringFilterProperty tenantId;

  public static final String JSON_PROPERTY_VARIABLES = "variables";
  @javax.annotation.Nullable
  private List<ProcessInstanceVariableFilterRequest> variables = new ArrayList<>();

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_KEY = "processInstanceKey";
  @javax.annotation.Nullable
  private BasicStringFilterProperty processInstanceKey;

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_KEY = "processDefinitionKey";
  @javax.annotation.Nullable
  private BasicStringFilterProperty processDefinitionKey;

  public static final String JSON_PROPERTY_PARENT_PROCESS_INSTANCE_KEY = "parentProcessInstanceKey";
  @javax.annotation.Nullable
  private BasicStringFilterProperty parentProcessInstanceKey;

  public static final String JSON_PROPERTY_PARENT_FLOW_NODE_INSTANCE_KEY = "parentFlowNodeInstanceKey";
  @javax.annotation.Nullable
  private BasicStringFilterProperty parentFlowNodeInstanceKey;

  public ProcessInstanceFilter() {
  }

  public ProcessInstanceFilter processDefinitionId(@javax.annotation.Nullable StringFilterProperty processDefinitionId) {
    
    this.processDefinitionId = processDefinitionId;
    return this;
  }

  /**
   * The process definition ID.
   * @return processDefinitionId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StringFilterProperty getProcessDefinitionId() {
    return processDefinitionId;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessDefinitionId(@javax.annotation.Nullable StringFilterProperty processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }

  public ProcessInstanceFilter processDefinitionName(@javax.annotation.Nullable StringFilterProperty processDefinitionName) {
    
    this.processDefinitionName = processDefinitionName;
    return this;
  }

  /**
   * The process definition name.
   * @return processDefinitionName
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StringFilterProperty getProcessDefinitionName() {
    return processDefinitionName;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessDefinitionName(@javax.annotation.Nullable StringFilterProperty processDefinitionName) {
    this.processDefinitionName = processDefinitionName;
  }

  public ProcessInstanceFilter processDefinitionVersion(@javax.annotation.Nullable IntegerFilterProperty processDefinitionVersion) {
    
    this.processDefinitionVersion = processDefinitionVersion;
    return this;
  }

  /**
   * The process definition version.
   * @return processDefinitionVersion
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public IntegerFilterProperty getProcessDefinitionVersion() {
    return processDefinitionVersion;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessDefinitionVersion(@javax.annotation.Nullable IntegerFilterProperty processDefinitionVersion) {
    this.processDefinitionVersion = processDefinitionVersion;
  }

  public ProcessInstanceFilter processDefinitionVersionTag(@javax.annotation.Nullable StringFilterProperty processDefinitionVersionTag) {
    
    this.processDefinitionVersionTag = processDefinitionVersionTag;
    return this;
  }

  /**
   * The process definition version tag.
   * @return processDefinitionVersionTag
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_VERSION_TAG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StringFilterProperty getProcessDefinitionVersionTag() {
    return processDefinitionVersionTag;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_VERSION_TAG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessDefinitionVersionTag(@javax.annotation.Nullable StringFilterProperty processDefinitionVersionTag) {
    this.processDefinitionVersionTag = processDefinitionVersionTag;
  }

  public ProcessInstanceFilter startDate(@javax.annotation.Nullable DateTimeFilterProperty startDate) {
    
    this.startDate = startDate;
    return this;
  }

  /**
   * The start date.
   * @return startDate
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DateTimeFilterProperty getStartDate() {
    return startDate;
  }


  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStartDate(@javax.annotation.Nullable DateTimeFilterProperty startDate) {
    this.startDate = startDate;
  }

  public ProcessInstanceFilter endDate(@javax.annotation.Nullable DateTimeFilterProperty endDate) {
    
    this.endDate = endDate;
    return this;
  }

  /**
   * The end date.
   * @return endDate
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DateTimeFilterProperty getEndDate() {
    return endDate;
  }


  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEndDate(@javax.annotation.Nullable DateTimeFilterProperty endDate) {
    this.endDate = endDate;
  }

  public ProcessInstanceFilter state(@javax.annotation.Nullable ProcessInstanceStateFilterProperty state) {
    
    this.state = state;
    return this;
  }

  /**
   * The process instance state.
   * @return state
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ProcessInstanceStateFilterProperty getState() {
    return state;
  }


  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setState(@javax.annotation.Nullable ProcessInstanceStateFilterProperty state) {
    this.state = state;
  }

  public ProcessInstanceFilter hasIncident(@javax.annotation.Nullable Boolean hasIncident) {
    
    this.hasIncident = hasIncident;
    return this;
  }

  /**
   * Whether this process instance has a related incident or not.
   * @return hasIncident
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_HAS_INCIDENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasIncident() {
    return hasIncident;
  }


  @JsonProperty(JSON_PROPERTY_HAS_INCIDENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasIncident(@javax.annotation.Nullable Boolean hasIncident) {
    this.hasIncident = hasIncident;
  }

  public ProcessInstanceFilter tenantId(@javax.annotation.Nullable StringFilterProperty tenantId) {
    
    this.tenantId = tenantId;
    return this;
  }

  /**
   * The tenant ID.
   * @return tenantId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StringFilterProperty getTenantId() {
    return tenantId;
  }


  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTenantId(@javax.annotation.Nullable StringFilterProperty tenantId) {
    this.tenantId = tenantId;
  }

  public ProcessInstanceFilter variables(@javax.annotation.Nullable List<ProcessInstanceVariableFilterRequest> variables) {
    
    this.variables = variables;
    return this;
  }

  public ProcessInstanceFilter addVariablesItem(ProcessInstanceVariableFilterRequest variablesItem) {
    if (this.variables == null) {
      this.variables = new ArrayList<>();
    }
    this.variables.add(variablesItem);
    return this;
  }

  /**
   * The process instance variables.
   * @return variables
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_VARIABLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ProcessInstanceVariableFilterRequest> getVariables() {
    return variables;
  }


  @JsonProperty(JSON_PROPERTY_VARIABLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVariables(@javax.annotation.Nullable List<ProcessInstanceVariableFilterRequest> variables) {
    this.variables = variables;
  }

  public ProcessInstanceFilter processInstanceKey(@javax.annotation.Nullable BasicStringFilterProperty processInstanceKey) {
    
    this.processInstanceKey = processInstanceKey;
    return this;
  }

  /**
   * The key of this process instance.
   * @return processInstanceKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BasicStringFilterProperty getProcessInstanceKey() {
    return processInstanceKey;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessInstanceKey(@javax.annotation.Nullable BasicStringFilterProperty processInstanceKey) {
    this.processInstanceKey = processInstanceKey;
  }

  public ProcessInstanceFilter processDefinitionKey(@javax.annotation.Nullable BasicStringFilterProperty processDefinitionKey) {
    
    this.processDefinitionKey = processDefinitionKey;
    return this;
  }

  /**
   * The process definition key.
   * @return processDefinitionKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BasicStringFilterProperty getProcessDefinitionKey() {
    return processDefinitionKey;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessDefinitionKey(@javax.annotation.Nullable BasicStringFilterProperty processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }

  public ProcessInstanceFilter parentProcessInstanceKey(@javax.annotation.Nullable BasicStringFilterProperty parentProcessInstanceKey) {
    
    this.parentProcessInstanceKey = parentProcessInstanceKey;
    return this;
  }

  /**
   * The parent process instance key.
   * @return parentProcessInstanceKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PARENT_PROCESS_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BasicStringFilterProperty getParentProcessInstanceKey() {
    return parentProcessInstanceKey;
  }


  @JsonProperty(JSON_PROPERTY_PARENT_PROCESS_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setParentProcessInstanceKey(@javax.annotation.Nullable BasicStringFilterProperty parentProcessInstanceKey) {
    this.parentProcessInstanceKey = parentProcessInstanceKey;
  }

  public ProcessInstanceFilter parentFlowNodeInstanceKey(@javax.annotation.Nullable BasicStringFilterProperty parentFlowNodeInstanceKey) {
    
    this.parentFlowNodeInstanceKey = parentFlowNodeInstanceKey;
    return this;
  }

  /**
   * The parent flow node instance key.
   * @return parentFlowNodeInstanceKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PARENT_FLOW_NODE_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BasicStringFilterProperty getParentFlowNodeInstanceKey() {
    return parentFlowNodeInstanceKey;
  }


  @JsonProperty(JSON_PROPERTY_PARENT_FLOW_NODE_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setParentFlowNodeInstanceKey(@javax.annotation.Nullable BasicStringFilterProperty parentFlowNodeInstanceKey) {
    this.parentFlowNodeInstanceKey = parentFlowNodeInstanceKey;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ProcessInstanceFilter processInstanceFilter = (ProcessInstanceFilter) o;
    return Objects.equals(this.processDefinitionId, processInstanceFilter.processDefinitionId) &&
        Objects.equals(this.processDefinitionName, processInstanceFilter.processDefinitionName) &&
        Objects.equals(this.processDefinitionVersion, processInstanceFilter.processDefinitionVersion) &&
        Objects.equals(this.processDefinitionVersionTag, processInstanceFilter.processDefinitionVersionTag) &&
        Objects.equals(this.startDate, processInstanceFilter.startDate) &&
        Objects.equals(this.endDate, processInstanceFilter.endDate) &&
        Objects.equals(this.state, processInstanceFilter.state) &&
        Objects.equals(this.hasIncident, processInstanceFilter.hasIncident) &&
        Objects.equals(this.tenantId, processInstanceFilter.tenantId) &&
        Objects.equals(this.variables, processInstanceFilter.variables) &&
        Objects.equals(this.processInstanceKey, processInstanceFilter.processInstanceKey) &&
        Objects.equals(this.processDefinitionKey, processInstanceFilter.processDefinitionKey) &&
        Objects.equals(this.parentProcessInstanceKey, processInstanceFilter.parentProcessInstanceKey) &&
        Objects.equals(this.parentFlowNodeInstanceKey, processInstanceFilter.parentFlowNodeInstanceKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(processDefinitionId, processDefinitionName, processDefinitionVersion, processDefinitionVersionTag, startDate, endDate, state, hasIncident, tenantId, variables, processInstanceKey, processDefinitionKey, parentProcessInstanceKey, parentFlowNodeInstanceKey);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ProcessInstanceFilter {\n");
    sb.append("    processDefinitionId: ").append(toIndentedString(processDefinitionId)).append("\n");
    sb.append("    processDefinitionName: ").append(toIndentedString(processDefinitionName)).append("\n");
    sb.append("    processDefinitionVersion: ").append(toIndentedString(processDefinitionVersion)).append("\n");
    sb.append("    processDefinitionVersionTag: ").append(toIndentedString(processDefinitionVersionTag)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    hasIncident: ").append(toIndentedString(hasIncident)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    variables: ").append(toIndentedString(variables)).append("\n");
    sb.append("    processInstanceKey: ").append(toIndentedString(processInstanceKey)).append("\n");
    sb.append("    processDefinitionKey: ").append(toIndentedString(processDefinitionKey)).append("\n");
    sb.append("    parentProcessInstanceKey: ").append(toIndentedString(parentProcessInstanceKey)).append("\n");
    sb.append("    parentFlowNodeInstanceKey: ").append(toIndentedString(parentFlowNodeInstanceKey)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `processDefinitionId` to the URL query string
    if (getProcessDefinitionId() != null) {
      joiner.add(getProcessDefinitionId().toUrlQueryString(prefix + "processDefinitionId" + suffix));
    }

    // add `processDefinitionName` to the URL query string
    if (getProcessDefinitionName() != null) {
      joiner.add(getProcessDefinitionName().toUrlQueryString(prefix + "processDefinitionName" + suffix));
    }

    // add `processDefinitionVersion` to the URL query string
    if (getProcessDefinitionVersion() != null) {
      joiner.add(getProcessDefinitionVersion().toUrlQueryString(prefix + "processDefinitionVersion" + suffix));
    }

    // add `processDefinitionVersionTag` to the URL query string
    if (getProcessDefinitionVersionTag() != null) {
      joiner.add(getProcessDefinitionVersionTag().toUrlQueryString(prefix + "processDefinitionVersionTag" + suffix));
    }

    // add `startDate` to the URL query string
    if (getStartDate() != null) {
      joiner.add(getStartDate().toUrlQueryString(prefix + "startDate" + suffix));
    }

    // add `endDate` to the URL query string
    if (getEndDate() != null) {
      joiner.add(getEndDate().toUrlQueryString(prefix + "endDate" + suffix));
    }

    // add `state` to the URL query string
    if (getState() != null) {
      joiner.add(getState().toUrlQueryString(prefix + "state" + suffix));
    }

    // add `hasIncident` to the URL query string
    if (getHasIncident() != null) {
      try {
        joiner.add(String.format("%shasIncident%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getHasIncident()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `tenantId` to the URL query string
    if (getTenantId() != null) {
      joiner.add(getTenantId().toUrlQueryString(prefix + "tenantId" + suffix));
    }

    // add `variables` to the URL query string
    if (getVariables() != null) {
      for (int i = 0; i < getVariables().size(); i++) {
        if (getVariables().get(i) != null) {
          joiner.add(getVariables().get(i).toUrlQueryString(String.format("%svariables%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `processInstanceKey` to the URL query string
    if (getProcessInstanceKey() != null) {
      joiner.add(getProcessInstanceKey().toUrlQueryString(prefix + "processInstanceKey" + suffix));
    }

    // add `processDefinitionKey` to the URL query string
    if (getProcessDefinitionKey() != null) {
      joiner.add(getProcessDefinitionKey().toUrlQueryString(prefix + "processDefinitionKey" + suffix));
    }

    // add `parentProcessInstanceKey` to the URL query string
    if (getParentProcessInstanceKey() != null) {
      joiner.add(getParentProcessInstanceKey().toUrlQueryString(prefix + "parentProcessInstanceKey" + suffix));
    }

    // add `parentFlowNodeInstanceKey` to the URL query string
    if (getParentFlowNodeInstanceKey() != null) {
      joiner.add(getParentFlowNodeInstanceKey().toUrlQueryString(prefix + "parentFlowNodeInstanceKey" + suffix));
    }

    return joiner.toString();
  }

}

