/*
 * Camunda 8 REST API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.camunda.client.protocol.rest;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * IncidentResult
 */
@JsonPropertyOrder({
  IncidentResult.JSON_PROPERTY_PROCESS_DEFINITION_ID,
  IncidentResult.JSON_PROPERTY_ERROR_TYPE,
  IncidentResult.JSON_PROPERTY_ERROR_MESSAGE,
  IncidentResult.JSON_PROPERTY_FLOW_NODE_ID,
  IncidentResult.JSON_PROPERTY_CREATION_TIME,
  IncidentResult.JSON_PROPERTY_STATE,
  IncidentResult.JSON_PROPERTY_TENANT_ID,
  IncidentResult.JSON_PROPERTY_INCIDENT_KEY,
  IncidentResult.JSON_PROPERTY_PROCESS_DEFINITION_KEY,
  IncidentResult.JSON_PROPERTY_PROCESS_INSTANCE_KEY,
  IncidentResult.JSON_PROPERTY_FLOW_NODE_INSTANCE_KEY,
  IncidentResult.JSON_PROPERTY_JOB_KEY
})
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-25T13:39:08.081076719Z[GMT]", comments = "Generator version: 7.10.0")
public class IncidentResult {
  public static final String JSON_PROPERTY_PROCESS_DEFINITION_ID = "processDefinitionId";
  @javax.annotation.Nullable
  private String processDefinitionId;

  /**
   * Incident error type with a defined set of values.
   */
  public enum ErrorTypeEnum {
    UNSPECIFIED(String.valueOf("UNSPECIFIED")),
    
    UNKNOWN(String.valueOf("UNKNOWN")),
    
    IO_MAPPING_ERROR(String.valueOf("IO_MAPPING_ERROR")),
    
    JOB_NO_RETRIES(String.valueOf("JOB_NO_RETRIES")),
    
    EXECUTION_LISTENER_NO_RETRIES(String.valueOf("EXECUTION_LISTENER_NO_RETRIES")),
    
    TASK_LISTENER_NO_RETRIES(String.valueOf("TASK_LISTENER_NO_RETRIES")),
    
    CONDITION_ERROR(String.valueOf("CONDITION_ERROR")),
    
    EXTRACT_VALUE_ERROR(String.valueOf("EXTRACT_VALUE_ERROR")),
    
    CALLED_ELEMENT_ERROR(String.valueOf("CALLED_ELEMENT_ERROR")),
    
    UNHANDLED_ERROR_EVENT(String.valueOf("UNHANDLED_ERROR_EVENT")),
    
    MESSAGE_SIZE_EXCEEDED(String.valueOf("MESSAGE_SIZE_EXCEEDED")),
    
    CALLED_DECISION_ERROR(String.valueOf("CALLED_DECISION_ERROR")),
    
    DECISION_EVALUATION_ERROR(String.valueOf("DECISION_EVALUATION_ERROR")),
    
    FORM_NOT_FOUND(String.valueOf("FORM_NOT_FOUND")),
    
    UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

    private String value;

    ErrorTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ErrorTypeEnum fromValue(String value) {
      for (ErrorTypeEnum b : ErrorTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return UNKNOWN_DEFAULT_OPEN_API;
    }
  }

  public static final String JSON_PROPERTY_ERROR_TYPE = "errorType";
  @javax.annotation.Nullable
  private ErrorTypeEnum errorType;

  public static final String JSON_PROPERTY_ERROR_MESSAGE = "errorMessage";
  @javax.annotation.Nullable
  private String errorMessage;

  public static final String JSON_PROPERTY_FLOW_NODE_ID = "flowNodeId";
  @javax.annotation.Nullable
  private String flowNodeId;

  public static final String JSON_PROPERTY_CREATION_TIME = "creationTime";
  @javax.annotation.Nullable
  private String creationTime;

  /**
   * State of this incident with a defined set of values.
   */
  public enum StateEnum {
    ACTIVE(String.valueOf("ACTIVE")),
    
    MIGRATED(String.valueOf("MIGRATED")),
    
    RESOLVED(String.valueOf("RESOLVED")),
    
    PENDING(String.valueOf("PENDING")),
    
    UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

    private String value;

    StateEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StateEnum fromValue(String value) {
      for (StateEnum b : StateEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return UNKNOWN_DEFAULT_OPEN_API;
    }
  }

  public static final String JSON_PROPERTY_STATE = "state";
  @javax.annotation.Nullable
  private StateEnum state;

  public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
  @javax.annotation.Nullable
  private String tenantId;

  public static final String JSON_PROPERTY_INCIDENT_KEY = "incidentKey";
  @javax.annotation.Nullable
  private String incidentKey;

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_KEY = "processDefinitionKey";
  @javax.annotation.Nullable
  private String processDefinitionKey;

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_KEY = "processInstanceKey";
  @javax.annotation.Nullable
  private String processInstanceKey;

  public static final String JSON_PROPERTY_FLOW_NODE_INSTANCE_KEY = "flowNodeInstanceKey";
  @javax.annotation.Nullable
  private String flowNodeInstanceKey;

  public static final String JSON_PROPERTY_JOB_KEY = "jobKey";
  @javax.annotation.Nullable
  private String jobKey;

  public IncidentResult() {
  }

  public IncidentResult processDefinitionId(@javax.annotation.Nullable String processDefinitionId) {
    
    this.processDefinitionId = processDefinitionId;
    return this;
  }

  /**
   * The process definition ID associated to this incident.
   * @return processDefinitionId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProcessDefinitionId() {
    return processDefinitionId;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessDefinitionId(@javax.annotation.Nullable String processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }

  public IncidentResult errorType(@javax.annotation.Nullable ErrorTypeEnum errorType) {
    
    this.errorType = errorType;
    return this;
  }

  /**
   * Incident error type with a defined set of values.
   * @return errorType
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ERROR_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ErrorTypeEnum getErrorType() {
    return errorType;
  }


  @JsonProperty(JSON_PROPERTY_ERROR_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setErrorType(@javax.annotation.Nullable ErrorTypeEnum errorType) {
    this.errorType = errorType;
  }

  public IncidentResult errorMessage(@javax.annotation.Nullable String errorMessage) {
    
    this.errorMessage = errorMessage;
    return this;
  }

  /**
   * Error message which describes the error in more detail.
   * @return errorMessage
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ERROR_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getErrorMessage() {
    return errorMessage;
  }


  @JsonProperty(JSON_PROPERTY_ERROR_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setErrorMessage(@javax.annotation.Nullable String errorMessage) {
    this.errorMessage = errorMessage;
  }

  public IncidentResult flowNodeId(@javax.annotation.Nullable String flowNodeId) {
    
    this.flowNodeId = flowNodeId;
    return this;
  }

  /**
   * The flow node ID associated to this incident.
   * @return flowNodeId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FLOW_NODE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFlowNodeId() {
    return flowNodeId;
  }


  @JsonProperty(JSON_PROPERTY_FLOW_NODE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFlowNodeId(@javax.annotation.Nullable String flowNodeId) {
    this.flowNodeId = flowNodeId;
  }

  public IncidentResult creationTime(@javax.annotation.Nullable String creationTime) {
    
    this.creationTime = creationTime;
    return this;
  }

  /**
   * Date of incident creation.
   * @return creationTime
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CREATION_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCreationTime() {
    return creationTime;
  }


  @JsonProperty(JSON_PROPERTY_CREATION_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreationTime(@javax.annotation.Nullable String creationTime) {
    this.creationTime = creationTime;
  }

  public IncidentResult state(@javax.annotation.Nullable StateEnum state) {
    
    this.state = state;
    return this;
  }

  /**
   * State of this incident with a defined set of values.
   * @return state
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StateEnum getState() {
    return state;
  }


  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setState(@javax.annotation.Nullable StateEnum state) {
    this.state = state;
  }

  public IncidentResult tenantId(@javax.annotation.Nullable String tenantId) {
    
    this.tenantId = tenantId;
    return this;
  }

  /**
   * The tenant ID of the incident.
   * @return tenantId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTenantId() {
    return tenantId;
  }


  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTenantId(@javax.annotation.Nullable String tenantId) {
    this.tenantId = tenantId;
  }

  public IncidentResult incidentKey(@javax.annotation.Nullable String incidentKey) {
    
    this.incidentKey = incidentKey;
    return this;
  }

  /**
   * The assigned key, which acts as a unique identifier for this incident.
   * @return incidentKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_INCIDENT_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIncidentKey() {
    return incidentKey;
  }


  @JsonProperty(JSON_PROPERTY_INCIDENT_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncidentKey(@javax.annotation.Nullable String incidentKey) {
    this.incidentKey = incidentKey;
  }

  public IncidentResult processDefinitionKey(@javax.annotation.Nullable String processDefinitionKey) {
    
    this.processDefinitionKey = processDefinitionKey;
    return this;
  }

  /**
   * The process definition key associated to this incident.
   * @return processDefinitionKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProcessDefinitionKey() {
    return processDefinitionKey;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessDefinitionKey(@javax.annotation.Nullable String processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }

  public IncidentResult processInstanceKey(@javax.annotation.Nullable String processInstanceKey) {
    
    this.processInstanceKey = processInstanceKey;
    return this;
  }

  /**
   * The process instance key associated to this incident.
   * @return processInstanceKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProcessInstanceKey() {
    return processInstanceKey;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessInstanceKey(@javax.annotation.Nullable String processInstanceKey) {
    this.processInstanceKey = processInstanceKey;
  }

  public IncidentResult flowNodeInstanceKey(@javax.annotation.Nullable String flowNodeInstanceKey) {
    
    this.flowNodeInstanceKey = flowNodeInstanceKey;
    return this;
  }

  /**
   * The flow node instance key associated to this incident.
   * @return flowNodeInstanceKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FLOW_NODE_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFlowNodeInstanceKey() {
    return flowNodeInstanceKey;
  }


  @JsonProperty(JSON_PROPERTY_FLOW_NODE_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFlowNodeInstanceKey(@javax.annotation.Nullable String flowNodeInstanceKey) {
    this.flowNodeInstanceKey = flowNodeInstanceKey;
  }

  public IncidentResult jobKey(@javax.annotation.Nullable String jobKey) {
    
    this.jobKey = jobKey;
    return this;
  }

  /**
   * The job key, if exists, associated with this incident.
   * @return jobKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_JOB_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getJobKey() {
    return jobKey;
  }


  @JsonProperty(JSON_PROPERTY_JOB_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setJobKey(@javax.annotation.Nullable String jobKey) {
    this.jobKey = jobKey;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    IncidentResult incidentResult = (IncidentResult) o;
    return Objects.equals(this.processDefinitionId, incidentResult.processDefinitionId) &&
        Objects.equals(this.errorType, incidentResult.errorType) &&
        Objects.equals(this.errorMessage, incidentResult.errorMessage) &&
        Objects.equals(this.flowNodeId, incidentResult.flowNodeId) &&
        Objects.equals(this.creationTime, incidentResult.creationTime) &&
        Objects.equals(this.state, incidentResult.state) &&
        Objects.equals(this.tenantId, incidentResult.tenantId) &&
        Objects.equals(this.incidentKey, incidentResult.incidentKey) &&
        Objects.equals(this.processDefinitionKey, incidentResult.processDefinitionKey) &&
        Objects.equals(this.processInstanceKey, incidentResult.processInstanceKey) &&
        Objects.equals(this.flowNodeInstanceKey, incidentResult.flowNodeInstanceKey) &&
        Objects.equals(this.jobKey, incidentResult.jobKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(processDefinitionId, errorType, errorMessage, flowNodeId, creationTime, state, tenantId, incidentKey, processDefinitionKey, processInstanceKey, flowNodeInstanceKey, jobKey);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class IncidentResult {\n");
    sb.append("    processDefinitionId: ").append(toIndentedString(processDefinitionId)).append("\n");
    sb.append("    errorType: ").append(toIndentedString(errorType)).append("\n");
    sb.append("    errorMessage: ").append(toIndentedString(errorMessage)).append("\n");
    sb.append("    flowNodeId: ").append(toIndentedString(flowNodeId)).append("\n");
    sb.append("    creationTime: ").append(toIndentedString(creationTime)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    incidentKey: ").append(toIndentedString(incidentKey)).append("\n");
    sb.append("    processDefinitionKey: ").append(toIndentedString(processDefinitionKey)).append("\n");
    sb.append("    processInstanceKey: ").append(toIndentedString(processInstanceKey)).append("\n");
    sb.append("    flowNodeInstanceKey: ").append(toIndentedString(flowNodeInstanceKey)).append("\n");
    sb.append("    jobKey: ").append(toIndentedString(jobKey)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `processDefinitionId` to the URL query string
    if (getProcessDefinitionId() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `errorType` to the URL query string
    if (getErrorType() != null) {
      try {
        joiner.add(String.format("%serrorType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getErrorType()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `errorMessage` to the URL query string
    if (getErrorMessage() != null) {
      try {
        joiner.add(String.format("%serrorMessage%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getErrorMessage()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `flowNodeId` to the URL query string
    if (getFlowNodeId() != null) {
      try {
        joiner.add(String.format("%sflowNodeId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFlowNodeId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `creationTime` to the URL query string
    if (getCreationTime() != null) {
      try {
        joiner.add(String.format("%screationTime%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCreationTime()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `state` to the URL query string
    if (getState() != null) {
      try {
        joiner.add(String.format("%sstate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getState()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `tenantId` to the URL query string
    if (getTenantId() != null) {
      try {
        joiner.add(String.format("%stenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `incidentKey` to the URL query string
    if (getIncidentKey() != null) {
      try {
        joiner.add(String.format("%sincidentKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getIncidentKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionKey` to the URL query string
    if (getProcessDefinitionKey() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processInstanceKey` to the URL query string
    if (getProcessInstanceKey() != null) {
      try {
        joiner.add(String.format("%sprocessInstanceKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessInstanceKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `flowNodeInstanceKey` to the URL query string
    if (getFlowNodeInstanceKey() != null) {
      try {
        joiner.add(String.format("%sflowNodeInstanceKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFlowNodeInstanceKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `jobKey` to the URL query string
    if (getJobKey() != null) {
      try {
        joiner.add(String.format("%sjobKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getJobKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

