/*
 * Camunda 8 REST API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.camunda.client.protocol.rest;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * FlowNodeInstanceResult
 */
@JsonPropertyOrder({
  FlowNodeInstanceResult.JSON_PROPERTY_PROCESS_DEFINITION_ID,
  FlowNodeInstanceResult.JSON_PROPERTY_START_DATE,
  FlowNodeInstanceResult.JSON_PROPERTY_END_DATE,
  FlowNodeInstanceResult.JSON_PROPERTY_FLOW_NODE_ID,
  FlowNodeInstanceResult.JSON_PROPERTY_FLOW_NODE_NAME,
  FlowNodeInstanceResult.JSON_PROPERTY_TYPE,
  FlowNodeInstanceResult.JSON_PROPERTY_STATE,
  FlowNodeInstanceResult.JSON_PROPERTY_HAS_INCIDENT,
  FlowNodeInstanceResult.JSON_PROPERTY_TENANT_ID,
  FlowNodeInstanceResult.JSON_PROPERTY_FLOW_NODE_INSTANCE_KEY,
  FlowNodeInstanceResult.JSON_PROPERTY_PROCESS_INSTANCE_KEY,
  FlowNodeInstanceResult.JSON_PROPERTY_PROCESS_DEFINITION_KEY,
  FlowNodeInstanceResult.JSON_PROPERTY_INCIDENT_KEY
})
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-25T13:39:08.081076719Z[GMT]", comments = "Generator version: 7.10.0")
public class FlowNodeInstanceResult {
  public static final String JSON_PROPERTY_PROCESS_DEFINITION_ID = "processDefinitionId";
  @javax.annotation.Nullable
  private String processDefinitionId;

  public static final String JSON_PROPERTY_START_DATE = "startDate";
  @javax.annotation.Nullable
  private String startDate;

  public static final String JSON_PROPERTY_END_DATE = "endDate";
  @javax.annotation.Nullable
  private String endDate;

  public static final String JSON_PROPERTY_FLOW_NODE_ID = "flowNodeId";
  @javax.annotation.Nullable
  private String flowNodeId;

  public static final String JSON_PROPERTY_FLOW_NODE_NAME = "flowNodeName";
  @javax.annotation.Nullable
  private String flowNodeName;

  /**
   * Type of flow node as defined set of values.
   */
  public enum TypeEnum {
    UNSPECIFIED(String.valueOf("UNSPECIFIED")),
    
    PROCESS(String.valueOf("PROCESS")),
    
    SUB_PROCESS(String.valueOf("SUB_PROCESS")),
    
    EVENT_SUB_PROCESS(String.valueOf("EVENT_SUB_PROCESS")),
    
    AD_HOC_SUB_PROCESS(String.valueOf("AD_HOC_SUB_PROCESS")),
    
    START_EVENT(String.valueOf("START_EVENT")),
    
    INTERMEDIATE_CATCH_EVENT(String.valueOf("INTERMEDIATE_CATCH_EVENT")),
    
    INTERMEDIATE_THROW_EVENT(String.valueOf("INTERMEDIATE_THROW_EVENT")),
    
    BOUNDARY_EVENT(String.valueOf("BOUNDARY_EVENT")),
    
    END_EVENT(String.valueOf("END_EVENT")),
    
    SERVICE_TASK(String.valueOf("SERVICE_TASK")),
    
    RECEIVE_TASK(String.valueOf("RECEIVE_TASK")),
    
    USER_TASK(String.valueOf("USER_TASK")),
    
    MANUAL_TASK(String.valueOf("MANUAL_TASK")),
    
    TASK(String.valueOf("TASK")),
    
    EXCLUSIVE_GATEWAY(String.valueOf("EXCLUSIVE_GATEWAY")),
    
    INCLUSIVE_GATEWAY(String.valueOf("INCLUSIVE_GATEWAY")),
    
    PARALLEL_GATEWAY(String.valueOf("PARALLEL_GATEWAY")),
    
    EVENT_BASED_GATEWAY(String.valueOf("EVENT_BASED_GATEWAY")),
    
    SEQUENCE_FLOW(String.valueOf("SEQUENCE_FLOW")),
    
    MULTI_INSTANCE_BODY(String.valueOf("MULTI_INSTANCE_BODY")),
    
    CALL_ACTIVITY(String.valueOf("CALL_ACTIVITY")),
    
    BUSINESS_RULE_TASK(String.valueOf("BUSINESS_RULE_TASK")),
    
    SCRIPT_TASK(String.valueOf("SCRIPT_TASK")),
    
    SEND_TASK(String.valueOf("SEND_TASK")),
    
    UNKNOWN(String.valueOf("UNKNOWN")),
    
    UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return UNKNOWN_DEFAULT_OPEN_API;
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  @javax.annotation.Nullable
  private TypeEnum type;

  /**
   * State of flow node instance as defined set of values.
   */
  public enum StateEnum {
    ACTIVE(String.valueOf("ACTIVE")),
    
    COMPLETED(String.valueOf("COMPLETED")),
    
    TERMINATED(String.valueOf("TERMINATED")),
    
    UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

    private String value;

    StateEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StateEnum fromValue(String value) {
      for (StateEnum b : StateEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return UNKNOWN_DEFAULT_OPEN_API;
    }
  }

  public static final String JSON_PROPERTY_STATE = "state";
  @javax.annotation.Nullable
  private StateEnum state;

  public static final String JSON_PROPERTY_HAS_INCIDENT = "hasIncident";
  @javax.annotation.Nullable
  private Boolean hasIncident;

  public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
  @javax.annotation.Nullable
  private String tenantId;

  public static final String JSON_PROPERTY_FLOW_NODE_INSTANCE_KEY = "flowNodeInstanceKey";
  @javax.annotation.Nullable
  private String flowNodeInstanceKey;

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_KEY = "processInstanceKey";
  @javax.annotation.Nullable
  private String processInstanceKey;

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_KEY = "processDefinitionKey";
  @javax.annotation.Nullable
  private String processDefinitionKey;

  public static final String JSON_PROPERTY_INCIDENT_KEY = "incidentKey";
  @javax.annotation.Nullable
  private String incidentKey;

  public FlowNodeInstanceResult() {
  }

  public FlowNodeInstanceResult processDefinitionId(@javax.annotation.Nullable String processDefinitionId) {
    
    this.processDefinitionId = processDefinitionId;
    return this;
  }

  /**
   * The process definition ID associated to this flow node instance.
   * @return processDefinitionId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProcessDefinitionId() {
    return processDefinitionId;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessDefinitionId(@javax.annotation.Nullable String processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }

  public FlowNodeInstanceResult startDate(@javax.annotation.Nullable String startDate) {
    
    this.startDate = startDate;
    return this;
  }

  /**
   * Date when flow node instance started.
   * @return startDate
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getStartDate() {
    return startDate;
  }


  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStartDate(@javax.annotation.Nullable String startDate) {
    this.startDate = startDate;
  }

  public FlowNodeInstanceResult endDate(@javax.annotation.Nullable String endDate) {
    
    this.endDate = endDate;
    return this;
  }

  /**
   * Date when flow node instance finished.
   * @return endDate
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getEndDate() {
    return endDate;
  }


  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEndDate(@javax.annotation.Nullable String endDate) {
    this.endDate = endDate;
  }

  public FlowNodeInstanceResult flowNodeId(@javax.annotation.Nullable String flowNodeId) {
    
    this.flowNodeId = flowNodeId;
    return this;
  }

  /**
   * The flow node ID for this flow node instance.
   * @return flowNodeId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FLOW_NODE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFlowNodeId() {
    return flowNodeId;
  }


  @JsonProperty(JSON_PROPERTY_FLOW_NODE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFlowNodeId(@javax.annotation.Nullable String flowNodeId) {
    this.flowNodeId = flowNodeId;
  }

  public FlowNodeInstanceResult flowNodeName(@javax.annotation.Nullable String flowNodeName) {
    
    this.flowNodeName = flowNodeName;
    return this;
  }

  /**
   * The flow node name for this flow node instance.
   * @return flowNodeName
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FLOW_NODE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFlowNodeName() {
    return flowNodeName;
  }


  @JsonProperty(JSON_PROPERTY_FLOW_NODE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFlowNodeName(@javax.annotation.Nullable String flowNodeName) {
    this.flowNodeName = flowNodeName;
  }

  public FlowNodeInstanceResult type(@javax.annotation.Nullable TypeEnum type) {
    
    this.type = type;
    return this;
  }

  /**
   * Type of flow node as defined set of values.
   * @return type
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(@javax.annotation.Nullable TypeEnum type) {
    this.type = type;
  }

  public FlowNodeInstanceResult state(@javax.annotation.Nullable StateEnum state) {
    
    this.state = state;
    return this;
  }

  /**
   * State of flow node instance as defined set of values.
   * @return state
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StateEnum getState() {
    return state;
  }


  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setState(@javax.annotation.Nullable StateEnum state) {
    this.state = state;
  }

  public FlowNodeInstanceResult hasIncident(@javax.annotation.Nullable Boolean hasIncident) {
    
    this.hasIncident = hasIncident;
    return this;
  }

  /**
   * Shows whether this flow node instance has an incident. If true also an incidentKey is provided.
   * @return hasIncident
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_HAS_INCIDENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasIncident() {
    return hasIncident;
  }


  @JsonProperty(JSON_PROPERTY_HAS_INCIDENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasIncident(@javax.annotation.Nullable Boolean hasIncident) {
    this.hasIncident = hasIncident;
  }

  public FlowNodeInstanceResult tenantId(@javax.annotation.Nullable String tenantId) {
    
    this.tenantId = tenantId;
    return this;
  }

  /**
   * The tenant ID of the incident.
   * @return tenantId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTenantId() {
    return tenantId;
  }


  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTenantId(@javax.annotation.Nullable String tenantId) {
    this.tenantId = tenantId;
  }

  public FlowNodeInstanceResult flowNodeInstanceKey(@javax.annotation.Nullable String flowNodeInstanceKey) {
    
    this.flowNodeInstanceKey = flowNodeInstanceKey;
    return this;
  }

  /**
   * The assigned key, which acts as a unique identifier for this flow node instance.
   * @return flowNodeInstanceKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FLOW_NODE_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFlowNodeInstanceKey() {
    return flowNodeInstanceKey;
  }


  @JsonProperty(JSON_PROPERTY_FLOW_NODE_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFlowNodeInstanceKey(@javax.annotation.Nullable String flowNodeInstanceKey) {
    this.flowNodeInstanceKey = flowNodeInstanceKey;
  }

  public FlowNodeInstanceResult processInstanceKey(@javax.annotation.Nullable String processInstanceKey) {
    
    this.processInstanceKey = processInstanceKey;
    return this;
  }

  /**
   * The process instance key associated to this flow node instance.
   * @return processInstanceKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProcessInstanceKey() {
    return processInstanceKey;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessInstanceKey(@javax.annotation.Nullable String processInstanceKey) {
    this.processInstanceKey = processInstanceKey;
  }

  public FlowNodeInstanceResult processDefinitionKey(@javax.annotation.Nullable String processDefinitionKey) {
    
    this.processDefinitionKey = processDefinitionKey;
    return this;
  }

  /**
   * The process definition key associated to this flow node instance.
   * @return processDefinitionKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProcessDefinitionKey() {
    return processDefinitionKey;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessDefinitionKey(@javax.annotation.Nullable String processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }

  public FlowNodeInstanceResult incidentKey(@javax.annotation.Nullable String incidentKey) {
    
    this.incidentKey = incidentKey;
    return this;
  }

  /**
   * Incident key associated with this flow node instance.
   * @return incidentKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_INCIDENT_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIncidentKey() {
    return incidentKey;
  }


  @JsonProperty(JSON_PROPERTY_INCIDENT_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncidentKey(@javax.annotation.Nullable String incidentKey) {
    this.incidentKey = incidentKey;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FlowNodeInstanceResult flowNodeInstanceResult = (FlowNodeInstanceResult) o;
    return Objects.equals(this.processDefinitionId, flowNodeInstanceResult.processDefinitionId) &&
        Objects.equals(this.startDate, flowNodeInstanceResult.startDate) &&
        Objects.equals(this.endDate, flowNodeInstanceResult.endDate) &&
        Objects.equals(this.flowNodeId, flowNodeInstanceResult.flowNodeId) &&
        Objects.equals(this.flowNodeName, flowNodeInstanceResult.flowNodeName) &&
        Objects.equals(this.type, flowNodeInstanceResult.type) &&
        Objects.equals(this.state, flowNodeInstanceResult.state) &&
        Objects.equals(this.hasIncident, flowNodeInstanceResult.hasIncident) &&
        Objects.equals(this.tenantId, flowNodeInstanceResult.tenantId) &&
        Objects.equals(this.flowNodeInstanceKey, flowNodeInstanceResult.flowNodeInstanceKey) &&
        Objects.equals(this.processInstanceKey, flowNodeInstanceResult.processInstanceKey) &&
        Objects.equals(this.processDefinitionKey, flowNodeInstanceResult.processDefinitionKey) &&
        Objects.equals(this.incidentKey, flowNodeInstanceResult.incidentKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(processDefinitionId, startDate, endDate, flowNodeId, flowNodeName, type, state, hasIncident, tenantId, flowNodeInstanceKey, processInstanceKey, processDefinitionKey, incidentKey);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FlowNodeInstanceResult {\n");
    sb.append("    processDefinitionId: ").append(toIndentedString(processDefinitionId)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    flowNodeId: ").append(toIndentedString(flowNodeId)).append("\n");
    sb.append("    flowNodeName: ").append(toIndentedString(flowNodeName)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    hasIncident: ").append(toIndentedString(hasIncident)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    flowNodeInstanceKey: ").append(toIndentedString(flowNodeInstanceKey)).append("\n");
    sb.append("    processInstanceKey: ").append(toIndentedString(processInstanceKey)).append("\n");
    sb.append("    processDefinitionKey: ").append(toIndentedString(processDefinitionKey)).append("\n");
    sb.append("    incidentKey: ").append(toIndentedString(incidentKey)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `processDefinitionId` to the URL query string
    if (getProcessDefinitionId() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `startDate` to the URL query string
    if (getStartDate() != null) {
      try {
        joiner.add(String.format("%sstartDate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getStartDate()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `endDate` to the URL query string
    if (getEndDate() != null) {
      try {
        joiner.add(String.format("%sendDate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getEndDate()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `flowNodeId` to the URL query string
    if (getFlowNodeId() != null) {
      try {
        joiner.add(String.format("%sflowNodeId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFlowNodeId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `flowNodeName` to the URL query string
    if (getFlowNodeName() != null) {
      try {
        joiner.add(String.format("%sflowNodeName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFlowNodeName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `type` to the URL query string
    if (getType() != null) {
      try {
        joiner.add(String.format("%stype%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getType()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `state` to the URL query string
    if (getState() != null) {
      try {
        joiner.add(String.format("%sstate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getState()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `hasIncident` to the URL query string
    if (getHasIncident() != null) {
      try {
        joiner.add(String.format("%shasIncident%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getHasIncident()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `tenantId` to the URL query string
    if (getTenantId() != null) {
      try {
        joiner.add(String.format("%stenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `flowNodeInstanceKey` to the URL query string
    if (getFlowNodeInstanceKey() != null) {
      try {
        joiner.add(String.format("%sflowNodeInstanceKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFlowNodeInstanceKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processInstanceKey` to the URL query string
    if (getProcessInstanceKey() != null) {
      try {
        joiner.add(String.format("%sprocessInstanceKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessInstanceKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionKey` to the URL query string
    if (getProcessDefinitionKey() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `incidentKey` to the URL query string
    if (getIncidentKey() != null) {
      try {
        joiner.add(String.format("%sincidentKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getIncidentKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

