/*
 * Camunda 8 REST API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.camunda.client.protocol.rest;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.camunda.client.protocol.rest.DocumentMetadata;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * DocumentReference
 */
@JsonPropertyOrder({
  DocumentReference.JSON_PROPERTY_CAMUNDA_DOCUMENT_TYPE,
  DocumentReference.JSON_PROPERTY_STORE_ID,
  DocumentReference.JSON_PROPERTY_DOCUMENT_ID,
  DocumentReference.JSON_PROPERTY_CONTENT_HASH,
  DocumentReference.JSON_PROPERTY_METADATA
})
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-25T13:39:08.081076719Z[GMT]", comments = "Generator version: 7.10.0")
public class DocumentReference {
  /**
   * Document discriminator. Always set to \&quot;camunda\&quot;.
   */
  public enum CamundaDocumentTypeEnum {
    CAMUNDA(String.valueOf("camunda")),
    
    UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

    private String value;

    CamundaDocumentTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CamundaDocumentTypeEnum fromValue(String value) {
      for (CamundaDocumentTypeEnum b : CamundaDocumentTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return UNKNOWN_DEFAULT_OPEN_API;
    }
  }

  public static final String JSON_PROPERTY_CAMUNDA_DOCUMENT_TYPE = "camunda.document.type";
  @javax.annotation.Nullable
  private CamundaDocumentTypeEnum camundaDocumentType;

  public static final String JSON_PROPERTY_STORE_ID = "storeId";
  @javax.annotation.Nullable
  private String storeId;

  public static final String JSON_PROPERTY_DOCUMENT_ID = "documentId";
  @javax.annotation.Nullable
  private String documentId;

  public static final String JSON_PROPERTY_CONTENT_HASH = "contentHash";
  @javax.annotation.Nullable
  private String contentHash;

  public static final String JSON_PROPERTY_METADATA = "metadata";
  @javax.annotation.Nullable
  private DocumentMetadata metadata;

  public DocumentReference() {
  }

  public DocumentReference camundaDocumentType(@javax.annotation.Nullable CamundaDocumentTypeEnum camundaDocumentType) {
    
    this.camundaDocumentType = camundaDocumentType;
    return this;
  }

  /**
   * Document discriminator. Always set to \&quot;camunda\&quot;.
   * @return camundaDocumentType
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CAMUNDA_DOCUMENT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CamundaDocumentTypeEnum getCamundaDocumentType() {
    return camundaDocumentType;
  }


  @JsonProperty(JSON_PROPERTY_CAMUNDA_DOCUMENT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCamundaDocumentType(@javax.annotation.Nullable CamundaDocumentTypeEnum camundaDocumentType) {
    this.camundaDocumentType = camundaDocumentType;
  }

  public DocumentReference storeId(@javax.annotation.Nullable String storeId) {
    
    this.storeId = storeId;
    return this;
  }

  /**
   * The ID of the document store.
   * @return storeId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_STORE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getStoreId() {
    return storeId;
  }


  @JsonProperty(JSON_PROPERTY_STORE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStoreId(@javax.annotation.Nullable String storeId) {
    this.storeId = storeId;
  }

  public DocumentReference documentId(@javax.annotation.Nullable String documentId) {
    
    this.documentId = documentId;
    return this;
  }

  /**
   * The ID of the document.
   * @return documentId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DOCUMENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDocumentId() {
    return documentId;
  }


  @JsonProperty(JSON_PROPERTY_DOCUMENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDocumentId(@javax.annotation.Nullable String documentId) {
    this.documentId = documentId;
  }

  public DocumentReference contentHash(@javax.annotation.Nullable String contentHash) {
    
    this.contentHash = contentHash;
    return this;
  }

  /**
   * The hash of the document.
   * @return contentHash
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CONTENT_HASH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getContentHash() {
    return contentHash;
  }


  @JsonProperty(JSON_PROPERTY_CONTENT_HASH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContentHash(@javax.annotation.Nullable String contentHash) {
    this.contentHash = contentHash;
  }

  public DocumentReference metadata(@javax.annotation.Nullable DocumentMetadata metadata) {
    
    this.metadata = metadata;
    return this;
  }

  /**
   * Get metadata
   * @return metadata
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DocumentMetadata getMetadata() {
    return metadata;
  }


  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetadata(@javax.annotation.Nullable DocumentMetadata metadata) {
    this.metadata = metadata;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DocumentReference documentReference = (DocumentReference) o;
    return Objects.equals(this.camundaDocumentType, documentReference.camundaDocumentType) &&
        Objects.equals(this.storeId, documentReference.storeId) &&
        Objects.equals(this.documentId, documentReference.documentId) &&
        Objects.equals(this.contentHash, documentReference.contentHash) &&
        Objects.equals(this.metadata, documentReference.metadata);
  }

  @Override
  public int hashCode() {
    return Objects.hash(camundaDocumentType, storeId, documentId, contentHash, metadata);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DocumentReference {\n");
    sb.append("    camundaDocumentType: ").append(toIndentedString(camundaDocumentType)).append("\n");
    sb.append("    storeId: ").append(toIndentedString(storeId)).append("\n");
    sb.append("    documentId: ").append(toIndentedString(documentId)).append("\n");
    sb.append("    contentHash: ").append(toIndentedString(contentHash)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `camunda.document.type` to the URL query string
    if (getCamundaDocumentType() != null) {
      try {
        joiner.add(String.format("%scamunda.document.type%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCamundaDocumentType()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `storeId` to the URL query string
    if (getStoreId() != null) {
      try {
        joiner.add(String.format("%sstoreId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getStoreId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `documentId` to the URL query string
    if (getDocumentId() != null) {
      try {
        joiner.add(String.format("%sdocumentId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDocumentId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `contentHash` to the URL query string
    if (getContentHash() != null) {
      try {
        joiner.add(String.format("%scontentHash%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getContentHash()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `metadata` to the URL query string
    if (getMetadata() != null) {
      joiner.add(getMetadata().toUrlQueryString(prefix + "metadata" + suffix));
    }

    return joiner.toString();
  }

}

