/*
 * Camunda 8 REST API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.camunda.client.protocol.rest;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.camunda.client.protocol.rest.OwnerTypeEnum;
import io.camunda.client.protocol.rest.PermissionTypeEnum;
import io.camunda.client.protocol.rest.ResourceTypeEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * AuthorizationRequest
 */
@JsonPropertyOrder({
  AuthorizationRequest.JSON_PROPERTY_OWNER_ID,
  AuthorizationRequest.JSON_PROPERTY_OWNER_TYPE,
  AuthorizationRequest.JSON_PROPERTY_RESOURCE_ID,
  AuthorizationRequest.JSON_PROPERTY_RESOURCE_TYPE,
  AuthorizationRequest.JSON_PROPERTY_PERMISSION_TYPES
})
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-25T13:39:08.081076719Z[GMT]", comments = "Generator version: 7.10.0")
public class AuthorizationRequest {
  public static final String JSON_PROPERTY_OWNER_ID = "ownerId";
  @javax.annotation.Nonnull
  private String ownerId;

  public static final String JSON_PROPERTY_OWNER_TYPE = "ownerType";
  @javax.annotation.Nonnull
  private OwnerTypeEnum ownerType;

  public static final String JSON_PROPERTY_RESOURCE_ID = "resourceId";
  @javax.annotation.Nonnull
  private String resourceId;

  public static final String JSON_PROPERTY_RESOURCE_TYPE = "resourceType";
  @javax.annotation.Nonnull
  private ResourceTypeEnum resourceType;

  public static final String JSON_PROPERTY_PERMISSION_TYPES = "permissionTypes";
  @javax.annotation.Nonnull
  private List<PermissionTypeEnum> permissionTypes = new ArrayList<>();

  public AuthorizationRequest() {
  }

  public AuthorizationRequest ownerId(@javax.annotation.Nonnull String ownerId) {
    
    this.ownerId = ownerId;
    return this;
  }

  /**
   * The ID of the owner of the permissions.
   * @return ownerId
   */
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_OWNER_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getOwnerId() {
    return ownerId;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOwnerId(@javax.annotation.Nonnull String ownerId) {
    this.ownerId = ownerId;
  }

  public AuthorizationRequest ownerType(@javax.annotation.Nonnull OwnerTypeEnum ownerType) {
    
    this.ownerType = ownerType;
    return this;
  }

  /**
   * The type of the owner of the permissions.
   * @return ownerType
   */
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_OWNER_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OwnerTypeEnum getOwnerType() {
    return ownerType;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOwnerType(@javax.annotation.Nonnull OwnerTypeEnum ownerType) {
    this.ownerType = ownerType;
  }

  public AuthorizationRequest resourceId(@javax.annotation.Nonnull String resourceId) {
    
    this.resourceId = resourceId;
    return this;
  }

  /**
   * The ID of the resource to add permissions to.
   * @return resourceId
   */
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_RESOURCE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getResourceId() {
    return resourceId;
  }


  @JsonProperty(JSON_PROPERTY_RESOURCE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setResourceId(@javax.annotation.Nonnull String resourceId) {
    this.resourceId = resourceId;
  }

  public AuthorizationRequest resourceType(@javax.annotation.Nonnull ResourceTypeEnum resourceType) {
    
    this.resourceType = resourceType;
    return this;
  }

  /**
   * The type of resource to add permissions to.
   * @return resourceType
   */
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_RESOURCE_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ResourceTypeEnum getResourceType() {
    return resourceType;
  }


  @JsonProperty(JSON_PROPERTY_RESOURCE_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setResourceType(@javax.annotation.Nonnull ResourceTypeEnum resourceType) {
    this.resourceType = resourceType;
  }

  public AuthorizationRequest permissionTypes(@javax.annotation.Nonnull List<PermissionTypeEnum> permissionTypes) {
    
    this.permissionTypes = permissionTypes;
    return this;
  }

  public AuthorizationRequest addPermissionTypesItem(PermissionTypeEnum permissionTypesItem) {
    if (this.permissionTypes == null) {
      this.permissionTypes = new ArrayList<>();
    }
    this.permissionTypes.add(permissionTypesItem);
    return this;
  }

  /**
   * The permission types to add.
   * @return permissionTypes
   */
  @javax.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_PERMISSION_TYPES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<PermissionTypeEnum> getPermissionTypes() {
    return permissionTypes;
  }


  @JsonProperty(JSON_PROPERTY_PERMISSION_TYPES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPermissionTypes(@javax.annotation.Nonnull List<PermissionTypeEnum> permissionTypes) {
    this.permissionTypes = permissionTypes;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AuthorizationRequest authorizationRequest = (AuthorizationRequest) o;
    return Objects.equals(this.ownerId, authorizationRequest.ownerId) &&
        Objects.equals(this.ownerType, authorizationRequest.ownerType) &&
        Objects.equals(this.resourceId, authorizationRequest.resourceId) &&
        Objects.equals(this.resourceType, authorizationRequest.resourceType) &&
        Objects.equals(this.permissionTypes, authorizationRequest.permissionTypes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(ownerId, ownerType, resourceId, resourceType, permissionTypes);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AuthorizationRequest {\n");
    sb.append("    ownerId: ").append(toIndentedString(ownerId)).append("\n");
    sb.append("    ownerType: ").append(toIndentedString(ownerType)).append("\n");
    sb.append("    resourceId: ").append(toIndentedString(resourceId)).append("\n");
    sb.append("    resourceType: ").append(toIndentedString(resourceType)).append("\n");
    sb.append("    permissionTypes: ").append(toIndentedString(permissionTypes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `ownerId` to the URL query string
    if (getOwnerId() != null) {
      try {
        joiner.add(String.format("%sownerId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getOwnerId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `ownerType` to the URL query string
    if (getOwnerType() != null) {
      try {
        joiner.add(String.format("%sownerType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getOwnerType()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `resourceId` to the URL query string
    if (getResourceId() != null) {
      try {
        joiner.add(String.format("%sresourceId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getResourceId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `resourceType` to the URL query string
    if (getResourceType() != null) {
      try {
        joiner.add(String.format("%sresourceType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getResourceType()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `permissionTypes` to the URL query string
    if (getPermissionTypes() != null) {
      for (int i = 0; i < getPermissionTypes().size(); i++) {
        if (getPermissionTypes().get(i) != null) {
          try {
            joiner.add(String.format("%spermissionTypes%s%s=%s", prefix, suffix,
                "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
                URLEncoder.encode(String.valueOf(getPermissionTypes().get(i)), "UTF-8").replaceAll("\\+", "%20")));
          } catch (UnsupportedEncodingException e) {
            // Should never happen, UTF-8 is always supported
            throw new RuntimeException(e);
          }
        }
      }
    }

    return joiner.toString();
  }

}

