/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.migrator.impl.util;

import io.camunda.client.api.command.ClientException;
import io.camunda.migrator.exception.HistoryMigratorException;
import io.camunda.migrator.exception.MigratorException;
import io.camunda.migrator.exception.RuntimeMigratorException;
import java.util.function.Supplier;
import org.apache.ibatis.exceptions.PersistenceException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionUtils {
    private static final ThreadLocal<ExceptionContext> EXCEPTION_CONTEXT = ThreadLocal.withInitial(() -> null);
    protected static final Logger LOGGER = LoggerFactory.getLogger(ExceptionUtils.class);

    public static void setContext(ExceptionContext context) {
        EXCEPTION_CONTEXT.set(context);
    }

    public static void clearContext() {
        EXCEPTION_CONTEXT.remove();
    }

    public static <T> T callApi(Supplier<T> supplier) {
        return ExceptionUtils.callApi(supplier, "Error occurred: shutting down Data Migrator gracefully.");
    }

    public static <T> T callApi(Supplier<T> supplier, String message) {
        try {
            return supplier.get();
        }
        catch (ClientException | PersistenceException | ProcessEngineException e) {
            throw ExceptionUtils.wrapException(message, (Exception)e);
        }
    }

    public static void callApi(Runnable runnable) {
        ExceptionUtils.callApi(runnable, "Error occurred: shutting down Data Migrator gracefully.");
    }

    public static void callApi(Runnable runnable, String message) {
        try {
            runnable.run();
        }
        catch (ClientException | PersistenceException | ProcessEngineException e) {
            throw ExceptionUtils.wrapException(message, (Exception)e);
        }
    }

    public static MigratorException wrapException(String message, Exception e) {
        ExceptionContext context = EXCEPTION_CONTEXT.get();
        MigratorException exception = context == ExceptionContext.HISTORY ? new HistoryMigratorException(message, e) : new RuntimeMigratorException(message, e);
        LOGGER.error(message, (Throwable)exception);
        return exception;
    }

    public static enum ExceptionContext {
        RUNTIME,
        HISTORY;

    }
}

