/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.migrator.impl.util;

import io.camunda.migrator.constants.MigratorConstants;
import io.camunda.zeebe.protocol.Protocol;
import java.security.SecureRandom;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class ConverterUtil {
    public static Long getNextKey() {
        SecureRandom secureRandom = new SecureRandom();
        return Protocol.encodePartitionId((int)MigratorConstants.C7_HISTORY_PARTITION_ID, (long)secureRandom.nextLong(ConverterUtil.getUpperBound() + 1L));
    }

    public static long getUpperBound() {
        return 0x7FFFFFFFFFFFFL;
    }

    public static OffsetDateTime convertDate(Date date) {
        if (date == null) {
            return null;
        }
        return date.toInstant().atOffset(ZoneOffset.UTC);
    }

    public static String getTenantId(String c7TenantId) {
        return StringUtils.isEmpty((CharSequence)c7TenantId) ? "<default>" : c7TenantId;
    }
}

