/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.migrator.impl.persistence;

import io.camunda.migrator.impl.persistence.IdKeyDbModel;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ibatis.annotations.Param;

public interface IdKeyMapper {
    public static final Set<TYPE> HISTORY_TYPES = Arrays.stream(TYPE.values()).filter(type -> type.name().startsWith("HISTORY")).collect(Collectors.toCollection(() -> EnumSet.noneOf(TYPE.class)));

    public static Set<String> getHistoryTypeNames() {
        return HISTORY_TYPES.stream().map(Enum::name).collect(Collectors.toSet());
    }

    public static Set<TYPE> getHistoryTypes() {
        return HISTORY_TYPES;
    }

    public String findLatestIdByType(TYPE var1);

    public boolean checkExistsByIdAndType(@Param(value="type") TYPE var1, @Param(value="id") String var2);

    public boolean checkHasKeyByIdAndType(@Param(value="type") TYPE var1, @Param(value="id") String var2);

    public Date findLatestStartDateByType(TYPE var1);

    public Long findKeysByIdAndType(@Param(value="id") String var1, @Param(value="type") TYPE var2);

    public void insert(IdKeyDbModel var1);

    public List<IdKeyDbModel> findSkippedByType(@Param(value="type") TYPE var1, @Param(value="offset") int var2, @Param(value="limit") int var3);

    public List<IdKeyDbModel> findMigratedByType(@Param(value="type") TYPE var1, @Param(value="offset") int var2, @Param(value="limit") int var3);

    public long countSkippedByType(@Param(value="type") TYPE var1);

    public List<String> findAllIds();

    public void updateKeyByIdAndType(IdKeyDbModel var1);

    public void delete(String var1);

    public static enum TYPE {
        HISTORY_PROCESS_DEFINITION("Historic Process Definition"),
        HISTORY_PROCESS_INSTANCE("Historic Process Instance"),
        HISTORY_INCIDENT("Historic Incident"),
        HISTORY_VARIABLE("Historic Variable"),
        HISTORY_USER_TASK("Historic User Task"),
        HISTORY_FLOW_NODE("Historic Flow Node"),
        HISTORY_DECISION_INSTANCE("Historic Decision Instance"),
        HISTORY_DECISION_INSTANCE_INPUT("Historic Decision Instance Input"),
        HISTORY_DECISION_INSTANCE_OUTPUT("Historic Decision Instance Output"),
        HISTORY_DECISION_DEFINITION("Historic Decision Definition"),
        HISTORY_DECISION_REQUIREMENT("Historic Decision Requirement"),
        RUNTIME_PROCESS_INSTANCE("Process Instance");

        private final String displayName;

        private TYPE(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

