/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.migrator.impl.logging;

import io.camunda.migrator.impl.VariableService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariableServiceLogs {
    static final Logger LOGGER = LoggerFactory.getLogger(VariableService.class);
    public static final String LEGACY_ID_VARIABLE = "legacyId";
    public static final String DATE_FORMAT_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final String START_EXECUTION_LOG = "Start {} execution for variable: {}";
    public static final String END_EXECUTION_LOG = "End {} execution for variable: {}";
    public static final String CONVERTING_DATE_LOG = "Converting date variable: {}";
    public static final String CONVERTED_DATE_LOG = "Converted date from variable with name {} from {} to {}";
    public static final String VARIABLE_INTERCEPTOR_FAILED_MSG = "%s failed for variable with name '%s'";
    public static final String BYTE_ARRAY_UNSUPPORTED_ERROR = "Variable of type 'byte[]' is unsupported in C8.";
    public static final String FILE_TYPE_UNSUPPORTED_ERROR = "Variable of type 'file' is unsupported in C8.";
    public static final String JAVA_SERIALIZED_UNSUPPORTED_ERROR = "Objects serialized as 'application/x-java-serialized-object' are unsupported in C8.";
    public static final String JSON_DESERIALIZATION_ERROR = "Error while deserializing JSON into Map type.";
    public static final String GENERIC_TYPE_UNSUPPORTED_ERROR = "Variable of type '%s' is unsupported in C8.";

    public static void logInterceptorWarn(String interceptorName, String variableName) {
        LOGGER.warn(VariableServiceLogs.formatInterceptorWarn(interceptorName, variableName));
    }

    public static String formatInterceptorWarn(String interceptorName, String variableName) {
        return String.format(VARIABLE_INTERCEPTOR_FAILED_MSG, interceptorName, variableName);
    }

    public static void logStartExecution(Class<?> transformerClass, String variableName) {
        LOGGER.debug(START_EXECUTION_LOG, transformerClass, (Object)variableName);
    }

    public static void logEndExecution(Class<?> transformerClass, String variableName) {
        LOGGER.debug(END_EXECUTION_LOG, transformerClass, (Object)variableName);
    }

    public static void logConvertingDate(String variableName) {
        LOGGER.debug(CONVERTING_DATE_LOG, (Object)variableName);
    }

    public static void logConvertedDate(String name, Object originalValue, String formattedValue) {
        LOGGER.debug(CONVERTED_DATE_LOG, new Object[]{name, originalValue, formattedValue});
    }
}

