/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.migrator.impl.logging;

import io.camunda.migrator.converter.VariableConverter;
import org.camunda.bpm.engine.variable.impl.value.ObjectValueImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariableConverterLogs {
    private static final Logger LOGGER = LoggerFactory.getLogger(VariableConverter.class);
    public static final String CONVERTING_OF_TYPE = "Converting variable with legacyId [{}] of type: {}";
    public static final String WARN_NO_HANDLING_AVAILABLE = "No existing handling for variable with id= {}, type: {}, returning null.";
    public static final String ERROR_CONVERTING_JSON = "Error converting typed value to json: {}, exception: {}. Mapped to null";

    public static void convertingOfType(String legacyId, String type) {
        LOGGER.info(CONVERTING_OF_TYPE, (Object)legacyId, (Object)type);
    }

    public static void warnNoHandlingAvailable(String legacyId, String type) {
        LOGGER.warn(WARN_NO_HANDLING_AVAILABLE, (Object)legacyId, (Object)type);
    }

    public static void failedConvertingJson(ObjectValueImpl typedValue, String message) {
        LOGGER.error(ERROR_CONVERTING_JSON, (Object)typedValue, (Object)message);
    }
}

