/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.migrator.impl.logging;

import io.camunda.migrator.HistoryMigrator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HistoryMigratorLogs {
    protected static final Logger LOGGER = LoggerFactory.getLogger(HistoryMigrator.class);
    public static final String MIGRATING_DEFINITIONS = "Migrating {} definitions";
    public static final String MIGRATING_DEFINITION = "Migrating {} definition with legacyId: [{}]";
    public static final String MIGRATING_DEFINITION_COMPLETE = "Migration of {} definition with legacyId [{}] completed";
    public static final String SKIPPING_DECISION_DEFINITION = "Migration of historic decision definition with legacyId [{}] skipped. Decision requirements definition not yet available.";
    public static final String MIGRATING_INSTANCES = "Migrating historic {} instances";
    public static final String MIGRATING_INSTANCE = "Migrating historic {} instance with legacyId: [{}]";
    public static final String MIGRATING_INSTANCE_COMPLETE = "Migration of historic {} instance with legacyId [{}] completed";
    public static final String SKIPPING_INSTANCE_MISSING_PARENT = "Migration of historic {} instance with legacyId [{}] skipped. Parent instance not yet available.";
    public static final String SKIPPING_INSTANCE_MISSING_DEFINITION = "Migration of historic {} instance with legacyId [{}] skipped. {} definition not yet available.";
    public static final String SKIPPING_DECISION_INSTANCE_MISSING_PROCESS_INSTANCE = "Migration of historic decision instance with legacyId [{}] skipped. Process instance not yet available.";
    public static final String SKIPPING_DECISION_INSTANCE_MISSING_FLOW_NODE_INSTANCE = "Migration of historic decision instance with legacyId [{}] skipped. Flow node instance not yet available.";
    public static final String NOT_MIGRATING_DECISION_INSTANCE = "Not migrating historic decision instance with legacyId: [{}] because it does not originate from a business rule task.";
    public static final String MIGRATING_INCIDENTS = "Migrating historic incidents";
    public static final String MIGRATING_INCIDENT = "Migrating historic incident with legacyId: [{}]";
    public static final String MIGRATING_INCIDENT_COMPLETED = "Migration of historic incident with legacyId [{}] completed.";
    public static final String SKIPPING_INCIDENT = "Migration of historic incident with legacyId [{}] skipped. Process instance not yet available.";
    public static final String MIGRATING_VARIABLES = "Migrating historic variables";
    public static final String MIGRATING_VARIABLE = "Migrating historic variables with legacyId: [{}]";
    public static final String MIGRATING_VARIABLE_COMPLETED = "Migration of historic variable with legacyId [{}] completed.";
    public static final String SKIPPING_VARIABLE_MISSING_FLOW_NODE = "Migration of historic variable with legacyId [{}] skipped. Flow node instance not yet available.";
    public static final String SKIPPING_VARIABLE_MISSING_PROCESS = "Migration of historic variable with legacyId [{}] skipped. Process instance not yet available.";
    public static final String SKIPPING_VARIABLE_MISSING_TASK = "Migration of historic variable with legacyId [{}] skipped. Associated task [{}] was skipped.";
    public static final String SKIPPING_VARIABLE_MISSING_SCOPE = "Migration of historic variable with legacyId [{}] skipped. Scope key is not yet available.";
    public static final String MIGRATING_USER_TASKS = "Migrating historic user tasks";
    public static final String MIGRATING_USER_TASK = "Migrating historic user task with legacyId: [{}]";
    public static final String MIGRATING_USER_TASK_COMPLETED = "Migration of historic user task with legacyId [{}] completed.";
    public static final String SKIPPING_MIGRATING_USER_TASK_MISSING_FLOW_NODE = "Migration of historic user task with legacyId [{}] skipped. Flow node instance yet not available.";
    public static final String SKIPPING_USER_TASK_MISSING_PROCESS = "Migration of historic user task with legacyId [{}] skipped. Process instance yet not available.";
    public static final String MIGRATING_FLOW_NODES = "Migrating historic flow nodes";
    public static final String MIGRATING_FLOW_NODE = "Migrating historic flow nodes with legacyId: [{}]";
    public static final String MIGRATING_FLOW_NODE_COMPLETED = "Migration of historic flow nodes with legacyId [{}] completed.";
    public static final String SKIPPING_FLOW_NODE = "Migration of historic flow nodes with legacyId [{}] skipped. Process instance yet not available.";
    public static final String MIGRATING_DECISION_REQUIREMENTS = "Migrating decision requirements";
    public static final String MIGRATING_DECISION_REQUIREMENT = "Migrating decision requirements with legacyId: [{}]";
    public static final String MIGRATING_DECISION_REQUIREMENT_COMPLETED = "Migration of decision requirements with legacyId [{}] completed.";

    public static void migratingDecisionDefinitions() {
        LOGGER.info(MIGRATING_DEFINITIONS, (Object)"decision");
    }

    public static void migratingDecisionDefinition(String legacyDecisionDefinitionId) {
        LOGGER.debug(MIGRATING_DEFINITION, (Object)"decision", (Object)legacyDecisionDefinitionId);
    }

    public static void migratingDecisionDefinitionCompleted(String legacyDecisionDefinitionId) {
        LOGGER.debug(MIGRATING_DEFINITION_COMPLETE, (Object)"decision", (Object)legacyDecisionDefinitionId);
    }

    public static void skippingDecisionDefinition(String legacyDecisionDefinitionId) {
        LOGGER.debug(SKIPPING_DECISION_DEFINITION, (Object)legacyDecisionDefinitionId);
    }

    public static void migratingProcessDefinitions() {
        LOGGER.info(MIGRATING_DEFINITIONS, (Object)"process");
    }

    public static void migratingProcessDefinition(String legacyProcessDefinitionId) {
        LOGGER.debug(MIGRATING_DEFINITION, (Object)"process", (Object)legacyProcessDefinitionId);
    }

    public static void migratingProcessDefinitionCompleted(String legacyProcessDefinitionId) {
        LOGGER.debug(MIGRATING_DEFINITION_COMPLETE, (Object)"process", (Object)legacyProcessDefinitionId);
    }

    public static void migratingProcessInstances() {
        LOGGER.info(MIGRATING_INSTANCES, (Object)"process");
    }

    public static void migratingProcessInstance(String legacyProcessInstanceId) {
        LOGGER.debug(MIGRATING_INSTANCE, (Object)"process", (Object)legacyProcessInstanceId);
    }

    public static void migratingProcessInstanceCompleted(String legacyProcessInstanceId) {
        LOGGER.debug(MIGRATING_INSTANCE_COMPLETE, (Object)"process", (Object)legacyProcessInstanceId);
    }

    public static void skippingProcessInstanceDueToMissingParent(String legacyProcessInstanceId) {
        LOGGER.debug(SKIPPING_INSTANCE_MISSING_PARENT, (Object)"process", (Object)legacyProcessInstanceId);
    }

    public static void skippingProcessInstanceDueToMissingDefinition(String legacyProcessInstanceId) {
        LOGGER.debug(SKIPPING_INSTANCE_MISSING_DEFINITION, new Object[]{"process", legacyProcessInstanceId, "process"});
    }

    public static void migratingDecisionInstances() {
        LOGGER.info(MIGRATING_INSTANCES, (Object)"decision");
    }

    public static void notMigratingDecisionInstancesNotOriginatingFromBusinessRuleTasks(String legacyDecisionInstanceId) {
        LOGGER.debug(NOT_MIGRATING_DECISION_INSTANCE, (Object)legacyDecisionInstanceId);
    }

    public static void migratingDecisionInstance(String legacyDecisionInstanceId) {
        LOGGER.debug(MIGRATING_INSTANCE, (Object)"decision", (Object)legacyDecisionInstanceId);
    }

    public static void migratingDecisionInstanceCompleted(String legacyDecisionInstanceId) {
        LOGGER.debug(MIGRATING_INSTANCE_COMPLETE, (Object)"decision", (Object)legacyDecisionInstanceId);
    }

    public static void skippingDecisionInstanceDueToMissingParent(String legacyDecisionInstanceId) {
        LOGGER.debug(SKIPPING_INSTANCE_MISSING_PARENT, (Object)"decision", (Object)legacyDecisionInstanceId);
    }

    public static void skippingDecisionInstanceDueToMissingDecisionDefinition(String legacyDecisionInstanceId) {
        LOGGER.debug(SKIPPING_INSTANCE_MISSING_DEFINITION, new Object[]{"decision", legacyDecisionInstanceId, "decision"});
    }

    public static void skippingDecisionInstanceDueToMissingProcessDefinition(String legacyDecisionInstanceId) {
        LOGGER.debug(SKIPPING_INSTANCE_MISSING_DEFINITION, new Object[]{"decision", legacyDecisionInstanceId, "process"});
    }

    public static void skippingDecisionInstanceDueToMissingProcessInstance(String legacyDecisionInstanceId) {
        LOGGER.debug(SKIPPING_DECISION_INSTANCE_MISSING_PROCESS_INSTANCE, (Object)legacyDecisionInstanceId);
    }

    public static void skippingDecisionInstanceDueToMissingFlowNodeInstanceInstance(String legacyDecisionInstanceId) {
        LOGGER.debug(SKIPPING_DECISION_INSTANCE_MISSING_FLOW_NODE_INSTANCE, (Object)legacyDecisionInstanceId);
    }

    public static void migratingHistoricIncidents() {
        LOGGER.info(MIGRATING_INCIDENTS);
    }

    public static void migratingHistoricIncident(String legacyIncidentId) {
        LOGGER.debug(MIGRATING_INCIDENT, (Object)legacyIncidentId);
    }

    public static void migratingHistoricIncidentCompleted(String legacyIncidentId) {
        LOGGER.debug(MIGRATING_INCIDENT_COMPLETED, (Object)legacyIncidentId);
    }

    public static void skippingHistoricIncident(String legacyIncidentId) {
        LOGGER.debug(SKIPPING_INCIDENT, (Object)legacyIncidentId);
    }

    public static void migratingHistoricVariables() {
        LOGGER.info(MIGRATING_VARIABLES);
    }

    public static void migratingHistoricVariable(String legacyVariableId) {
        LOGGER.debug(MIGRATING_VARIABLE, (Object)legacyVariableId);
    }

    public static void migratingHistoricVariableCompleted(String legacyVariableId) {
        LOGGER.debug(MIGRATING_VARIABLE_COMPLETED, (Object)legacyVariableId);
    }

    public static void skippingHistoricVariableDueToMissingFlowNode(String legacyVariableId) {
        LOGGER.debug(SKIPPING_VARIABLE_MISSING_FLOW_NODE, (Object)legacyVariableId);
    }

    public static void skippingHistoricVariableDueToMissingProcessInstance(String legacyVariableId) {
        LOGGER.debug(SKIPPING_VARIABLE_MISSING_PROCESS, (Object)legacyVariableId);
    }

    public static void skippingHistoricVariableDueToMissingTask(String legacyVariableId, String taskId) {
        LOGGER.debug(SKIPPING_VARIABLE_MISSING_TASK, (Object)legacyVariableId, (Object)taskId);
    }

    public static void skippingHistoricVariableDueToMissingScopeKey(String legacyVariableId) {
        LOGGER.debug(SKIPPING_VARIABLE_MISSING_SCOPE, (Object)legacyVariableId);
    }

    public static void migratingHistoricUserTasks() {
        LOGGER.info(MIGRATING_USER_TASKS);
    }

    public static void migratingHistoricUserTask(String legacyUserTaskId) {
        LOGGER.debug(MIGRATING_USER_TASK, (Object)legacyUserTaskId);
    }

    public static void migratingHistoricUserTaskCompleted(String legacyUserTaskId) {
        LOGGER.debug(MIGRATING_USER_TASK_COMPLETED, (Object)legacyUserTaskId);
    }

    public static void skippingHistoricUserTaskDueToMissingFlowNode(String legacyUserTaskId) {
        LOGGER.debug(SKIPPING_MIGRATING_USER_TASK_MISSING_FLOW_NODE, (Object)legacyUserTaskId);
    }

    public static void skippingHistoricUserTaskDueToMissingProcessInstance(String legacyUserTaskId) {
        LOGGER.debug(SKIPPING_USER_TASK_MISSING_PROCESS, (Object)legacyUserTaskId);
    }

    public static void migratingHistoricFlowNodes() {
        LOGGER.info(MIGRATING_FLOW_NODES);
    }

    public static void migratingHistoricFlowNode(String legacyFlowNodeId) {
        LOGGER.debug(MIGRATING_FLOW_NODE, (Object)legacyFlowNodeId);
    }

    public static void migratingHistoricFlowNodeCompleted(String legacyFlowNodeId) {
        LOGGER.debug(MIGRATING_FLOW_NODE_COMPLETED, (Object)legacyFlowNodeId);
    }

    public static void skippingHistoricFlowNode(String legacyFlowNodeId) {
        LOGGER.debug(SKIPPING_FLOW_NODE, (Object)legacyFlowNodeId);
    }

    public static void migratingDecisionRequirements() {
        LOGGER.info(MIGRATING_DECISION_REQUIREMENTS);
    }

    public static void migratingDecisionRequirements(String legacyDecisionRequirementsId) {
        LOGGER.debug(MIGRATING_DECISION_REQUIREMENT, (Object)legacyDecisionRequirementsId);
    }

    public static void migratingDecisionRequirementsCompleted(String legacyDecisionRequirementsId) {
        LOGGER.debug(MIGRATING_DECISION_REQUIREMENT_COMPLETED, (Object)legacyDecisionRequirementsId);
    }
}

