/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.migrator.impl.logging;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationLogs {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationLogs.class);
    public static final String ERROR_CLASS_NAME_NULL_OR_EMPTY = "Variable interceptor class name cannot be null or empty";
    public static final String ERROR_CLASS_NOT_IMPLEMENT_INTERFACE = "Class %s does not implement VariableInterceptor interface";
    public static final String ERROR_FAILED_TO_REGISTER = "Failed to register variable interceptor: ";
    public static final String ERROR_PARSING_CONFIGURATION = "An exception occurred while parsing interceptor configuration.";
    public static final String INFO_CONFIGURING_INTERCEPTORS = "Configuring variable interceptors from Spring context and YAML";
    public static final String INFO_TOTAL_INTERCEPTORS_CONFIGURED = "Total {} variable interceptors configured";
    public static final String INFO_SUCCESSFULLY_REGISTERED = "Successfully registered variable interceptor: {}";
    public static final String INFO_LIQUIBASE_CREATING_TABLE_SCHEMA = "Creating table schema with Liquibase change log file '{}' with table prefix '{}'.";
    public static final String DEBUG_NO_YAML_INTERCEPTORS = "No variable interceptors configured in YAML";
    public static final String DEBUG_CREATING_INSTANCE = "Creating variable interceptor instance for class: {}";
    public static final String DEBUG_SETTING_PROPERTIES = "Setting properties for variable interceptor: {}";

    public static void logConfiguringInterceptors() {
        LOGGER.info(INFO_CONFIGURING_INTERCEPTORS);
    }

    public static void logTotalInterceptorsConfigured(int count) {
        LOGGER.info(INFO_TOTAL_INTERCEPTORS_CONFIGURED, (Object)count);
    }

    public static void logNoYamlInterceptors() {
        LOGGER.debug(DEBUG_NO_YAML_INTERCEPTORS);
    }

    public static void logSuccessfullyRegistered(String className) {
        LOGGER.info(INFO_SUCCESSFULLY_REGISTERED, (Object)className);
    }

    public static void logFailedToRegister(String className, Exception exception) {
        LOGGER.error(ERROR_FAILED_TO_REGISTER + className, (Throwable)exception);
    }

    public static void logCreatingInstance(String className) {
        LOGGER.debug(DEBUG_CREATING_INSTANCE, (Object)className);
    }

    public static void logSettingProperties(String className) {
        LOGGER.debug(DEBUG_SETTING_PROPERTIES, (Object)className);
    }

    public static void logCreatingTableSchema(String changeLogFile, String tablePrefix) {
        LOGGER.info(INFO_LIQUIBASE_CREATING_TABLE_SCHEMA, (Object)changeLogFile, (Object)tablePrefix);
    }

    public static String getClassNameNullOrEmptyError() {
        return ERROR_CLASS_NAME_NULL_OR_EMPTY;
    }

    public static String getClassNotImplementInterfaceError(String className) {
        return String.format(ERROR_CLASS_NOT_IMPLEMENT_INTERFACE, className);
    }

    public static String getFailedToRegisterError(String className) {
        return ERROR_FAILED_TO_REGISTER + className;
    }

    public static String getParsingConfigurationError() {
        return ERROR_PARSING_CONFIGURATION;
    }
}

