/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.migrator.impl.clients;

import io.camunda.migrator.config.property.MigratorProperties;
import io.camunda.migrator.impl.Pagination;
import io.camunda.migrator.impl.logging.DbClientLogs;
import io.camunda.migrator.impl.persistence.IdKeyDbModel;
import io.camunda.migrator.impl.persistence.IdKeyMapper;
import io.camunda.migrator.impl.util.ExceptionUtils;
import io.camunda.migrator.impl.util.PrintUtils;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DbClient {
    @Autowired
    protected MigratorProperties properties;
    @Autowired
    protected IdKeyMapper idKeyMapper;

    public boolean checkExistsByIdAndType(String legacyId, IdKeyMapper.TYPE type) {
        return ExceptionUtils.callApi(() -> this.idKeyMapper.checkExistsByIdAndType(type, legacyId), "Failed to check existence for legacyId: " + legacyId);
    }

    public boolean checkHasKeyByIdAndType(String legacyId, IdKeyMapper.TYPE type) {
        return ExceptionUtils.callApi(() -> this.idKeyMapper.checkHasKeyByIdAndType(type, legacyId), "Failed to check key for legacyId: " + legacyId);
    }

    public Date findLatestStartDateByType(IdKeyMapper.TYPE type) {
        Date latestStartDate = ExceptionUtils.callApi(() -> this.idKeyMapper.findLatestStartDateByType(type), "Failed to find latest start date for type: " + String.valueOf((Object)type));
        DbClientLogs.foundLatestStartDate(latestStartDate, type);
        return latestStartDate;
    }

    public String findLatestIdByType(IdKeyMapper.TYPE type) {
        return ExceptionUtils.callApi(() -> this.idKeyMapper.findLatestIdByType(type), "Failed to find latest legacyId for type: " + String.valueOf((Object)type));
    }

    public Long findKeyByIdAndType(String legacyId, IdKeyMapper.TYPE type) {
        return ExceptionUtils.callApi(() -> this.idKeyMapper.findKeysByIdAndType(legacyId, type), "Failed to find key by legacyId: " + legacyId);
    }

    public List<String> findAllIds() {
        return ExceptionUtils.callApi(() -> this.idKeyMapper.findAllIds(), "Failed to find all ids");
    }

    public void updateKeyByIdAndType(String legacyId, Long entityKey, IdKeyMapper.TYPE type) {
        DbClientLogs.updatingKeyForLegacyId(legacyId, entityKey);
        IdKeyDbModel model = this.createIdKeyDbModel(legacyId, null, entityKey, type);
        ExceptionUtils.callApi(() -> this.idKeyMapper.updateKeyByIdAndType(model), "Failed to update key for legacyId: " + entityKey);
    }

    public void insert(String legacyId, Date startDate, Long entityKey, IdKeyMapper.TYPE type) {
        DbClientLogs.insertingRecord(legacyId, startDate, entityKey);
        IdKeyDbModel model = this.createIdKeyDbModel(legacyId, startDate, entityKey, type);
        ExceptionUtils.callApi(() -> this.idKeyMapper.insert(model), "Failed to insert record for legacyId: " + legacyId);
    }

    public void insert(String legacyId, Long key, IdKeyMapper.TYPE type) {
        DbClientLogs.insertingRecord(legacyId, null, key);
        IdKeyDbModel model = this.createIdKeyDbModel(legacyId, null, key, type);
        ExceptionUtils.callApi(() -> this.idKeyMapper.insert(model), "Failed to insert record for legacyId: " + legacyId);
    }

    public void listSkippedEntitiesByType(IdKeyMapper.TYPE type) {
        new Pagination().pageSize(this.properties.getPageSize()).maxCount(() -> this.idKeyMapper.countSkippedByType(type)).page(offset -> this.idKeyMapper.findSkippedByType(type, (int)offset, this.properties.getPageSize()).stream().map(IdKeyDbModel::id).collect(Collectors.toList())).callback(PrintUtils::print);
    }

    public void fetchAndHandleSkippedForType(IdKeyMapper.TYPE type, Consumer<IdKeyDbModel> callback) {
        new Pagination().pageSize(this.properties.getPageSize()).maxCount(() -> this.idKeyMapper.countSkippedByType(type)).page(offset -> this.idKeyMapper.findSkippedByType(type, 0, this.properties.getPageSize())).callback(callback);
    }

    public Long countSkippedByType(IdKeyMapper.TYPE type) {
        return ExceptionUtils.callApi(() -> this.idKeyMapper.countSkippedByType(type), "Failed to find skipped count");
    }

    public List<IdKeyDbModel> findSkippedProcessInstances() {
        return ExceptionUtils.callApi(() -> this.idKeyMapper.findSkippedByType(IdKeyMapper.TYPE.RUNTIME_PROCESS_INSTANCE, 0, this.properties.getPageSize()), "Failed to find skipped entity Ids");
    }

    public void deleteAllMappings() {
        this.findAllIds().forEach(this::delete);
    }

    protected void delete(String legacyId) {
        ExceptionUtils.callApi(() -> this.idKeyMapper.delete(legacyId), "Failed to delete mapping for legacyId: " + legacyId);
    }

    protected IdKeyDbModel createIdKeyDbModel(String id, Date startDate, Long key, IdKeyMapper.TYPE type) {
        IdKeyDbModel keyIdDbModel = new IdKeyDbModel();
        keyIdDbModel.setId(id);
        keyIdDbModel.setStartDate(startDate);
        keyIdDbModel.setInstanceKey(key);
        keyIdDbModel.setType(type);
        return keyIdDbModel;
    }
}

