/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.migrator.impl.clients;

import io.camunda.client.CamundaClient;
import io.camunda.client.api.command.ActivateJobsCommandStep1;
import io.camunda.client.api.command.CreateProcessInstanceCommandStep1;
import io.camunda.client.api.command.DeployResourceCommandStep1;
import io.camunda.client.api.command.ModifyProcessInstanceCommandStep1;
import io.camunda.client.api.fetch.ProcessDefinitionGetXmlRequest;
import io.camunda.client.api.response.ActivatedJob;
import io.camunda.client.api.response.ModifyProcessInstanceResponse;
import io.camunda.client.api.response.ProcessInstanceEvent;
import io.camunda.client.api.search.request.ProcessDefinitionSearchRequest;
import io.camunda.client.api.search.response.ProcessDefinition;
import io.camunda.client.api.search.response.SearchResponse;
import io.camunda.migrator.config.property.MigratorProperties;
import io.camunda.migrator.impl.model.FlowNodeActivation;
import io.camunda.migrator.impl.util.ExceptionUtils;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class C8Client {
    @Autowired
    protected MigratorProperties properties;
    @Autowired
    protected CamundaClient camundaClient;

    public ProcessInstanceEvent createProcessInstance(String bpmnProcessId, Map<String, Object> variables) {
        CreateProcessInstanceCommandStep1.CreateProcessInstanceCommandStep3 createProcessInstance = this.camundaClient.newCreateInstanceCommand().bpmnProcessId(bpmnProcessId).latestVersion().variables(variables);
        return ExceptionUtils.callApi(() -> ((CreateProcessInstanceCommandStep1.CreateProcessInstanceCommandStep3)createProcessInstance).execute(), "Creating process instance failed for bpmnProcessId: " + bpmnProcessId);
    }

    public SearchResponse<ProcessDefinition> searchProcessDefinitions(String processDefinitionId) {
        ProcessDefinitionSearchRequest searchRequest = (ProcessDefinitionSearchRequest)((ProcessDefinitionSearchRequest)this.camundaClient.newProcessDefinitionSearchRequest().filter(filter -> filter.processDefinitionId(processDefinitionId))).sort(s -> s.version().desc());
        return ExceptionUtils.callApi(() -> ((ProcessDefinitionSearchRequest)searchRequest).execute(), "Process definition search failed for processDefinitionId: " + processDefinitionId);
    }

    public String getProcessDefinitionXml(long processDefinitionKey) {
        ProcessDefinitionGetXmlRequest getXmlRequest = this.camundaClient.newProcessDefinitionGetXmlRequest(processDefinitionKey);
        return ExceptionUtils.callApi(() -> ((ProcessDefinitionGetXmlRequest)getXmlRequest).execute(), "Failed to fetch process definition XML for key: " + processDefinitionKey);
    }

    public List<ActivatedJob> activateJobs(String jobType) {
        ActivateJobsCommandStep1.ActivateJobsCommandStep3 activateJobs = this.camundaClient.newActivateJobsCommand().jobType(jobType).maxJobsToActivate(this.properties.getPageSize());
        return ExceptionUtils.callApi(() -> ((ActivateJobsCommandStep1.ActivateJobsCommandStep3)activateJobs).execute(), "Failed to activate jobs for type: " + jobType).getJobs();
    }

    public Object getJobVariable(ActivatedJob job, String variableName) {
        return ExceptionUtils.callApi(() -> job.getVariable(variableName), String.format("Failed to fetch variable '%s' from job: %s", variableName, job.getKey()));
    }

    public void modifyProcessInstance(long processInstanceKey, long startEventInstanceKey, List<FlowNodeActivation> flowNodeActivations) {
        ModifyProcessInstanceCommandStep1 modifyProcessInstance = this.camundaClient.newModifyProcessInstanceCommand(processInstanceKey);
        modifyProcessInstance.terminateElement(startEventInstanceKey);
        flowNodeActivations.forEach(flowNodeActivation -> {
            String activityId = flowNodeActivation.activityId();
            Map<String, Object> variables = flowNodeActivation.variables();
            modifyProcessInstance.activateElement(activityId).withVariables(variables, activityId);
        });
        ExceptionUtils.callApi(() -> (ModifyProcessInstanceResponse)((ModifyProcessInstanceCommandStep1.ModifyProcessInstanceCommandStep3)modifyProcessInstance).execute(), "Failed to modify process instance with activation for key: " + processInstanceKey);
    }

    public void deployResources(Set<Path> models) {
        DeployResourceCommandStep1.DeployResourceCommandStep2 deployResourceCmd = null;
        DeployResourceCommandStep1 deployResource = this.camundaClient.newDeployResourceCommand();
        for (Path model : models) {
            deployResourceCmd = deployResource.addResourceFile(model.toString());
        }
        if (deployResourceCmd != null) {
            ExceptionUtils.callApi(() -> deployResourceCmd.execute(), "Failed to deploy C8 resources: " + String.valueOf(models));
        }
    }
}

