/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.migrator.impl.clients;

import io.camunda.migrator.config.property.MigratorProperties;
import io.camunda.migrator.impl.Pagination;
import io.camunda.migrator.impl.persistence.IdKeyDbModel;
import io.camunda.migrator.impl.util.ExceptionUtils;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricActivityInstanceQuery;
import org.camunda.bpm.engine.history.HistoricDecisionInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInstanceQuery;
import org.camunda.bpm.engine.history.HistoricIncident;
import org.camunda.bpm.engine.history.HistoricIncidentQuery;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.history.HistoricTaskInstance;
import org.camunda.bpm.engine.history.HistoricTaskInstanceQuery;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.history.HistoricVariableInstanceQuery;
import org.camunda.bpm.engine.impl.HistoricActivityInstanceQueryImpl;
import org.camunda.bpm.engine.impl.HistoricDecisionInstanceQueryImpl;
import org.camunda.bpm.engine.impl.HistoricIncidentQueryImpl;
import org.camunda.bpm.engine.impl.HistoricProcessInstanceQueryImpl;
import org.camunda.bpm.engine.impl.HistoricTaskInstanceQueryImpl;
import org.camunda.bpm.engine.impl.HistoricVariableInstanceQueryImpl;
import org.camunda.bpm.engine.impl.ProcessDefinitionQueryImpl;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.DecisionDefinitionQuery;
import org.camunda.bpm.engine.repository.DecisionRequirementsDefinition;
import org.camunda.bpm.engine.repository.DecisionRequirementsDefinitionQuery;
import org.camunda.bpm.engine.repository.DeploymentQuery;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.IncidentQuery;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.runtime.VariableInstanceQuery;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class C7Client {
    @Autowired
    protected RuntimeService runtimeService;
    @Autowired
    protected HistoryService historyService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    protected MigratorProperties properties;
    @Autowired
    protected ApplicationContext context;

    public ProcessInstance getProcessInstance(String processInstanceId) {
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId);
        return ExceptionUtils.callApi(() -> ((ProcessInstanceQuery)query).singleResult(), "Process instance fetching failed for legacyId: " + processInstanceId);
    }

    public ProcessDefinition getProcessDefinition(String legacyId) {
        ProcessDefinitionQuery query = this.repositoryService.createProcessDefinitionQuery().processDefinitionId(legacyId);
        return ExceptionUtils.callApi(() -> ((ProcessDefinitionQuery)query).singleResult(), String.format("Failed to fetch %s for legacyId: %s", "ProcessDefinition", legacyId));
    }

    public DecisionRequirementsDefinition getDecisionRequirementsDefinition(String legacyId) {
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery().decisionRequirementsDefinitionId(legacyId);
        return ExceptionUtils.callApi(() -> ((DecisionRequirementsDefinitionQuery)query).singleResult(), String.format("Failed to fetch %s for legacyId: %s", "DecisionRequirementsDefinition", legacyId));
    }

    public DecisionDefinition getDecisionDefinition(String legacyId) {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionId(legacyId);
        return ExceptionUtils.callApi(() -> ((DecisionDefinitionQuery)query).singleResult(), String.format("Failed to fetch %s for legacyId: %s", "DecisionDefinition", legacyId));
    }

    public HistoricDecisionInstance getHistoricDecisionInstance(String legacyId) {
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().decisionInstanceId(legacyId);
        return ExceptionUtils.callApi(() -> ((HistoricDecisionInstanceQuery)query).singleResult(), String.format("Failed to fetch %s for legacyId: %s", "HistoricDecisionInstance", legacyId));
    }

    public HistoricDecisionInstance getHistoricDecisionInstanceByDefinitionKey(String definitionKey) {
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().decisionDefinitionKey(definitionKey);
        return ExceptionUtils.callApi(() -> ((HistoricDecisionInstanceQuery)query).singleResult(), String.format("Failed to fetch %s for legacyId: %s", "HistoricDecisionInstance", definitionKey));
    }

    public HistoricProcessInstance getHistoricProcessInstance(String legacyId) {
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().processInstanceId(legacyId);
        return ExceptionUtils.callApi(() -> ((HistoricProcessInstanceQuery)query).singleResult(), String.format("Failed to fetch %s for legacyId: %s", "HistoricProcessInstance", legacyId));
    }

    public HistoricActivityInstance getHistoricActivityInstance(String legacyId) {
        HistoricActivityInstanceQuery query = this.historyService.createHistoricActivityInstanceQuery().activityInstanceId(legacyId);
        return ExceptionUtils.callApi(() -> ((HistoricActivityInstanceQuery)query).singleResult(), String.format("Failed to fetch %s for legacyId: %s", "HistoricActivityInstance", legacyId));
    }

    public HistoricTaskInstance getHistoricTaskInstance(String legacyId) {
        HistoricTaskInstanceQuery query = this.historyService.createHistoricTaskInstanceQuery().taskId(legacyId);
        return ExceptionUtils.callApi(() -> ((HistoricTaskInstanceQuery)query).singleResult(), String.format("Failed to fetch %s for legacyId: %s", "HistoricTaskInstance", legacyId));
    }

    public HistoricVariableInstance getHistoricVariableInstance(String legacyId) {
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery().variableId(legacyId);
        return ExceptionUtils.callApi(() -> ((HistoricVariableInstanceQuery)query).singleResult(), String.format("Failed to fetch %s for legacyId: %s", "HistoricVariableInstance", legacyId));
    }

    public HistoricIncident getHistoricIncident(String legacyId) {
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery().incidentId(legacyId);
        return ExceptionUtils.callApi(() -> ((HistoricIncidentQuery)query).singleResult(), String.format("Failed to fetch %s for legacyId: %s", "HistoricIncident", legacyId));
    }

    public long getIncidentsByProcessInstance(String legacyId) {
        IncidentQuery query = this.runtimeService.createIncidentQuery().processInstanceId(legacyId);
        return ExceptionUtils.callApi(() -> ((IncidentQuery)query).count(), String.format("Failed to fetch %s for legacyId: %s", "Incident", legacyId));
    }

    public ActivityInstance getActivityInstance(String processInstanceId) {
        return ExceptionUtils.callApi(() -> this.runtimeService.getActivityInstance(processInstanceId), "Failed to fetch activity instance for processInstanceId: " + processInstanceId);
    }

    public List<VariableInstance> getAllVariables(String legacyProcessInstanceId) {
        VariableInstanceQuery variableQuery = this.runtimeService.createVariableInstanceQuery().disableCustomObjectDeserialization().processInstanceIdIn(new String[]{legacyProcessInstanceId});
        return new Pagination().pageSize(this.properties.getPageSize()).query(variableQuery).toList();
    }

    public List<VariableInstance> getLocalVariables(String activityInstanceId) {
        VariableInstanceQuery variableQuery = this.runtimeService.createVariableInstanceQuery().disableCustomObjectDeserialization().activityInstanceIdIn(new String[]{activityInstanceId});
        return new Pagination().pageSize(this.properties.getPageSize()).query(variableQuery).toList();
    }

    public InputStream getResourceAsStream(String resourceId, String resourceName) {
        return ExceptionUtils.callApi(() -> this.repositoryService.getResourceAsStream(resourceId, resourceName));
    }

    public BpmnModelInstance getBpmnModelInstance(String processDefinitionId) {
        return ExceptionUtils.callApi(() -> this.repositoryService.getBpmnModelInstance(processDefinitionId), "Failed to fetch BPMN model instance for process definition Id: " + processDefinitionId);
    }

    public Date getDefinitionDeploymentTime(String definitionDeploymentId) {
        DeploymentQuery query = this.repositoryService.createDeploymentQuery().deploymentId(definitionDeploymentId);
        return ExceptionUtils.callApi(() -> ((DeploymentQuery)query).singleResult(), "Failed to fetch deployment time for definition with legacyId: " + definitionDeploymentId).getDeploymentTime();
    }

    public void fetchAndHandleProcessInstances(Consumer<ProcessInstance> callback, String rootProcessInstanceId) {
        ProcessInstanceQuery query = this.runtimeService.createProcessInstanceQuery().rootProcessInstanceId(rootProcessInstanceId);
        new Pagination().pageSize(this.properties.getPageSize()).maxCount(() -> ((ProcessInstanceQuery)query).count()).query(query).callback(callback);
    }

    public void fetchAndHandleHistoricRootProcessInstances(Consumer<IdKeyDbModel> callback, Date startedAfter) {
        HistoricProcessInstanceQuery query = (HistoricProcessInstanceQuery)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().startedAfter(startedAfter).rootProcessInstances().unfinished().orderByProcessInstanceStartTime().asc()).orderByProcessInstanceId().asc();
        new Pagination().pageSize(this.properties.getPageSize()).maxCount(() -> ((HistoricProcessInstanceQuery)query).count()).page(offset -> query.listPage(offset.intValue(), this.properties.getPageSize()).stream().map(hpi -> new IdKeyDbModel(hpi.getId(), hpi.getStartTime())).collect(Collectors.toList())).callback(callback);
    }

    public void fetchAndHandleHistoricProcessInstances(Consumer<HistoricProcessInstance> callback, Date startedAfter) {
        HistoricProcessInstanceQueryImpl query = (HistoricProcessInstanceQueryImpl)((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().orderByProcessInstanceStartTime().asc()).orderByProcessInstanceId().asc();
        if (startedAfter != null) {
            query.startedAfter(startedAfter);
        }
        new Pagination().pageSize(this.properties.getPageSize()).query(query).maxCount(() -> ((HistoricProcessInstanceQueryImpl)query).count()).callback(callback);
    }

    public void fetchAndHandleHistoricDecisionInstances(Consumer<HistoricDecisionInstance> callback, Date evaluatedAfter) {
        HistoricDecisionInstanceQueryImpl query = (HistoricDecisionInstanceQueryImpl)this.historyService.createHistoricDecisionInstanceQuery().includeInputs().includeOutputs().orderByEvaluationTime().asc();
        if (evaluatedAfter != null) {
            query.evaluatedAfter(evaluatedAfter);
        }
        new Pagination().pageSize(this.properties.getPageSize()).query(query).maxCount(() -> ((HistoricDecisionInstanceQueryImpl)query).count()).callback(callback);
    }

    public void fetchAndHandleProcessDefinitions(Consumer<ProcessDefinition> callback, Date deployedAfter) {
        ProcessDefinitionQueryImpl query = (ProcessDefinitionQueryImpl)((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByDeploymentTime().asc()).orderByProcessDefinitionId().asc();
        if (deployedAfter != null) {
            query.deployedAfter(deployedAfter);
        }
        this.fetchAndHandleProcessDefinitions(query, callback);
    }

    public void fetchAndHandleProcessDefinitions(Consumer<ProcessDefinition> callback, String[] ids) {
        ProcessDefinitionQueryImpl query = (ProcessDefinitionQueryImpl)this.repositoryService.createProcessDefinitionQuery().orderByDeploymentTime().processDefinitionIdIn(ids);
        this.fetchAndHandleProcessDefinitions(query, callback);
    }

    public void fetchAndHandleProcessDefinitions(ProcessDefinitionQueryImpl query, Consumer<ProcessDefinition> callback) {
        new Pagination().pageSize(this.properties.getPageSize()).query(query).maxCount(() -> ((ProcessDefinitionQueryImpl)query).count()).callback(callback);
    }

    public void fetchAndHandleDecisionDefinitions(Consumer<DecisionDefinition> callback, Date deployedAfter) {
        DecisionDefinitionQuery query = (DecisionDefinitionQuery)((DecisionDefinitionQuery)this.repositoryService.createDecisionDefinitionQuery().orderByDeploymentTime().asc()).orderByDecisionDefinitionId().asc();
        if (deployedAfter != null) {
            query.deployedAfter(deployedAfter);
        }
        new Pagination().pageSize(this.properties.getPageSize()).query(query).maxCount(() -> ((DecisionDefinitionQuery)query).count()).callback(callback);
    }

    public void fetchAndHandleDecisionRequirementsDefinitions(Consumer<DecisionRequirementsDefinition> callback) {
        DecisionRequirementsDefinitionQuery query = (DecisionRequirementsDefinitionQuery)this.repositoryService.createDecisionRequirementsDefinitionQuery().orderByDecisionRequirementsDefinitionId().asc();
        new Pagination().pageSize(this.properties.getPageSize()).query(query).maxCount(() -> ((DecisionRequirementsDefinitionQuery)query).count()).callback(callback);
    }

    public void fetchAndHandleHistoricIncidents(Consumer<HistoricIncident> callback, Date createdAfter) {
        HistoricIncidentQueryImpl query = (HistoricIncidentQueryImpl)((HistoricIncidentQuery)this.historyService.createHistoricIncidentQuery().orderByCreateTime().asc()).orderByIncidentId().asc();
        if (createdAfter != null) {
            query.createTimeAfter(createdAfter);
        }
        new Pagination().pageSize(this.properties.getPageSize()).query(query).maxCount(() -> ((HistoricIncidentQueryImpl)query).count()).callback(callback);
    }

    public void fetchAndHandleHistoricVariables(Consumer<HistoricVariableInstance> callback, String latestLegacyId) {
        HistoricVariableInstanceQueryImpl query = (HistoricVariableInstanceQueryImpl)this.historyService.createHistoricVariableInstanceQuery().orderByVariableId().asc();
        if (latestLegacyId != null) {
            query.idAfter(latestLegacyId);
        }
        new Pagination().pageSize(this.properties.getPageSize()).query(query).maxCount(() -> ((HistoricVariableInstanceQueryImpl)query).count()).callback(callback);
    }

    public void fetchAndHandleHistoricUserTasks(Consumer<HistoricTaskInstance> callback, Date startedAfter) {
        HistoricTaskInstanceQueryImpl query = (HistoricTaskInstanceQueryImpl)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().orderByHistoricActivityInstanceStartTime().asc()).orderByTaskId().asc();
        if (startedAfter != null) {
            query.startedAfter(startedAfter);
        }
        new Pagination().pageSize(this.properties.getPageSize()).query(query).maxCount(() -> ((HistoricTaskInstanceQueryImpl)query).count()).callback(callback);
    }

    public void fetchAndHandleHistoricFlowNodes(Consumer<HistoricActivityInstance> callback, Date startedAfter) {
        HistoricActivityInstanceQueryImpl query = (HistoricActivityInstanceQueryImpl)((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByHistoricActivityInstanceStartTime().asc()).orderByHistoricActivityInstanceId().asc();
        if (startedAfter != null) {
            query.startedAfter(startedAfter);
        }
        new Pagination().pageSize(this.properties.getPageSize()).query(query).maxCount(() -> ((HistoricActivityInstanceQueryImpl)query).count()).callback(callback);
    }
}

