/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.migrator.impl;

import io.camunda.client.api.response.ActivatedJob;
import io.camunda.migrator.exception.VariableInterceptorException;
import io.camunda.migrator.impl.clients.C7Client;
import io.camunda.migrator.impl.clients.C8Client;
import io.camunda.migrator.impl.logging.VariableServiceLogs;
import io.camunda.migrator.impl.model.ActivityVariables;
import io.camunda.migrator.interceptor.VariableInterceptor;
import io.camunda.migrator.interceptor.VariableInvocation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VariableService {
    @Autowired
    private C7Client c7Client;
    @Autowired
    private C8Client c8Client;
    @Autowired(required=false)
    protected List<VariableInterceptor> configuredVariableInterceptors;

    public Map<String, Object> getGlobalVariables(String legacyProcessInstanceId) {
        ActivityVariables activityVariables = this.processVariablesToActivityGroups(this.c7Client.getAllVariables(legacyProcessInstanceId));
        Map<String, Object> globalVariables = activityVariables.getGlobalVariables(legacyProcessInstanceId);
        globalVariables.put("legacyId", legacyProcessInstanceId);
        return globalVariables;
    }

    public Map<String, Object> getLocalVariables(String activityInstanceId, String subProcessInstanceId) {
        Map<String, Object> localVariables = this.processVariablesToMapSingleActivity(this.c7Client.getLocalVariables(activityInstanceId));
        if (subProcessInstanceId != null) {
            localVariables.put("legacyId", subProcessInstanceId);
        }
        return localVariables;
    }

    public boolean isExternallyStartedJob(ActivatedJob job) {
        return !job.getVariables().contains("legacyId");
    }

    public String getLegacyIdFromJob(ActivatedJob job) {
        return (String)this.c8Client.getJobVariable(job, "legacyId");
    }

    private boolean hasInterceptors() {
        return this.configuredVariableInterceptors != null && !this.configuredVariableInterceptors.isEmpty();
    }

    public ActivityVariables processVariablesToActivityGroups(List<VariableInstance> variables) {
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        for (VariableInstance variable : variables) {
            VariableInvocation variableInvocation = new VariableInvocation((VariableInstanceEntity)variable);
            this.executeInterceptors(variableInvocation);
            String activityInstanceId = variable.getActivityInstanceId();
            Map variableMap = result.computeIfAbsent(activityInstanceId, k -> new HashMap());
            variableMap.put(variableInvocation.getMigrationVariable().getName(), variableInvocation.getMigrationVariable().getValue());
        }
        return new ActivityVariables(result);
    }

    public Map<String, Object> processVariablesToMapSingleActivity(List<VariableInstance> variables) {
        HashMap<String, Object> variableResult = new HashMap<String, Object>();
        for (VariableInstance variable : variables) {
            VariableInvocation variableInvocation = new VariableInvocation((VariableInstanceEntity)variable);
            this.executeInterceptors(variableInvocation);
            variableResult.put(variableInvocation.getMigrationVariable().getName(), variableInvocation.getMigrationVariable().getValue());
        }
        return variableResult;
    }

    private void executeInterceptors(VariableInvocation variableInvocation) {
        if (this.hasInterceptors()) {
            for (VariableInterceptor interceptor : this.configuredVariableInterceptors) {
                try {
                    interceptor.execute(variableInvocation);
                }
                catch (Exception ex) {
                    String interceptorName = interceptor.getClass().getSimpleName();
                    String variableName = variableInvocation.getC7Variable().getName();
                    VariableServiceLogs.logInterceptorWarn(interceptorName, variableName);
                    if (ex instanceof VariableInterceptorException) {
                        throw ex;
                    }
                    throw new VariableInterceptorException(VariableServiceLogs.formatInterceptorWarn(interceptorName, variableName), ex);
                }
            }
        }
    }
}

