/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.migrator.impl;

import io.camunda.client.api.search.response.ProcessDefinition;
import io.camunda.client.api.search.response.SearchResponse;
import io.camunda.migrator.config.property.MigratorProperties;
import io.camunda.migrator.impl.clients.C7Client;
import io.camunda.migrator.impl.clients.C8Client;
import io.camunda.migrator.impl.logging.RuntimeValidatorLogs;
import io.camunda.migrator.impl.model.FlowNode;
import io.camunda.migrator.impl.util.C7Utils;
import io.camunda.migrator.impl.util.ExceptionUtils;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.impl.instance.ProcessImpl;
import io.camunda.zeebe.model.bpmn.impl.instance.zeebe.ZeebeExecutionListenersImpl;
import io.camunda.zeebe.model.bpmn.instance.CallActivity;
import io.camunda.zeebe.model.bpmn.instance.ExtensionElements;
import io.camunda.zeebe.model.bpmn.instance.StartEvent;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeCalledElement;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeIoMapping;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.model.bpmn.instance.Activity;
import org.camunda.bpm.model.bpmn.instance.FlowElement;
import org.camunda.bpm.model.bpmn.instance.MultiInstanceLoopCharacteristics;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RuntimeValidator {
    @Autowired
    protected MigratorProperties properties;
    @Autowired
    protected C7Client c7Client;
    @Autowired
    protected C8Client c8Client;

    public void validateC7FlowNodes(String processDefinitionId, String activityId) {
        org.camunda.bpm.model.bpmn.BpmnModelInstance c7BpmnModelInstance = this.c7Client.getBpmnModelInstance(processDefinitionId);
        FlowElement element = (FlowElement)c7BpmnModelInstance.getModelElementById(activityId);
        if (this.isMultiInstanceActivity(activityId, element)) {
            String activityIdWithoutSuffix = activityId.replace("#multiInstanceBody", "");
            throw new IllegalStateException(String.format("Found multi-instance loop characteristics for flow node with id [%s] in C7 process instance.", activityIdWithoutSuffix));
        }
    }

    public void validateC8Process(String xmlString, ProcessDefinition procDef) {
        BpmnModelInstance bpmnModelInstance = this.parseBpmnModel(xmlString);
        List<StartEvent> processInstanceStartEvents = bpmnModelInstance.getDefinitions().getModelInstance().getModelElementsByType(StartEvent.class).stream().filter(startEvent -> startEvent.getParentElement() instanceof ProcessImpl).toList();
        boolean hasNoneStartEvent = processInstanceStartEvents.stream().anyMatch(startEvent -> startEvent.getEventDefinitions().isEmpty());
        if (!hasNoneStartEvent) {
            throw new IllegalStateException(String.format("C8 process definition [id: %s, version: %d] should have a None Start Event.", procDef.getProcessDefinitionId(), procDef.getVersion()));
        }
        if (this.properties.isJobTypeValidationDisabled()) {
            RuntimeValidatorLogs.jobTypeValidationDisabled();
            return;
        }
        String validationJobType = this.properties.getEffectiveValidationJobType();
        processInstanceStartEvents.forEach(startEvent -> {
            boolean hasMigratorListener;
            ZeebeExecutionListenersImpl zBExecutionListeners = (ZeebeExecutionListenersImpl)startEvent.getSingleExtensionElement(ZeebeExecutionListenersImpl.class);
            boolean bl = hasMigratorListener = zBExecutionListeners != null && zBExecutionListeners.getExecutionListeners().stream().anyMatch(listener -> validationJobType.equals(listener.getType()));
            if (!hasMigratorListener) {
                throw new IllegalStateException(String.format("No execution listener of type '%s' found on start event [%s] for C8 process definition [id: %s, version: %d]. At least one '%s' listener is required.", validationJobType, startEvent.getId(), procDef.getProcessDefinitionId(), procDef.getVersion(), validationJobType));
            }
        });
    }

    public void validateC8FlowNodes(String xmlString, String activityId) {
        CallActivity callActivity;
        ExtensionElements extensionElements;
        BpmnModelInstance bpmnModelInstance = this.parseBpmnModel(xmlString);
        ModelElementInstance element = bpmnModelInstance.getModelElementById(activityId);
        if (element == null) {
            throw new IllegalStateException(String.format("Flow node with id [%s] doesn't exist in the equivalent deployed C8 model.", activityId));
        }
        if (element instanceof CallActivity && (extensionElements = (callActivity = (CallActivity)element).getExtensionElements()) != null) {
            List calledElements = extensionElements.getElementsQuery().filterByType(ZeebeCalledElement.class).list();
            for (ZeebeCalledElement calledElement : calledElements) {
                List ioMappings;
                boolean hasLegacyIdMapping;
                String propagateAllParentVariables = calledElement.getDomElement().getAttribute("propagateAllParentVariables");
                if (!"false".equalsIgnoreCase(propagateAllParentVariables) || (hasLegacyIdMapping = (ioMappings = extensionElements.getElementsQuery().filterByType(ZeebeIoMapping.class).list()).stream().flatMap(mapping -> mapping.getInputs().stream()).anyMatch(input -> "legacyId".equals(input.getTarget())))) continue;
                throw new IllegalStateException(String.format("Found call activity with propagateAllParentVariables=false for flow node with id [%s] in C8 process. This is not supported by the migrator unless there is an explicit mapping for the legacyId variable, as it would lead to orphaned sub-process instances.", activityId));
            }
        }
    }

    public void validateC8DefinitionExists(List<ProcessDefinition> c8Definitions, String c8DefinitionId, String legacyProcessInstanceId) {
        if (c8Definitions.isEmpty()) {
            throw new IllegalStateException(String.format("No C8 deployment found for process ID [%s] required for instance with legacyID [%s].", c8DefinitionId, legacyProcessInstanceId));
        }
    }

    private BpmnModelInstance parseBpmnModel(String xmlString) {
        return ExceptionUtils.callApi(() -> Bpmn.readModelFromStream((InputStream)new ByteArrayInputStream(xmlString.getBytes(StandardCharsets.UTF_8))), "Failed to parse BPMN model from XML");
    }

    private boolean isMultiInstanceActivity(String activityId, FlowElement element) {
        Activity activity;
        boolean isMultiInstanceBody = activityId.endsWith("#multiInstanceBody");
        if (isMultiInstanceBody) {
            return true;
        }
        boolean hasMultiInstanceCharacteristics = element instanceof Activity && (activity = (Activity)element).getLoopCharacteristics() instanceof MultiInstanceLoopCharacteristics;
        return hasMultiInstanceCharacteristics;
    }

    public void validateProcessInstanceState(String legacyProcessInstanceId) {
        RuntimeValidatorLogs.validateLegacyProcessInstance(legacyProcessInstanceId);
        this.c7Client.fetchAndHandleProcessInstances(processInstance -> {
            String processInstanceId = processInstance.getId();
            String c7DefinitionId = processInstance.getProcessDefinitionId();
            String c8DefinitionId = processInstance.getProcessDefinitionKey();
            String tenantId = processInstance.getTenantId();
            if (tenantId != null) {
                throw new IllegalStateException("Process instance with an assigned tenant ID is currently not supported.");
            }
            SearchResponse<ProcessDefinition> c8Definitions = this.c8Client.searchProcessDefinitions(c8DefinitionId);
            this.validateC8DefinitionExists(c8Definitions.items(), c8DefinitionId, processInstanceId);
            ActivityInstance activityInstanceTree = this.c7Client.getActivityInstance(processInstanceId);
            ProcessDefinition c8ProcessDefinition = (ProcessDefinition)c8Definitions.items().getFirst();
            String c8XmlString = this.c8Client.getProcessDefinitionXml(c8ProcessDefinition.getProcessDefinitionKey());
            this.validateC8Process(c8XmlString, c8ProcessDefinition);
            RuntimeValidatorLogs.collectingActiveDescendantActivitiesValidation(processInstanceId);
            Map<String, FlowNode> activityInstanceMap = C7Utils.getActiveActivityIdsById(activityInstanceTree, new HashMap<String, FlowNode>());
            RuntimeValidatorLogs.foundActiveActivitiesToValidate(activityInstanceMap.size());
            for (FlowNode flowNode : activityInstanceMap.values()) {
                this.validateC7FlowNodes(c7DefinitionId, flowNode.activityId());
                this.validateC8FlowNodes(c8XmlString, flowNode.activityId());
            }
        }, legacyProcessInstanceId);
    }
}

