/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.migrator.impl;

import io.camunda.migrator.impl.logging.PaginationLogs;
import io.camunda.migrator.impl.util.ExceptionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.camunda.bpm.engine.query.Query;

public class Pagination<T> {
    protected int pageSize;
    protected Supplier<Long> maxCount;
    protected Function<Integer, List<T>> page;
    protected Query<?, T> query;

    public Pagination<T> pageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public Pagination<T> maxCount(Supplier<Long> maxCount) {
        this.maxCount = maxCount;
        return this;
    }

    public Pagination<T> page(Function<Integer, List<T>> page) {
        this.page = page;
        return this;
    }

    public Pagination<T> query(Query<?, T> query) {
        this.query = query;
        return this;
    }

    public void callback(Consumer<T> callback) {
        Function<Integer, List> result;
        Long maxCount = null;
        if (this.query != null) {
            maxCount = this.query.count();
            result = offset -> this.query.listPage(offset.intValue(), this.pageSize);
        } else if (this.page != null) {
            maxCount = ExceptionUtils.callApi(this.maxCount);
            result = offset -> this.page.apply((Integer)offset).stream().toList();
        } else {
            PaginationLogs.errorQueryAndPageNull();
            throw new IllegalStateException("Query and page cannot be null");
        }
        int i = 0;
        while ((long)i < maxCount) {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            int offset2 = i;
            String methodName = stackTrace[2].getMethodName();
            PaginationLogs.paginationDebugInfo(methodName, maxCount, offset2, this.pageSize);
            ExceptionUtils.callApi(() -> (List)result.apply(offset2)).forEach(callback);
            i += this.pageSize;
        }
    }

    public List<T> toList() {
        ArrayList list = new ArrayList();
        this.callback(list::add);
        return list;
    }
}

