/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.migrator.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.migrator.exception.VariableInterceptorException;
import io.camunda.migrator.impl.logging.VariableServiceLogs;
import io.camunda.migrator.interceptor.VariableInterceptor;
import io.camunda.migrator.interceptor.VariableInvocation;
import java.util.Map;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.impl.value.ObjectValueImpl;
import org.camunda.bpm.engine.variable.type.FileValueType;
import org.camunda.bpm.engine.variable.type.PrimitiveValueType;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.camunda.spin.plugin.variable.type.SpinValueType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order(value=0)
@Component
public class BuiltInVariableTransformer
implements VariableInterceptor {
    @Autowired
    protected ObjectMapper objectMapper;

    @Override
    public void execute(VariableInvocation invocation) {
        VariableServiceLogs.logStartExecution(this.getClass(), invocation.getC7Variable().getName());
        VariableInstanceEntity variable = invocation.getC7Variable();
        TypedValue typedValue = variable.getTypedValue(false);
        if (ValueType.OBJECT.equals((Object)typedValue.getType()) && Variables.SerializationDataFormats.JSON.getName().equals(((ObjectValueImpl)typedValue).getSerializationDataFormat())) {
            this.setJsonVariable(invocation, ((ObjectValueImpl)typedValue).getValueSerialized());
        } else if (ValueType.OBJECT.equals((Object)typedValue.getType()) && Variables.SerializationDataFormats.XML.getName().equals(((ObjectValueImpl)typedValue).getSerializationDataFormat())) {
            invocation.setVariableValue(((ObjectValueImpl)typedValue).getValueSerialized());
        } else if (SpinValueType.JSON.equals((Object)typedValue.getType())) {
            this.setJsonVariable(invocation, typedValue.getValue().toString());
        } else if (SpinValueType.XML.equals((Object)typedValue.getType())) {
            invocation.setVariableValue(typedValue.getValue().toString());
        } else if (typedValue.getType() instanceof PrimitiveValueType) {
            if (typedValue.getValue() instanceof byte[]) {
                throw new VariableInterceptorException("Variable of type 'byte[]' is unsupported in C8.", null);
            }
            invocation.setVariableValue(variable.getValue());
        } else {
            if (typedValue.getType() instanceof FileValueType) {
                throw new VariableInterceptorException("Variable of type 'file' is unsupported in C8.", null);
            }
            if (ValueType.OBJECT.equals((Object)typedValue.getType()) && Variables.SerializationDataFormats.JAVA.getName().equals(((ObjectValueImpl)typedValue).getSerializationDataFormat())) {
                throw new VariableInterceptorException("Objects serialized as 'application/x-java-serialized-object' are unsupported in C8.", null);
            }
            throw new VariableInterceptorException(String.format("Variable of type '%s' is unsupported in C8.", typedValue.getType().toString()), null);
        }
        VariableServiceLogs.logEndExecution(this.getClass(), invocation.getC7Variable().getName());
    }

    protected void setJsonVariable(VariableInvocation invocation, String jsonString) {
        try {
            invocation.setVariableValue(this.objectMapper.readValue(jsonString, (TypeReference)new TypeReference<Map<String, Object>>(this){}));
        }
        catch (JsonProcessingException e) {
            throw new VariableInterceptorException("Error while deserializing JSON into Map type.", e);
        }
    }
}

