/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.migrator.impl;

import io.camunda.migrator.impl.logging.VariableServiceLogs;
import io.camunda.migrator.interceptor.VariableInterceptor;
import io.camunda.migrator.interceptor.VariableInvocation;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.camunda.bpm.engine.variable.value.DateValue;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order(value=10)
@Component
public class BuiltInDateVariableTransformer
implements VariableInterceptor {
    @Override
    public void execute(VariableInvocation invocation) {
        VariableInstanceEntity variable = invocation.getC7Variable();
        TypedValue typedValue = variable.getTypedValue(false);
        if (typedValue instanceof DateValue) {
            DateValue value = (DateValue)typedValue;
            VariableServiceLogs.logConvertingDate(variable.getName());
            String formattedDate = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format((Date)value.getValue());
            VariableServiceLogs.logConvertedDate(variable.getName(), value.getValue(), formattedDate);
            invocation.setVariableValue(formattedDate);
        }
    }
}

