/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.migrator.impl;

import io.camunda.migrator.config.property.C8Properties;
import io.camunda.migrator.config.property.MigratorProperties;
import io.camunda.migrator.impl.clients.C8Client;
import io.camunda.migrator.impl.util.ExceptionUtils;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class AutoDeployer {
    @Autowired
    protected C8Client c8Client;
    @Autowired
    protected MigratorProperties migratorProperties;

    public void deploy() {
        this.c8Client.deployResources(this.getDeploymentResources());
    }

    public Set<Path> getDeploymentResources() {
        String deploymentDir;
        C8Properties c8Props = this.migratorProperties.getC8();
        if (c8Props != null && StringUtils.hasText((String)(deploymentDir = c8Props.getDeploymentDir()))) {
            Set<Path> set;
            block9: {
                Path resourceDir = Paths.get(deploymentDir, new String[0]);
                Stream<Path> stream = Files.walk(resourceDir, new FileVisitOption[0]);
                try {
                    set = stream.filter(file -> !Files.isDirectory(file, new LinkOption[0])).collect(Collectors.toSet());
                    if (stream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw ExceptionUtils.wrapException("Error occurred: shutting down Data Migrator gracefully.", e);
                    }
                }
                stream.close();
            }
            return set;
        }
        return Collections.emptySet();
    }
}

