/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.migrator.converter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.db.rdbms.write.domain.VariableDbModel;
import io.camunda.migrator.constants.MigratorConstants;
import io.camunda.migrator.impl.logging.VariableConverterLogs;
import io.camunda.migrator.impl.util.ConverterUtil;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.variable.impl.value.NullValueImpl;
import org.camunda.bpm.engine.variable.impl.value.ObjectValueImpl;
import org.camunda.bpm.engine.variable.impl.value.PrimitiveTypeValueImpl;
import org.springframework.beans.factory.annotation.Autowired;

public class VariableConverter {
    @Autowired
    private ObjectMapper objectMapper;

    public VariableDbModel apply(HistoricVariableInstance historicVariable, Long processInstanceKey, Long scopeKey) {
        return new VariableDbModel.VariableDbModelBuilder().variableKey(ConverterUtil.getNextKey()).name(historicVariable.getName()).value(this.convertValue(historicVariable)).scopeKey(scopeKey).processInstanceKey(processInstanceKey).processDefinitionId(historicVariable.getProcessDefinitionKey()).tenantId(ConverterUtil.getTenantId(historicVariable.getTenantId())).partitionId(MigratorConstants.C7_HISTORY_PARTITION_ID).historyCleanupDate(ConverterUtil.convertDate(historicVariable.getRemovalTime())).build();
    }

    private String convertValue(HistoricVariableInstance variable) {
        String variableId = variable.getId();
        if (this.isNullValueType(variable)) {
            VariableConverterLogs.convertingOfType(variableId, "NullValue");
            return null;
        }
        if (this.isPrimitiveType(variable)) {
            VariableConverterLogs.convertingOfType(variableId, "Primitive");
            Object typedValue = variable.getTypedValue().getValue();
            return typedValue != null ? typedValue.toString() : null;
        }
        if (this.isObjectType(variable)) {
            ObjectValueImpl typedValue = (ObjectValueImpl)variable.getTypedValue();
            Class objectType = typedValue.getObjectType();
            VariableConverterLogs.convertingOfType(variableId, objectType.getSimpleName());
            return this.getJsonValue(typedValue);
        }
        VariableConverterLogs.warnNoHandlingAvailable(variableId, "unknown");
        return null;
    }

    private boolean isNullValueType(HistoricVariableInstance variable) {
        return variable.getTypedValue() instanceof NullValueImpl;
    }

    private boolean isObjectType(HistoricVariableInstance variable) {
        return variable.getTypedValue() instanceof ObjectValueImpl;
    }

    private boolean isPrimitiveType(HistoricVariableInstance variable) {
        return variable.getTypedValue() instanceof PrimitiveTypeValueImpl;
    }

    private String getJsonValue(ObjectValueImpl typedValue) {
        try {
            return this.objectMapper.writeValueAsString(typedValue.getValue());
        }
        catch (JsonProcessingException e) {
            VariableConverterLogs.failedConvertingJson(typedValue, e.getMessage());
            return null;
        }
    }
}

