/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.migrator.converter;

import io.camunda.db.rdbms.write.domain.ProcessInstanceDbModel;
import io.camunda.migrator.constants.MigratorConstants;
import io.camunda.migrator.impl.clients.C7Client;
import io.camunda.migrator.impl.util.ConverterUtil;
import io.camunda.search.entities.ProcessInstanceEntity;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.springframework.beans.factory.annotation.Autowired;

public class ProcessInstanceConverter {
    @Autowired
    protected C7Client c7Client;

    public ProcessInstanceDbModel apply(HistoricProcessInstance processInstance, Long processDefinitionKey, Long parentProcessInstanceKey) {
        return new ProcessInstanceDbModel.ProcessInstanceDbModelBuilder().processInstanceKey(ConverterUtil.getNextKey()).processDefinitionKey(processDefinitionKey).processDefinitionId(processInstance.getProcessDefinitionKey()).startDate(ConverterUtil.convertDate(processInstance.getStartTime())).endDate(ConverterUtil.convertDate(processInstance.getEndTime())).state(this.convertState(processInstance.getState())).tenantId(this.getTenantId(processInstance)).version(processInstance.getProcessDefinitionVersion().intValue()).parentProcessInstanceKey(parentProcessInstanceKey).numIncidents(this.getIncidents(processInstance)).partitionId(MigratorConstants.C7_HISTORY_PARTITION_ID).historyCleanupDate(ConverterUtil.convertDate(processInstance.getRemovalTime())).build();
    }

    protected ProcessInstanceEntity.ProcessInstanceState convertState(String state) {
        return switch (state) {
            case "ACTIVE", "SUSPENDED" -> ProcessInstanceEntity.ProcessInstanceState.ACTIVE;
            case "COMPLETED" -> ProcessInstanceEntity.ProcessInstanceState.COMPLETED;
            case "EXTERNALLY_TERMINATED", "INTERNALLY_TERMINATED" -> ProcessInstanceEntity.ProcessInstanceState.CANCELED;
            default -> throw new IllegalArgumentException("Unknown state: " + state);
        };
    }

    protected String getTenantId(HistoricProcessInstance processInstance) {
        return processInstance != null ? ConverterUtil.getTenantId(processInstance.getTenantId()) : "<default>";
    }

    protected int getIncidents(HistoricProcessInstance processInstance) {
        return Math.toIntExact(this.c7Client.getIncidentsByProcessInstance(processInstance.getId()));
    }
}

