/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.migrator.converter;

import io.camunda.db.rdbms.write.domain.ProcessDefinitionDbModel;
import io.camunda.migrator.impl.clients.C7Client;
import io.camunda.migrator.impl.logging.ProcessDefinitionConverterLogs;
import io.camunda.migrator.impl.util.ConverterUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.springframework.beans.factory.annotation.Autowired;

public class ProcessDefinitionConverter {
    @Autowired
    private C7Client c7Client;

    public ProcessDefinitionDbModel apply(ProcessDefinition legacyProcessDefinition) {
        String bpmnXml = this.getBpmnXmlAsString(legacyProcessDefinition);
        return new ProcessDefinitionDbModel.ProcessDefinitionDbModelBuilder().processDefinitionKey(ConverterUtil.getNextKey()).processDefinitionId(legacyProcessDefinition.getKey()).resourceName(legacyProcessDefinition.getResourceName()).name(legacyProcessDefinition.getName()).tenantId(legacyProcessDefinition.getTenantId()).versionTag(legacyProcessDefinition.getVersionTag()).version(legacyProcessDefinition.getVersion()).bpmnXml(bpmnXml).formId(null).build();
    }

    private String getBpmnXmlAsString(ProcessDefinition processDefinition) {
        try {
            InputStream resourceStream = this.c7Client.getResourceAsStream(processDefinition.getDeploymentId(), processDefinition.getResourceName());
            return this.readInputStreamToString(resourceStream);
        }
        catch (IOException e) {
            ProcessDefinitionConverterLogs.failedFetchingResourceStream(processDefinition.getId(), e.getMessage());
            return null;
        }
    }

    private String readInputStreamToString(InputStream inputStream) throws IOException {
        int length;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = inputStream.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        return result.toString(StandardCharsets.UTF_8);
    }
}

