/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.migrator.converter;

import io.camunda.db.rdbms.write.domain.FlowNodeInstanceDbModel;
import io.camunda.migrator.impl.util.ConverterUtil;
import io.camunda.search.entities.FlowNodeInstanceEntity;
import org.camunda.bpm.engine.history.HistoricActivityInstance;

public class FlowNodeConverter {
    public FlowNodeInstanceDbModel apply(HistoricActivityInstance flowNode, Long processDefinitionKey, Long processInstanceKey) {
        return new FlowNodeInstanceDbModel.FlowNodeInstanceDbModelBuilder().flowNodeInstanceKey(ConverterUtil.getNextKey()).flowNodeId(flowNode.getActivityId()).processInstanceKey(processInstanceKey).processDefinitionKey(processDefinitionKey).processDefinitionId(flowNode.getProcessDefinitionKey()).startDate(ConverterUtil.convertDate(flowNode.getStartTime())).endDate(ConverterUtil.convertDate(flowNode.getEndTime())).type(this.convertType(flowNode.getActivityType())).tenantId(flowNode.getTenantId()).state(null).treePath(null).incidentKey(null).numSubprocessIncidents(null).build();
    }

    protected FlowNodeInstanceEntity.FlowNodeType convertType(String activityType) {
        return switch (activityType) {
            case "startEvent", "startTimerEvent", "messageStartEvent" -> FlowNodeInstanceEntity.FlowNodeType.START_EVENT;
            case "noneEndEvent" -> FlowNodeInstanceEntity.FlowNodeType.END_EVENT;
            case "serviceTask" -> FlowNodeInstanceEntity.FlowNodeType.SERVICE_TASK;
            case "userTask" -> FlowNodeInstanceEntity.FlowNodeType.USER_TASK;
            case "exclusiveGateway" -> FlowNodeInstanceEntity.FlowNodeType.EXCLUSIVE_GATEWAY;
            case "intermediateTimer", "intermediateSignalCatch" -> FlowNodeInstanceEntity.FlowNodeType.INTERMEDIATE_CATCH_EVENT;
            case "parallelGateway" -> FlowNodeInstanceEntity.FlowNodeType.PARALLEL_GATEWAY;
            case "businessRuleTask" -> FlowNodeInstanceEntity.FlowNodeType.BUSINESS_RULE_TASK;
            case "callActivity" -> FlowNodeInstanceEntity.FlowNodeType.CALL_ACTIVITY;
            case "scriptTask" -> FlowNodeInstanceEntity.FlowNodeType.SCRIPT_TASK;
            case "multiInstanceBody" -> FlowNodeInstanceEntity.FlowNodeType.MULTI_INSTANCE_BODY;
            case "errorStartEvent" -> FlowNodeInstanceEntity.FlowNodeType.START_EVENT;
            case "cancelEndEvent" -> FlowNodeInstanceEntity.FlowNodeType.END_EVENT;
            case "errorEndEvent" -> FlowNodeInstanceEntity.FlowNodeType.END_EVENT;
            case "subProcess" -> FlowNodeInstanceEntity.FlowNodeType.SUB_PROCESS;
            case "intermediateCompensationThrowEvent" -> FlowNodeInstanceEntity.FlowNodeType.INTERMEDIATE_THROW_EVENT;
            case "manualTask" -> FlowNodeInstanceEntity.FlowNodeType.MANUAL_TASK;
            case "receiveTask" -> FlowNodeInstanceEntity.FlowNodeType.RECEIVE_TASK;
            case "transaction" -> FlowNodeInstanceEntity.FlowNodeType.SUB_PROCESS;
            case "task" -> FlowNodeInstanceEntity.FlowNodeType.TASK;
            default -> throw new IllegalArgumentException("Unknown type: " + activityType);
        };
    }
}

