/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.migrator.converter;

import io.camunda.db.rdbms.write.domain.DecisionInstanceDbModel;
import io.camunda.migrator.constants.MigratorConstants;
import io.camunda.migrator.impl.util.ConverterUtil;
import io.camunda.search.entities.DecisionInstanceEntity;
import java.util.List;
import org.camunda.bpm.engine.history.HistoricDecisionInputInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInstance;
import org.camunda.bpm.engine.history.HistoricDecisionOutputInstance;

public class DecisionInstanceConverter {
    public DecisionInstanceDbModel apply(HistoricDecisionInstance decisionInstance, Long decisionDefinitionKey, Long processDefinitionKey, Long decisionRequirementsDefinitionKey, Long processInstanceKey, Long rootDecisionDefinitionKey, Long flowNodeInstanceKey, String flowNodeId) {
        Long decisionInstanceKey = ConverterUtil.getNextKey();
        return new DecisionInstanceDbModel.Builder().partitionId(MigratorConstants.C7_HISTORY_PARTITION_ID).decisionInstanceId(String.format("%d-%s", decisionInstanceKey, decisionInstance.getId())).decisionInstanceKey(decisionInstanceKey).state(DecisionInstanceEntity.DecisionInstanceState.UNSPECIFIED).evaluationDate(ConverterUtil.convertDate(decisionInstance.getEvaluationTime())).evaluationFailure(null).evaluationFailureMessage(null).result(String.valueOf(decisionInstance.getCollectResultValue())).flowNodeInstanceKey(flowNodeInstanceKey).flowNodeId(flowNodeId).processInstanceKey(processInstanceKey).processDefinitionKey(processDefinitionKey).processDefinitionId(decisionInstance.getProcessDefinitionKey()).decisionDefinitionKey(decisionDefinitionKey).decisionDefinitionId(decisionInstance.getDecisionDefinitionKey()).decisionRequirementsKey(decisionRequirementsDefinitionKey).decisionRequirementsId(decisionInstance.getDecisionRequirementsDefinitionKey()).rootDecisionDefinitionKey(rootDecisionDefinitionKey).decisionType(DecisionInstanceEntity.DecisionDefinitionType.UNSPECIFIED).tenantId(ConverterUtil.getTenantId(decisionInstance.getTenantId())).evaluatedInputs(this.mapInputs(decisionInstance.getId(), decisionInstance.getInputs())).evaluatedOutputs(this.mapOutputs(decisionInstance.getId(), decisionInstance.getOutputs())).historyCleanupDate(ConverterUtil.convertDate(decisionInstance.getRemovalTime())).build();
    }

    private List<DecisionInstanceDbModel.EvaluatedInput> mapInputs(String decisionInstanceId, List<HistoricDecisionInputInstance> legacyInputs) {
        return legacyInputs.stream().map(input -> new DecisionInstanceDbModel.EvaluatedInput(decisionInstanceId, input.getId(), input.getClauseName(), String.valueOf(input.getValue()))).toList();
    }

    private List<DecisionInstanceDbModel.EvaluatedOutput> mapOutputs(String decisionInstanceId, List<HistoricDecisionOutputInstance> legacyOutputs) {
        return legacyOutputs.stream().map(output -> new DecisionInstanceDbModel.EvaluatedOutput(decisionInstanceId, output.getId(), output.getClauseName(), String.valueOf(output.getValue()), output.getRuleId(), output.getRuleOrder())).toList();
    }
}

