/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.migrator.config.mybatis;

import io.camunda.migrator.config.mybatis.AbstractConfiguration;
import io.camunda.migrator.config.mybatis.DbVendorProvider;
import io.camunda.migrator.config.property.MigratorProperties;
import io.camunda.migrator.impl.persistence.IdKeyMapper;
import java.util.Properties;
import javax.sql.DataSource;
import liquibase.integration.spring.MultiTenantSpringLiquibase;
import org.apache.ibatis.mapping.DatabaseIdProvider;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.mapper.MapperFactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MigratorConfiguration
extends AbstractConfiguration {
    @Autowired
    @Qualifier(value="migratorDataSource")
    protected DataSource dataSource;

    @Bean
    @ConditionalOnProperty(prefix="camunda.migrator", name={"auto-ddl"}, havingValue="true")
    public MultiTenantSpringLiquibase createMigratorSchema() {
        return this.createSchema(this.dataSource, this.configProperties.getTablePrefix(), "db/changelog/migrator/db.changelog-master.yaml");
    }

    @Bean
    public SqlSessionFactory migratorSqlSessionFactory() throws Exception {
        DbVendorProvider dbVendorProvider = new DbVendorProvider(this.getC7OrC8DbVendor());
        String dbVendor = dbVendorProvider.getDatabaseId(this.dataSource);
        Properties properties = this.loadPropertiesFile(dbVendor, "db/properties/" + dbVendor + ".properties");
        String tablePrefix = this.configProperties.getTablePrefix();
        return this.createSqlSessionFactory(this.dataSource, (DatabaseIdProvider)dbVendorProvider, properties, tablePrefix);
    }

    @Bean
    public MapperFactoryBean<IdKeyMapper> idKeyMapper(@Qualifier(value="migratorSqlSessionFactory") SqlSessionFactory migratorSqlSessionFactory) {
        return this.createMapperFactoryBean(migratorSqlSessionFactory, IdKeyMapper.class);
    }

    public String getC7OrC8DbVendor() {
        if (MigratorProperties.DataSource.C7.equals((Object)this.configProperties.getDataSource())) {
            if (this.configProperties.getC7() != null && this.configProperties.getC7().getDataSource() != null) {
                return this.configProperties.getC7().getDataSource().getVendor();
            }
        } else if (MigratorProperties.DataSource.C8.equals((Object)this.configProperties.getDataSource()) && this.configProperties.getC8() != null && this.configProperties.getC8().getDataSource() != null) {
            return this.configProperties.getC8().getDataSource().getVendor();
        }
        return null;
    }
}

