/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.migrator.config.mybatis;

import java.util.Properties;
import javax.sql.DataSource;
import org.apache.ibatis.mapping.VendorDatabaseIdProvider;

public class DbVendorProvider
extends VendorDatabaseIdProvider {
    private static final Properties VENDOR_PROPERTIES = new Properties();
    private final String databaseIdOverride;

    public DbVendorProvider(String databaseIdOverride) {
        this.databaseIdOverride = databaseIdOverride;
        this.setProperties(VENDOR_PROPERTIES);
    }

    public String getDatabaseId(DataSource dataSource) {
        if (this.databaseIdOverride != null && !this.databaseIdOverride.isBlank()) {
            if (VENDOR_PROPERTIES.containsValue(this.databaseIdOverride)) {
                return this.databaseIdOverride;
            }
            throw new IllegalArgumentException("Invalid databaseIdOverride '" + this.databaseIdOverride + "', must be one of " + String.valueOf(VENDOR_PROPERTIES.values()));
        }
        String vendorId = super.getDatabaseId(dataSource);
        if (vendorId == null) {
            throw new IllegalArgumentException("Unable to detect database vendor");
        }
        return vendorId;
    }

    static {
        VENDOR_PROPERTIES.put("H2", "h2");
        VENDOR_PROPERTIES.put("PostgreSQL", "postgresql");
        VENDOR_PROPERTIES.put("Oracle", "oracle");
        VENDOR_PROPERTIES.put("MariaDB", "mariadb");
        VENDOR_PROPERTIES.put("MySQL", "mariadb");
    }
}

