/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.migrator.config.mybatis;

import io.camunda.migrator.config.property.MigratorProperties;
import io.camunda.migrator.impl.logging.ConfigurationLogs;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import liquibase.integration.spring.MultiTenantSpringLiquibase;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.mapping.DatabaseIdProvider;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.OffsetDateTimeTypeHandler;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.mapper.MapperFactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class AbstractConfiguration {
    @Autowired
    protected MigratorProperties configProperties;

    protected Properties loadPropertiesFile(String databaseId, String file) throws IOException {
        Properties properties;
        block7: {
            properties = new Properties();
            try (InputStream propertiesInputStream = this.getClass().getClassLoader().getResourceAsStream(file);){
                if (propertiesInputStream != null) {
                    properties.load(propertiesInputStream);
                    break block7;
                }
                throw new IllegalArgumentException("No vendor properties found for databaseId " + databaseId);
            }
        }
        return properties;
    }

    protected SqlSessionFactory createSqlSessionFactory(DataSource dataSource, DatabaseIdProvider databaseIdProvider, Properties databaseProperties, String tablePrefix) throws Exception {
        Configuration configuration = new Configuration();
        configuration.setJdbcTypeForNull(JdbcType.NULL);
        configuration.getTypeHandlerRegistry().register(OffsetDateTimeTypeHandler.class);
        SqlSessionFactoryBean factoryBean = new SqlSessionFactoryBean();
        factoryBean.setConfiguration(configuration);
        factoryBean.setDataSource(dataSource);
        factoryBean.setDatabaseIdProvider(databaseIdProvider);
        factoryBean.addMapperLocations(new PathMatchingResourcePatternResolver().getResources("classpath*:mapper/*.xml"));
        Properties p = new Properties();
        p.put("prefix", StringUtils.trimToEmpty((String)tablePrefix));
        p.putAll((Map<?, ?>)databaseProperties);
        factoryBean.setConfigurationProperties(p);
        return factoryBean.getObject();
    }

    protected <T> MapperFactoryBean<T> createMapperFactoryBean(SqlSessionFactory sqlSessionFactory, Class<T> clazz) {
        MapperFactoryBean factoryBean = new MapperFactoryBean(clazz);
        factoryBean.setSqlSessionFactory(sqlSessionFactory);
        return factoryBean;
    }

    protected MultiTenantSpringLiquibase createSchema(DataSource dataSource, String tablePrefix, String changeLogFile) {
        String prefix = StringUtils.trimToEmpty((String)tablePrefix);
        ConfigurationLogs.logCreatingTableSchema(changeLogFile, prefix);
        MultiTenantSpringLiquibase moduleConfig = new MultiTenantSpringLiquibase();
        moduleConfig.setDataSource(dataSource);
        moduleConfig.setDatabaseChangeLogTable(prefix + "DATABASECHANGELOG");
        moduleConfig.setDatabaseChangeLogLockTable(prefix + "DATABASECHANGELOGLOCK");
        moduleConfig.setParameters(Map.of("prefix", prefix));
        moduleConfig.setChangeLog(changeLogFile);
        return moduleConfig;
    }
}

