/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.migrator.config;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import io.camunda.migrator.HistoryMigrator;
import io.camunda.migrator.RuntimeMigrator;
import io.camunda.migrator.config.C8DataSourceConfigured;
import io.camunda.migrator.config.InterceptorConfiguration;
import io.camunda.migrator.config.JacksonConfiguration;
import io.camunda.migrator.config.mybatis.C8Configuration;
import io.camunda.migrator.config.mybatis.MigratorConfiguration;
import io.camunda.migrator.config.property.DataSourceProperties;
import io.camunda.migrator.config.property.MigratorProperties;
import io.camunda.migrator.converter.ConverterConfiguration;
import io.camunda.migrator.impl.AutoDeployer;
import io.camunda.migrator.impl.BuiltInDateVariableTransformer;
import io.camunda.migrator.impl.BuiltInVariableTransformer;
import io.camunda.migrator.impl.RuntimeValidator;
import io.camunda.migrator.impl.VariableService;
import io.camunda.migrator.impl.clients.C7Client;
import io.camunda.migrator.impl.clients.C8Client;
import io.camunda.migrator.impl.clients.DbClient;
import java.util.Optional;
import javax.sql.DataSource;
import liquibase.integration.spring.SpringLiquibase;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.spring.ProcessEngineFactoryBean;
import org.camunda.bpm.engine.spring.SpringProcessEngineConfiguration;
import org.camunda.bpm.engine.spring.SpringProcessEngineServicesConfiguration;
import org.camunda.spin.plugin.impl.SpinProcessEnginePlugin;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;

@Import(value={SpringProcessEngineServicesConfiguration.class, JacksonConfiguration.class, C8Configuration.class, MigratorConfiguration.class, ConverterConfiguration.class, InterceptorConfiguration.class, AutoDeployer.class, C7Client.class, C8Client.class, DbClient.class, VariableService.class, RuntimeValidator.class, HistoryMigrator.class, RuntimeMigrator.class})
@Configuration
@EnableConfigurationProperties(value={MigratorProperties.class})
public class MigratorAutoConfiguration {
    private final MigratorProperties migratorProperties;
    @Autowired
    protected DataSource c7DataSource;
    @Autowired
    protected PlatformTransactionManager c7TransactionManager;

    public MigratorAutoConfiguration(MigratorProperties migratorProperties) {
        this.migratorProperties = migratorProperties;
    }

    @Bean
    public SpringLiquibase liquibase() {
        SpringLiquibase liquibase = new SpringLiquibase();
        liquibase.setShouldRun(false);
        return liquibase;
    }

    @Bean
    public BuiltInVariableTransformer defaultVariableInterceptor() {
        return new BuiltInVariableTransformer();
    }

    @Bean
    public BuiltInDateVariableTransformer dateVariableInterceptor() {
        return new BuiltInDateVariableTransformer();
    }

    @Bean
    @ConditionalOnMissingBean(value={ProcessEngineConfigurationImpl.class})
    public ProcessEngineConfigurationImpl processEngineConfiguration() {
        SpringProcessEngineConfiguration config = new SpringProcessEngineConfiguration();
        config.setDataSource(this.c7DataSource);
        config.setTransactionManager(this.c7TransactionManager);
        config.setHistory("auto");
        config.setJobExecutorActivate(false);
        config.setMetricsEnabled(false);
        String tablePrefix = this.migratorProperties.getC7().getDataSource().getTablePrefix();
        if (tablePrefix != null) {
            config.setDatabaseTablePrefix(tablePrefix);
        }
        config.getProcessEnginePlugins().add(new SpinProcessEnginePlugin());
        if (this.migratorProperties.getC7().getDataSource().getAutoDdl() != null && this.migratorProperties.getC7().getDataSource().getAutoDdl().booleanValue()) {
            config.setDatabaseSchemaUpdate("true");
        }
        return config;
    }

    @Configuration
    static class PecConfiguration {
        @Autowired
        protected ProcessEngineConfigurationImpl processEngineConfiguration;

        PecConfiguration() {
        }

        @Bean
        @DependsOn(value={"migratorDataSource", "c7DataSource"})
        public ProcessEngineFactoryBean processEngineFactoryBean() {
            ProcessEngineFactoryBean factoryBean = new ProcessEngineFactoryBean();
            factoryBean.setProcessEngineConfiguration(this.processEngineConfiguration);
            return factoryBean;
        }
    }

    @Configuration
    static class DataSourcesConfiguration {
        protected final MigratorProperties migratorProperties;

        DataSourcesConfiguration(MigratorProperties migratorProperties) {
            this.migratorProperties = migratorProperties;
        }

        @Bean
        @Primary
        public DataSource c7DataSource() {
            DataSourceProperties props = this.migratorProperties.getC7().getDataSource();
            if (props.getJdbcUrl() == null) {
                return this.createDefaultDataSource(props);
            }
            return new HikariDataSource((HikariConfig)props);
        }

        @Bean
        public PlatformTransactionManager c7TransactionManager(DataSource c7DataSource) {
            return new DataSourceTransactionManager(c7DataSource);
        }

        @Bean
        @Conditional(value={C8DataSourceConfigured.class})
        public DataSource c8DataSource() {
            DataSourceProperties props = this.migratorProperties.getC8().getDataSource();
            if (props.getJdbcUrl() == null) {
                return this.createDefaultDataSource(props);
            }
            return new HikariDataSource((HikariConfig)props);
        }

        @Bean
        public DataSource migratorDataSource(@Qualifier(value="c7DataSource") DataSource c7DataSource, @Qualifier(value="c8DataSource") Optional<DataSource> c8DataSource) {
            if (MigratorProperties.DataSource.C7.equals((Object)this.migratorProperties.getDataSource())) {
                return c7DataSource;
            }
            if (MigratorProperties.DataSource.C8.equals((Object)this.migratorProperties.getDataSource()) && c8DataSource.isPresent()) {
                return c8DataSource.get();
            }
            return null;
        }

        protected HikariDataSource createDefaultDataSource(DataSourceProperties props) {
            props.setJdbcUrl("jdbc:h2:mem:migrator");
            return new HikariDataSource((HikariConfig)props);
        }
    }
}

