/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.migrator.config;

import io.camunda.migrator.config.property.InterceptorProperty;
import io.camunda.migrator.config.property.MigratorProperties;
import io.camunda.migrator.exception.MigratorException;
import io.camunda.migrator.impl.logging.ConfigurationLogs;
import io.camunda.migrator.interceptor.VariableInterceptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.bind.handler.NoUnboundElementsBindHandler;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.MapConfigurationPropertySource;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

@Configuration
public class InterceptorConfiguration {
    @Autowired
    protected ApplicationContext context;
    @Autowired
    protected MigratorProperties migratorProperties;

    @Bean
    public List<VariableInterceptor> configuredVariableInterceptors() {
        ConfigurationLogs.logConfiguringInterceptors();
        ArrayList<VariableInterceptor> contextInterceptors = new ArrayList<VariableInterceptor>(this.context.getBeansOfType(VariableInterceptor.class).values());
        this.registerYamlInterceptors(contextInterceptors, this.migratorProperties.getInterceptors());
        AnnotationAwareOrderComparator.sort(contextInterceptors);
        ConfigurationLogs.logTotalInterceptorsConfigured(contextInterceptors.size());
        return contextInterceptors;
    }

    public void registerYamlInterceptors(List<VariableInterceptor> contextInterceptors, List<InterceptorProperty> yamlInterceptors) {
        if (yamlInterceptors == null || yamlInterceptors.isEmpty()) {
            ConfigurationLogs.logNoYamlInterceptors();
            return;
        }
        for (InterceptorProperty interceptorProperty : yamlInterceptors) {
            try {
                VariableInterceptor interceptor = this.createInterceptorInstance(interceptorProperty);
                contextInterceptors.add(interceptor);
                ConfigurationLogs.logSuccessfullyRegistered(interceptorProperty.getClassName());
            }
            catch (Exception e) {
                ConfigurationLogs.logFailedToRegister(interceptorProperty.getClassName(), e);
                throw new MigratorException(ConfigurationLogs.getFailedToRegisterError(interceptorProperty.getClassName()), e);
            }
        }
    }

    protected VariableInterceptor createInterceptorInstance(InterceptorProperty interceptorProperty) throws Exception {
        String className = interceptorProperty.getClassName();
        if (className == null || className.trim().isEmpty()) {
            throw new IllegalArgumentException(ConfigurationLogs.getClassNameNullOrEmptyError());
        }
        ConfigurationLogs.logCreatingInstance(className);
        Class<?> clazz = Class.forName(className);
        if (!VariableInterceptor.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(ConfigurationLogs.getClassNotImplementInterfaceError(className));
        }
        VariableInterceptor interceptor = (VariableInterceptor)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        Map<String, Object> properties = interceptorProperty.getProperties();
        if (properties != null && !properties.isEmpty()) {
            ConfigurationLogs.logSettingProperties(className);
            InterceptorConfiguration.applyProperties(interceptor, properties, false);
        }
        return interceptor;
    }

    protected static <T> void applyProperties(T target, Map<String, Object> sourceMap, boolean ignoreUnknownFields) {
        MapConfigurationPropertySource source = new MapConfigurationPropertySource(sourceMap);
        Binder binder = new Binder(new ConfigurationPropertySource[]{source});
        try {
            if (ignoreUnknownFields) {
                binder.bind(ConfigurationPropertyName.EMPTY, Bindable.ofInstance(target));
            } else {
                binder.bind(ConfigurationPropertyName.EMPTY, Bindable.ofInstance(target), (BindHandler)new NoUnboundElementsBindHandler(BindHandler.DEFAULT));
            }
        }
        catch (Exception e) {
            throw new MigratorException(ConfigurationLogs.getParsingConfigurationError(), e);
        }
    }
}

