/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.migrator;

import io.camunda.client.api.response.ActivatedJob;
import io.camunda.migrator.MigratorMode;
import io.camunda.migrator.config.property.MigratorProperties;
import io.camunda.migrator.exception.VariableInterceptorException;
import io.camunda.migrator.impl.RuntimeValidator;
import io.camunda.migrator.impl.VariableService;
import io.camunda.migrator.impl.clients.C7Client;
import io.camunda.migrator.impl.clients.C8Client;
import io.camunda.migrator.impl.clients.DbClient;
import io.camunda.migrator.impl.logging.RuntimeMigratorLogs;
import io.camunda.migrator.impl.model.FlowNode;
import io.camunda.migrator.impl.model.FlowNodeActivation;
import io.camunda.migrator.impl.persistence.IdKeyDbModel;
import io.camunda.migrator.impl.persistence.IdKeyMapper;
import io.camunda.migrator.impl.util.C7Utils;
import io.camunda.migrator.impl.util.ExceptionUtils;
import io.camunda.migrator.impl.util.PrintUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RuntimeMigrator {
    @Autowired
    protected C7Client c7Client;
    @Autowired
    protected C8Client c8Client;
    @Autowired
    protected DbClient dbClient;
    @Autowired
    protected VariableService variableService;
    @Autowired
    protected RuntimeValidator runtimeValidator;
    @Autowired
    protected MigratorProperties migratorProperties;
    protected MigratorMode mode = MigratorMode.MIGRATE;

    public void start() {
        try {
            ExceptionUtils.setContext(ExceptionUtils.ExceptionContext.RUNTIME);
            if (MigratorMode.LIST_SKIPPED.equals((Object)this.mode)) {
                PrintUtils.printSkippedInstancesHeader(this.dbClient.countSkippedByType(IdKeyMapper.TYPE.RUNTIME_PROCESS_INSTANCE), IdKeyMapper.TYPE.RUNTIME_PROCESS_INSTANCE);
                this.dbClient.listSkippedEntitiesByType(IdKeyMapper.TYPE.RUNTIME_PROCESS_INSTANCE);
            } else {
                this.migrate();
            }
        }
        finally {
            ExceptionUtils.clearContext();
        }
    }

    protected void migrate() {
        this.fetchProcessInstancesToMigrate(legacyProcessInstance -> {
            String legacyProcessInstanceId = legacyProcessInstance.id();
            Date startDate = legacyProcessInstance.startDate();
            if (this.shouldStartProcessInstance(legacyProcessInstanceId)) {
                this.startProcessInstance(legacyProcessInstanceId, startDate);
            } else if (this.isUnknown(legacyProcessInstanceId)) {
                this.dbClient.insert(legacyProcessInstanceId, startDate, null, IdKeyMapper.TYPE.RUNTIME_PROCESS_INSTANCE);
            }
        });
        this.activateMigratorJobs();
    }

    protected boolean shouldStartProcessInstance(String legacyProcessInstanceId) {
        if (this.skipProcessInstance(legacyProcessInstanceId)) {
            return false;
        }
        return MigratorMode.RETRY_SKIPPED.equals((Object)this.mode) || this.isUnknown(legacyProcessInstanceId);
    }

    protected boolean isUnknown(String legacyProcessInstanceId) {
        return MigratorMode.MIGRATE.equals((Object)this.mode) && !this.dbClient.checkExistsByIdAndType(legacyProcessInstanceId, IdKeyMapper.TYPE.RUNTIME_PROCESS_INSTANCE);
    }

    protected void startProcessInstance(String legacyProcessInstanceId, Date startDate) {
        RuntimeMigratorLogs.startingNewC8ProcessInstance(legacyProcessInstanceId);
        try {
            Long processInstanceKey = this.startNewProcessInstance(legacyProcessInstanceId);
            RuntimeMigratorLogs.startedC8ProcessInstance(processInstanceKey);
            if (processInstanceKey != null) {
                this.saveRecord(legacyProcessInstanceId, startDate, processInstanceKey);
            }
        }
        catch (VariableInterceptorException e) {
            this.handleVariableInterceptorException(e, legacyProcessInstanceId, startDate);
        }
    }

    protected void handleVariableInterceptorException(VariableInterceptorException e, String legacyProcessInstanceId, Date startDate) {
        RuntimeMigratorLogs.skippingProcessInstanceVariableError(legacyProcessInstanceId, e.getMessage());
        RuntimeMigratorLogs.stacktrace(e);
        if (MigratorMode.MIGRATE.equals((Object)this.mode)) {
            this.dbClient.insert(legacyProcessInstanceId, startDate, null, IdKeyMapper.TYPE.RUNTIME_PROCESS_INSTANCE);
        }
    }

    protected void saveRecord(String legacyProcessInstanceId, Date startDate, Long processInstanceKey) {
        if (MigratorMode.RETRY_SKIPPED.equals((Object)this.mode)) {
            this.dbClient.updateKeyByIdAndType(legacyProcessInstanceId, processInstanceKey, IdKeyMapper.TYPE.RUNTIME_PROCESS_INSTANCE);
        } else if (MigratorMode.MIGRATE.equals((Object)this.mode)) {
            this.dbClient.insert(legacyProcessInstanceId, startDate, processInstanceKey, IdKeyMapper.TYPE.RUNTIME_PROCESS_INSTANCE);
        }
    }

    protected boolean skipProcessInstance(String legacyProcessInstanceId) {
        try {
            this.runtimeValidator.validateProcessInstanceState(legacyProcessInstanceId);
        }
        catch (IllegalStateException e) {
            RuntimeMigratorLogs.skippingProcessInstanceValidationError(legacyProcessInstanceId, e.getMessage());
            return true;
        }
        return false;
    }

    protected void fetchProcessInstancesToMigrate(Consumer<IdKeyDbModel> storeMappingConsumer) {
        RuntimeMigratorLogs.fetchingProcessInstances();
        if (MigratorMode.RETRY_SKIPPED.equals((Object)this.mode)) {
            this.dbClient.fetchAndHandleSkippedForType(IdKeyMapper.TYPE.RUNTIME_PROCESS_INSTANCE, storeMappingConsumer);
        } else {
            RuntimeMigratorLogs.fetchingLatestStartDate();
            Date latestStartDate = this.dbClient.findLatestStartDateByType(IdKeyMapper.TYPE.RUNTIME_PROCESS_INSTANCE);
            RuntimeMigratorLogs.latestStartDate(latestStartDate);
            this.c7Client.fetchAndHandleHistoricRootProcessInstances(storeMappingConsumer, latestStartDate);
        }
    }

    protected Long startNewProcessInstance(String legacyProcessInstanceId) throws VariableInterceptorException {
        ProcessInstance processInstance = this.c7Client.getProcessInstance(legacyProcessInstanceId);
        if (processInstance != null) {
            String bpmnProcessId = processInstance.getProcessDefinitionKey();
            Map<String, Object> globalVariables = this.variableService.getGlobalVariables(legacyProcessInstanceId);
            return this.c8Client.createProcessInstance(bpmnProcessId, globalVariables).getProcessInstanceKey();
        }
        RuntimeMigratorLogs.processInstanceNotExists(legacyProcessInstanceId);
        return null;
    }

    protected void activateMigratorJobs() {
        List<ActivatedJob> migratorJobs;
        RuntimeMigratorLogs.activatingMigratorJobs();
        do {
            migratorJobs = this.c8Client.activateJobs(this.migratorProperties.getJobActivationType());
            RuntimeMigratorLogs.migratorJobsFound(migratorJobs.size());
            migratorJobs.forEach(job -> {
                boolean externallyStarted = this.variableService.isExternallyStartedJob((ActivatedJob)job);
                if (!externallyStarted) {
                    String legacyId = this.variableService.getLegacyIdFromJob((ActivatedJob)job);
                    ActivityInstance activityInstanceTree = this.c7Client.getActivityInstance(legacyId);
                    RuntimeMigratorLogs.collectingActiveDescendantActivities(activityInstanceTree.getActivityId());
                    Map<String, FlowNode> activityInstanceMap = C7Utils.getActiveActivityIdsById(activityInstanceTree, new HashMap<String, FlowNode>());
                    RuntimeMigratorLogs.foundActiveActivitiesToActivate(activityInstanceMap.size());
                    List<FlowNodeActivation> flowNodeActivations = activityInstanceMap.entrySet().stream().map(entry -> {
                        String activityInstanceId = (String)entry.getKey();
                        FlowNode flowNode = (FlowNode)entry.getValue();
                        Map<String, Object> localVariables = this.variableService.getLocalVariables(activityInstanceId, flowNode.subProcessInstanceId());
                        String activityId = flowNode.activityId();
                        return new FlowNodeActivation(activityId, localVariables);
                    }).collect(Collectors.toList());
                    long processInstanceKey = job.getProcessInstanceKey();
                    long elementInstanceKey = job.getElementInstanceKey();
                    this.c8Client.modifyProcessInstance(processInstanceKey, elementInstanceKey, flowNodeActivations);
                } else {
                    RuntimeMigratorLogs.externallyStartedProcessInstance(job.getProcessInstanceKey());
                }
            });
        } while (!migratorJobs.isEmpty());
    }

    public void setMode(MigratorMode mode) {
        this.mode = mode;
    }
}

