/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.migrator;

import io.camunda.db.rdbms.read.domain.DecisionDefinitionDbQuery;
import io.camunda.db.rdbms.read.domain.DecisionInstanceDbQuery;
import io.camunda.db.rdbms.read.domain.FlowNodeInstanceDbQuery;
import io.camunda.db.rdbms.read.domain.ProcessDefinitionDbQuery;
import io.camunda.db.rdbms.read.domain.ProcessInstanceDbQuery;
import io.camunda.db.rdbms.sql.DecisionDefinitionMapper;
import io.camunda.db.rdbms.sql.DecisionInstanceMapper;
import io.camunda.db.rdbms.sql.DecisionRequirementsMapper;
import io.camunda.db.rdbms.sql.FlowNodeInstanceMapper;
import io.camunda.db.rdbms.sql.IncidentMapper;
import io.camunda.db.rdbms.sql.ProcessDefinitionMapper;
import io.camunda.db.rdbms.sql.ProcessInstanceMapper;
import io.camunda.db.rdbms.sql.UserTaskMapper;
import io.camunda.db.rdbms.sql.VariableMapper;
import io.camunda.db.rdbms.write.domain.DecisionDefinitionDbModel;
import io.camunda.db.rdbms.write.domain.DecisionInstanceDbModel;
import io.camunda.db.rdbms.write.domain.DecisionRequirementsDbModel;
import io.camunda.db.rdbms.write.domain.FlowNodeInstanceDbModel;
import io.camunda.db.rdbms.write.domain.IncidentDbModel;
import io.camunda.db.rdbms.write.domain.ProcessDefinitionDbModel;
import io.camunda.db.rdbms.write.domain.ProcessInstanceDbModel;
import io.camunda.db.rdbms.write.domain.UserTaskDbModel;
import io.camunda.db.rdbms.write.domain.VariableDbModel;
import io.camunda.migrator.MigratorMode;
import io.camunda.migrator.config.C8DataSourceConfigured;
import io.camunda.migrator.converter.DecisionDefinitionConverter;
import io.camunda.migrator.converter.DecisionInstanceConverter;
import io.camunda.migrator.converter.DecisionRequirementsDefinitionConverter;
import io.camunda.migrator.converter.FlowNodeConverter;
import io.camunda.migrator.converter.IncidentConverter;
import io.camunda.migrator.converter.ProcessDefinitionConverter;
import io.camunda.migrator.converter.ProcessInstanceConverter;
import io.camunda.migrator.converter.UserTaskConverter;
import io.camunda.migrator.converter.VariableConverter;
import io.camunda.migrator.impl.clients.C7Client;
import io.camunda.migrator.impl.clients.DbClient;
import io.camunda.migrator.impl.logging.HistoryMigratorLogs;
import io.camunda.migrator.impl.persistence.IdKeyMapper;
import io.camunda.migrator.impl.util.ExceptionUtils;
import io.camunda.migrator.impl.util.PrintUtils;
import io.camunda.search.entities.DecisionDefinitionEntity;
import io.camunda.search.entities.DecisionInstanceEntity;
import io.camunda.search.entities.ProcessDefinitionEntity;
import io.camunda.search.entities.ProcessInstanceEntity;
import io.camunda.search.filter.FlowNodeInstanceFilter;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInstance;
import org.camunda.bpm.engine.history.HistoricIncident;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricTaskInstance;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.DecisionRequirementsDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={C8DataSourceConfigured.class})
public class HistoryMigrator {
    @Autowired
    private ProcessInstanceMapper processInstanceMapper;
    @Autowired
    private DecisionInstanceMapper decisionInstanceMapper;
    @Autowired
    private UserTaskMapper userTaskMapper;
    @Autowired
    private VariableMapper variableMapper;
    @Autowired
    private IncidentMapper incidentMapper;
    @Autowired
    private ProcessDefinitionMapper processDefinitionMapper;
    @Autowired
    private DecisionDefinitionMapper decisionDefinitionMapper;
    @Autowired
    private FlowNodeInstanceMapper flowNodeMapper;
    @Autowired
    private DecisionRequirementsMapper decisionRequirementsMapper;
    @Autowired
    protected DbClient dbClient;
    @Autowired
    protected C7Client c7Client;
    @Autowired
    private ProcessInstanceConverter processInstanceConverter;
    @Autowired
    private DecisionInstanceConverter decisionInstanceConverter;
    @Autowired
    private FlowNodeConverter flowNodeConverter;
    @Autowired
    private UserTaskConverter userTaskConverter;
    @Autowired
    private VariableConverter variableConverter;
    @Autowired
    private IncidentConverter incidentConverter;
    @Autowired
    private ProcessDefinitionConverter processDefinitionConverter;
    @Autowired
    private DecisionDefinitionConverter decisionDefinitionConverter;
    @Autowired
    private DecisionRequirementsDefinitionConverter decisionRequirementsConverter;
    protected MigratorMode mode = MigratorMode.MIGRATE;
    private List<IdKeyMapper.TYPE> requestedEntityTypes;

    public void start() {
        try {
            ExceptionUtils.setContext(ExceptionUtils.ExceptionContext.HISTORY);
            if (MigratorMode.LIST_SKIPPED.equals((Object)this.mode)) {
                this.printSkippedHistoryEntities();
            } else {
                this.migrate();
            }
        }
        finally {
            ExceptionUtils.clearContext();
        }
    }

    private void printSkippedHistoryEntities() {
        if (this.requestedEntityTypes == null || this.requestedEntityTypes.isEmpty()) {
            IdKeyMapper.getHistoryTypes().forEach(this::printSkippedEntitiesForType);
        } else {
            this.requestedEntityTypes.forEach(this::printSkippedEntitiesForType);
        }
    }

    private void printSkippedEntitiesForType(IdKeyMapper.TYPE type) {
        PrintUtils.printSkippedInstancesHeader(this.dbClient.countSkippedByType(type), type);
        this.dbClient.listSkippedEntitiesByType(type);
    }

    public void migrate() {
        this.migrateProcessDefinitions();
        this.migrateProcessInstances();
        this.migrateFlowNodes();
        this.migrateUserTasks();
        this.migrateVariables();
        this.migrateIncidents();
        this.migrateDecisionRequirementsDefinitions();
        this.migrateDecisionDefinitions();
        this.migrateDecisionInstances();
    }

    public void migrateProcessDefinitions() {
        HistoryMigratorLogs.migratingProcessDefinitions();
        if (MigratorMode.RETRY_SKIPPED.equals((Object)this.mode)) {
            this.dbClient.fetchAndHandleSkippedForType(IdKeyMapper.TYPE.HISTORY_PROCESS_DEFINITION, idKeyDbModel -> {
                ProcessDefinition historicProcessDefinition = this.c7Client.getProcessDefinition(idKeyDbModel.id());
                this.migrateProcessDefinition(historicProcessDefinition);
            });
        } else {
            this.c7Client.fetchAndHandleProcessDefinitions(this::migrateProcessDefinition, this.dbClient.findLatestStartDateByType(IdKeyMapper.TYPE.HISTORY_PROCESS_DEFINITION));
        }
    }

    private void migrateProcessDefinition(ProcessDefinition legacyProcessDefinition) {
        String legacyId = legacyProcessDefinition.getId();
        if (this.shouldMigrate(legacyId, IdKeyMapper.TYPE.HISTORY_PROCESS_DEFINITION)) {
            HistoryMigratorLogs.migratingProcessDefinition(legacyId);
            ProcessDefinitionDbModel dbModel = this.processDefinitionConverter.apply(legacyProcessDefinition);
            this.processDefinitionMapper.insert(dbModel);
            Date deploymentTime = this.c7Client.getDefinitionDeploymentTime(legacyProcessDefinition.getDeploymentId());
            this.saveRecord(legacyId, deploymentTime, dbModel.processDefinitionKey(), IdKeyMapper.TYPE.HISTORY_PROCESS_DEFINITION);
            HistoryMigratorLogs.migratingProcessDefinitionCompleted(legacyId);
        }
    }

    private void migrateProcessInstances() {
        HistoryMigratorLogs.migratingProcessInstances();
        if (MigratorMode.RETRY_SKIPPED.equals((Object)this.mode)) {
            this.dbClient.fetchAndHandleSkippedForType(IdKeyMapper.TYPE.HISTORY_PROCESS_INSTANCE, idKeyDbModel -> {
                HistoricProcessInstance historicProcessInstance = this.c7Client.getHistoricProcessInstance(idKeyDbModel.id());
                this.migrateProcessInstance(historicProcessInstance);
            });
        } else {
            this.c7Client.fetchAndHandleHistoricProcessInstances(this::migrateProcessInstance, this.dbClient.findLatestStartDateByType(IdKeyMapper.TYPE.HISTORY_PROCESS_INSTANCE));
        }
    }

    private void migrateProcessInstance(HistoricProcessInstance legacyProcessInstance) {
        String legacyProcessInstanceId = legacyProcessInstance.getId();
        if (this.shouldMigrate(legacyProcessInstanceId, IdKeyMapper.TYPE.HISTORY_PROCESS_INSTANCE)) {
            HistoryMigratorLogs.migratingProcessInstance(legacyProcessInstanceId);
            Long processDefinitionKey = this.findProcessDefinitionKey(legacyProcessInstance.getProcessDefinitionId());
            String processDefinitionId = legacyProcessInstance.getProcessDefinitionId();
            if (this.isMigrated(processDefinitionId, IdKeyMapper.TYPE.HISTORY_PROCESS_DEFINITION)) {
                ProcessInstanceEntity parentInstance;
                String legacySuperProcessInstanceId = legacyProcessInstance.getSuperProcessInstanceId();
                Long parentProcessInstanceKey = null;
                if (legacySuperProcessInstanceId != null && (parentInstance = this.findProcessInstanceByLegacyId(legacySuperProcessInstanceId)) != null) {
                    parentProcessInstanceKey = parentInstance.processInstanceKey();
                }
                if (parentProcessInstanceKey != null || legacySuperProcessInstanceId == null) {
                    ProcessInstanceDbModel dbModel = this.processInstanceConverter.apply(legacyProcessInstance, processDefinitionKey, parentProcessInstanceKey);
                    this.processInstanceMapper.insert(dbModel);
                    this.saveRecord(legacyProcessInstanceId, legacyProcessInstance.getStartTime(), dbModel.processInstanceKey(), IdKeyMapper.TYPE.HISTORY_PROCESS_INSTANCE);
                    HistoryMigratorLogs.migratingProcessInstanceCompleted(legacyProcessInstanceId);
                } else {
                    this.saveRecord(legacyProcessInstanceId, null, IdKeyMapper.TYPE.HISTORY_PROCESS_INSTANCE);
                    HistoryMigratorLogs.skippingProcessInstanceDueToMissingParent(legacyProcessInstanceId);
                }
            } else {
                this.saveRecord(legacyProcessInstanceId, null, IdKeyMapper.TYPE.HISTORY_PROCESS_INSTANCE);
                HistoryMigratorLogs.skippingProcessInstanceDueToMissingDefinition(legacyProcessInstanceId);
            }
        }
    }

    public void migrateDecisionRequirementsDefinitions() {
        HistoryMigratorLogs.migratingDecisionRequirements();
        if (MigratorMode.RETRY_SKIPPED.equals((Object)this.mode)) {
            this.dbClient.fetchAndHandleSkippedForType(IdKeyMapper.TYPE.HISTORY_DECISION_REQUIREMENT, idKeyDbModel -> {
                DecisionRequirementsDefinition legacyDecisionRequirement = this.c7Client.getDecisionRequirementsDefinition(idKeyDbModel.id());
                this.migrateDecisionRequirementsDefinition(legacyDecisionRequirement);
            });
        } else {
            this.c7Client.fetchAndHandleDecisionRequirementsDefinitions(this::migrateDecisionRequirementsDefinition);
        }
    }

    private void migrateDecisionRequirementsDefinition(DecisionRequirementsDefinition legacyDecisionRequirements) {
        String legacyId = legacyDecisionRequirements.getId();
        if (this.shouldMigrate(legacyId, IdKeyMapper.TYPE.HISTORY_DECISION_REQUIREMENT)) {
            HistoryMigratorLogs.migratingDecisionRequirements(legacyId);
            DecisionRequirementsDbModel dbModel = this.decisionRequirementsConverter.apply(legacyDecisionRequirements);
            this.decisionRequirementsMapper.insert(dbModel);
            this.saveRecord(legacyId, dbModel.decisionRequirementsKey(), IdKeyMapper.TYPE.HISTORY_DECISION_REQUIREMENT);
            HistoryMigratorLogs.migratingDecisionRequirementsCompleted(legacyId);
        }
    }

    public void migrateDecisionDefinitions() {
        HistoryMigratorLogs.migratingDecisionDefinitions();
        if (MigratorMode.RETRY_SKIPPED.equals((Object)this.mode)) {
            this.dbClient.fetchAndHandleSkippedForType(IdKeyMapper.TYPE.HISTORY_DECISION_DEFINITION, idKeyDbModel -> {
                DecisionDefinition legacyDecisionDefinition = this.c7Client.getDecisionDefinition(idKeyDbModel.id());
                this.migrateDecisionDefinition(legacyDecisionDefinition);
            });
        } else {
            this.c7Client.fetchAndHandleDecisionDefinitions(this::migrateDecisionDefinition, this.dbClient.findLatestStartDateByType(IdKeyMapper.TYPE.HISTORY_DECISION_DEFINITION));
        }
    }

    private void migrateDecisionDefinition(DecisionDefinition legacyDecisionDefinition) {
        String legacyId = legacyDecisionDefinition.getId();
        if (this.shouldMigrate(legacyId, IdKeyMapper.TYPE.HISTORY_DECISION_DEFINITION)) {
            HistoryMigratorLogs.migratingDecisionDefinition(legacyId);
            Long decisionRequirementsKey = null;
            if (legacyDecisionDefinition.getDecisionRequirementsDefinitionId() != null && (decisionRequirementsKey = this.dbClient.findKeyByIdAndType(legacyDecisionDefinition.getDecisionRequirementsDefinitionId(), IdKeyMapper.TYPE.HISTORY_DECISION_REQUIREMENT)) == null) {
                this.saveRecord(legacyId, null, IdKeyMapper.TYPE.HISTORY_DECISION_DEFINITION);
                HistoryMigratorLogs.skippingDecisionDefinition(legacyId);
                return;
            }
            DecisionDefinitionDbModel dbModel = this.decisionDefinitionConverter.apply(legacyDecisionDefinition, decisionRequirementsKey);
            this.decisionDefinitionMapper.insert(dbModel);
            Date deploymentTime = this.c7Client.getDefinitionDeploymentTime(legacyDecisionDefinition.getDeploymentId());
            this.saveRecord(legacyId, deploymentTime, dbModel.decisionDefinitionKey(), IdKeyMapper.TYPE.HISTORY_DECISION_DEFINITION);
            HistoryMigratorLogs.migratingDecisionDefinitionCompleted(legacyId);
        }
    }

    public void migrateDecisionInstances() {
        HistoryMigratorLogs.migratingDecisionInstances();
        if (MigratorMode.RETRY_SKIPPED.equals((Object)this.mode)) {
            this.dbClient.fetchAndHandleSkippedForType(IdKeyMapper.TYPE.HISTORY_DECISION_INSTANCE, idKeyDbModel -> {
                HistoricDecisionInstance historicDecisionInstance = this.c7Client.getHistoricDecisionInstance(idKeyDbModel.id());
                this.migrateDecisionInstance(historicDecisionInstance);
            });
        } else {
            this.c7Client.fetchAndHandleHistoricDecisionInstances(this::migrateDecisionInstance, this.dbClient.findLatestStartDateByType(IdKeyMapper.TYPE.HISTORY_DECISION_INSTANCE));
        }
    }

    private void migrateDecisionInstance(HistoricDecisionInstance legacyDecisionInstance) {
        if (legacyDecisionInstance.getProcessDefinitionKey() == null) {
            HistoryMigratorLogs.notMigratingDecisionInstancesNotOriginatingFromBusinessRuleTasks(legacyDecisionInstance.getId());
            return;
        }
        String legacyDecisionInstanceId = legacyDecisionInstance.getId();
        if (this.shouldMigrate(legacyDecisionInstanceId, IdKeyMapper.TYPE.HISTORY_DECISION_INSTANCE)) {
            HistoryMigratorLogs.migratingDecisionInstance(legacyDecisionInstanceId);
            if (!this.isMigrated(legacyDecisionInstance.getDecisionDefinitionId(), IdKeyMapper.TYPE.HISTORY_DECISION_DEFINITION)) {
                this.saveRecord(legacyDecisionInstanceId, null, IdKeyMapper.TYPE.HISTORY_DECISION_INSTANCE);
                HistoryMigratorLogs.skippingDecisionInstanceDueToMissingDecisionDefinition(legacyDecisionInstanceId);
                return;
            }
            if (!this.isMigrated(legacyDecisionInstance.getProcessDefinitionId(), IdKeyMapper.TYPE.HISTORY_PROCESS_DEFINITION)) {
                this.saveRecord(legacyDecisionInstanceId, null, IdKeyMapper.TYPE.HISTORY_DECISION_INSTANCE);
                HistoryMigratorLogs.skippingDecisionInstanceDueToMissingProcessDefinition(legacyDecisionInstanceId);
                return;
            }
            if (!this.isMigrated(legacyDecisionInstance.getProcessInstanceId(), IdKeyMapper.TYPE.HISTORY_PROCESS_INSTANCE)) {
                this.saveRecord(legacyDecisionInstanceId, null, IdKeyMapper.TYPE.HISTORY_DECISION_INSTANCE);
                HistoryMigratorLogs.skippingDecisionInstanceDueToMissingProcessInstance(legacyDecisionInstanceId);
                return;
            }
            String legacyRootDecisionInstanceId = legacyDecisionInstance.getRootDecisionInstanceId();
            Long parentDecisionDefinitionKey = null;
            if (legacyRootDecisionInstanceId != null) {
                if (!this.isMigrated(legacyRootDecisionInstanceId, IdKeyMapper.TYPE.HISTORY_DECISION_INSTANCE)) {
                    this.saveRecord(legacyDecisionInstanceId, null, IdKeyMapper.TYPE.HISTORY_DECISION_INSTANCE);
                    HistoryMigratorLogs.skippingDecisionInstanceDueToMissingParent(legacyDecisionInstanceId);
                    return;
                }
                parentDecisionDefinitionKey = this.findDecisionInstance(legacyRootDecisionInstanceId).decisionDefinitionKey();
            }
            if (!this.isMigrated(legacyDecisionInstance.getActivityInstanceId(), IdKeyMapper.TYPE.HISTORY_FLOW_NODE)) {
                this.saveRecord(legacyDecisionInstanceId, null, IdKeyMapper.TYPE.HISTORY_DECISION_INSTANCE);
                HistoryMigratorLogs.skippingDecisionInstanceDueToMissingFlowNodeInstanceInstance(legacyDecisionInstanceId);
                return;
            }
            DecisionDefinitionEntity decisionDefinition = this.findDecisionDefinition(legacyDecisionInstance.getDecisionDefinitionId());
            Long processDefinitionKey = this.findProcessDefinitionKey(legacyDecisionInstance.getProcessDefinitionId());
            Long processInstanceKey = this.findProcessInstanceByLegacyId(legacyDecisionInstance.getProcessInstanceId()).processInstanceKey();
            FlowNodeInstanceDbModel flowNode = this.findFlowNodeInstance(legacyDecisionInstance.getActivityInstanceId());
            DecisionInstanceDbModel dbModel = this.decisionInstanceConverter.apply(legacyDecisionInstance, decisionDefinition.decisionDefinitionKey(), processDefinitionKey, decisionDefinition.decisionRequirementsKey(), processInstanceKey, parentDecisionDefinitionKey, flowNode.flowNodeInstanceKey(), flowNode.flowNodeId());
            this.decisionInstanceMapper.insert(dbModel);
            this.saveRecord(legacyDecisionInstanceId, legacyDecisionInstance.getEvaluationTime(), dbModel.decisionInstanceKey(), IdKeyMapper.TYPE.HISTORY_DECISION_INSTANCE);
            HistoryMigratorLogs.migratingDecisionInstanceCompleted(legacyDecisionInstanceId);
        }
    }

    private void migrateIncidents() {
        HistoryMigratorLogs.migratingHistoricIncidents();
        if (MigratorMode.RETRY_SKIPPED.equals((Object)this.mode)) {
            this.dbClient.fetchAndHandleSkippedForType(IdKeyMapper.TYPE.HISTORY_INCIDENT, idKeyDbModel -> {
                HistoricIncident historicIncident = this.c7Client.getHistoricIncident(idKeyDbModel.id());
                this.migrateIncident(historicIncident);
            });
        } else {
            this.c7Client.fetchAndHandleHistoricIncidents(this::migrateIncident, this.dbClient.findLatestStartDateByType(IdKeyMapper.TYPE.HISTORY_INCIDENT));
        }
    }

    private void migrateIncident(HistoricIncident legacyIncident) {
        String legacyIncidentId = legacyIncident.getId();
        if (this.shouldMigrate(legacyIncidentId, IdKeyMapper.TYPE.HISTORY_INCIDENT)) {
            HistoryMigratorLogs.migratingHistoricIncident(legacyIncidentId);
            ProcessInstanceEntity legacyProcessInstance = this.findProcessInstanceByLegacyId(legacyIncident.getProcessInstanceId());
            if (legacyProcessInstance != null) {
                Long processInstanceKey = legacyProcessInstance.processInstanceKey();
                if (processInstanceKey != null) {
                    Long flowNodeInstanceKey = this.findFlowNodeInstanceKey(legacyIncident.getActivityId(), legacyIncident.getProcessInstanceId());
                    Long processDefinitionKey = this.findProcessDefinitionKey(legacyIncident.getProcessDefinitionId());
                    Long jobDefinitionKey = null;
                    IncidentDbModel dbModel = this.incidentConverter.apply(legacyIncident, processDefinitionKey, processInstanceKey, jobDefinitionKey, flowNodeInstanceKey);
                    this.incidentMapper.insert(dbModel);
                    this.saveRecord(legacyIncidentId, legacyIncident.getCreateTime(), dbModel.incidentKey(), IdKeyMapper.TYPE.HISTORY_INCIDENT);
                    HistoryMigratorLogs.migratingHistoricIncidentCompleted(legacyIncidentId);
                } else {
                    this.saveRecord(legacyIncidentId, null, IdKeyMapper.TYPE.HISTORY_INCIDENT);
                    HistoryMigratorLogs.skippingHistoricIncident(legacyIncidentId);
                }
            } else {
                this.saveRecord(legacyIncidentId, null, IdKeyMapper.TYPE.HISTORY_INCIDENT);
                HistoryMigratorLogs.skippingHistoricIncident(legacyIncidentId);
            }
        }
    }

    public void migrateVariables() {
        HistoryMigratorLogs.migratingHistoricVariables();
        if (MigratorMode.RETRY_SKIPPED.equals((Object)this.mode)) {
            this.dbClient.fetchAndHandleSkippedForType(IdKeyMapper.TYPE.HISTORY_VARIABLE, idKeyDbModel -> {
                HistoricVariableInstance historicVariableInstance = this.c7Client.getHistoricVariableInstance(idKeyDbModel.id());
                this.migrateVariable(historicVariableInstance);
            });
        } else {
            this.c7Client.fetchAndHandleHistoricVariables(this::migrateVariable, this.dbClient.findLatestIdByType(IdKeyMapper.TYPE.HISTORY_VARIABLE));
        }
    }

    private void migrateVariable(HistoricVariableInstance legacyVariable) {
        String legacyVariableId = legacyVariable.getId();
        if (this.shouldMigrate(legacyVariableId, IdKeyMapper.TYPE.HISTORY_VARIABLE)) {
            HistoryMigratorLogs.migratingHistoricVariable(legacyVariableId);
            String taskId = legacyVariable.getTaskId();
            if (taskId != null && !this.isMigrated(taskId, IdKeyMapper.TYPE.HISTORY_USER_TASK)) {
                this.saveRecord(legacyVariableId, null, IdKeyMapper.TYPE.HISTORY_VARIABLE);
                HistoryMigratorLogs.skippingHistoricVariableDueToMissingTask(legacyVariableId, taskId);
                return;
            }
            String legacyProcessInstanceId = legacyVariable.getProcessInstanceId();
            if (this.isMigrated(legacyProcessInstanceId, IdKeyMapper.TYPE.HISTORY_PROCESS_INSTANCE)) {
                if (this.isMigrated(legacyVariable.getActivityInstanceId(), IdKeyMapper.TYPE.HISTORY_FLOW_NODE) || this.isMigrated(legacyVariable.getActivityInstanceId(), IdKeyMapper.TYPE.HISTORY_PROCESS_INSTANCE)) {
                    ProcessInstanceEntity processInstance = this.findProcessInstanceByLegacyId(legacyProcessInstanceId);
                    Long processInstanceKey = processInstance.processInstanceKey();
                    Long scopeKey = this.findScopeKey(legacyVariable.getActivityInstanceId());
                    if (scopeKey != null) {
                        VariableDbModel dbModel = this.variableConverter.apply(legacyVariable, processInstanceKey, scopeKey);
                        this.variableMapper.insert(dbModel);
                        this.saveRecord(legacyVariableId, legacyVariable.getCreateTime(), dbModel.variableKey(), IdKeyMapper.TYPE.HISTORY_VARIABLE);
                        HistoryMigratorLogs.migratingHistoricVariableCompleted(legacyVariableId);
                    } else {
                        this.saveRecord(legacyVariableId, null, IdKeyMapper.TYPE.HISTORY_VARIABLE);
                        HistoryMigratorLogs.skippingHistoricVariableDueToMissingScopeKey(legacyVariableId);
                    }
                } else {
                    this.saveRecord(legacyVariableId, null, IdKeyMapper.TYPE.HISTORY_VARIABLE);
                    HistoryMigratorLogs.skippingHistoricVariableDueToMissingFlowNode(legacyVariableId);
                }
            } else {
                this.saveRecord(legacyVariableId, null, IdKeyMapper.TYPE.HISTORY_VARIABLE);
                HistoryMigratorLogs.skippingHistoricVariableDueToMissingProcessInstance(legacyVariableId);
            }
        }
    }

    public void migrateUserTasks() {
        HistoryMigratorLogs.migratingHistoricUserTasks();
        if (MigratorMode.RETRY_SKIPPED.equals((Object)this.mode)) {
            this.dbClient.fetchAndHandleSkippedForType(IdKeyMapper.TYPE.HISTORY_USER_TASK, idKeyDbModel -> {
                HistoricTaskInstance historicTaskInstance = this.c7Client.getHistoricTaskInstance(idKeyDbModel.id());
                this.migrateUserTask(historicTaskInstance);
            });
        } else {
            this.c7Client.fetchAndHandleHistoricUserTasks(this::migrateUserTask, this.dbClient.findLatestStartDateByType(IdKeyMapper.TYPE.HISTORY_USER_TASK));
        }
    }

    private void migrateUserTask(HistoricTaskInstance legacyUserTask) {
        String legacyUserTaskId = legacyUserTask.getId();
        if (this.shouldMigrate(legacyUserTaskId, IdKeyMapper.TYPE.HISTORY_USER_TASK)) {
            HistoryMigratorLogs.migratingHistoricUserTask(legacyUserTaskId);
            if (this.isMigrated(legacyUserTask.getProcessInstanceId(), IdKeyMapper.TYPE.HISTORY_PROCESS_INSTANCE)) {
                ProcessInstanceEntity processInstance = this.findProcessInstanceByLegacyId(legacyUserTask.getProcessInstanceId());
                if (this.isMigrated(legacyUserTask.getActivityInstanceId(), IdKeyMapper.TYPE.HISTORY_FLOW_NODE)) {
                    Long elementInstanceKey = this.findFlowNodeInstanceKey(legacyUserTask.getActivityInstanceId());
                    Long processDefinitionKey = this.findProcessDefinitionKey(legacyUserTask.getProcessDefinitionId());
                    UserTaskDbModel dbModel = this.userTaskConverter.apply(legacyUserTask, processDefinitionKey, processInstance, elementInstanceKey);
                    this.userTaskMapper.insert(dbModel);
                    this.saveRecord(legacyUserTaskId, legacyUserTask.getStartTime(), dbModel.userTaskKey(), IdKeyMapper.TYPE.HISTORY_USER_TASK);
                    HistoryMigratorLogs.migratingHistoricUserTaskCompleted(legacyUserTaskId);
                } else {
                    this.saveRecord(legacyUserTaskId, null, IdKeyMapper.TYPE.HISTORY_USER_TASK);
                    HistoryMigratorLogs.skippingHistoricUserTaskDueToMissingFlowNode(legacyUserTaskId);
                }
            } else {
                this.saveRecord(legacyUserTaskId, null, IdKeyMapper.TYPE.HISTORY_USER_TASK);
                HistoryMigratorLogs.skippingHistoricUserTaskDueToMissingProcessInstance(legacyUserTaskId);
            }
        }
    }

    public void migrateFlowNodes() {
        HistoryMigratorLogs.migratingHistoricFlowNodes();
        if (MigratorMode.RETRY_SKIPPED.equals((Object)this.mode)) {
            this.dbClient.fetchAndHandleSkippedForType(IdKeyMapper.TYPE.HISTORY_FLOW_NODE, idKeyDbModel -> {
                HistoricActivityInstance historicActivityInstance = this.c7Client.getHistoricActivityInstance(idKeyDbModel.id());
                this.migrateFlowNode(historicActivityInstance);
            });
        } else {
            this.c7Client.fetchAndHandleHistoricFlowNodes(this::migrateFlowNode, this.dbClient.findLatestStartDateByType(IdKeyMapper.TYPE.HISTORY_FLOW_NODE));
        }
    }

    private void migrateFlowNode(HistoricActivityInstance legacyFlowNode) {
        String legacyFlowNodeId = legacyFlowNode.getId();
        if (this.shouldMigrate(legacyFlowNodeId, IdKeyMapper.TYPE.HISTORY_FLOW_NODE)) {
            HistoryMigratorLogs.migratingHistoricFlowNode(legacyFlowNodeId);
            ProcessInstanceEntity processInstance = this.findProcessInstanceByLegacyId(legacyFlowNode.getProcessInstanceId());
            if (processInstance != null) {
                Long processInstanceKey = processInstance.processInstanceKey();
                Long processDefinitionKey = this.findProcessDefinitionKey(legacyFlowNode.getProcessDefinitionId());
                FlowNodeInstanceDbModel dbModel = this.flowNodeConverter.apply(legacyFlowNode, processDefinitionKey, processInstanceKey);
                this.flowNodeMapper.insert(dbModel);
                this.saveRecord(legacyFlowNodeId, legacyFlowNode.getStartTime(), dbModel.flowNodeInstanceKey(), IdKeyMapper.TYPE.HISTORY_FLOW_NODE);
                HistoryMigratorLogs.migratingHistoricFlowNodeCompleted(legacyFlowNodeId);
            } else {
                this.saveRecord(legacyFlowNodeId, null, IdKeyMapper.TYPE.HISTORY_FLOW_NODE);
                HistoryMigratorLogs.skippingHistoricFlowNode(legacyFlowNodeId);
            }
        }
    }

    protected ProcessInstanceEntity findProcessInstanceByLegacyId(String processInstanceId) {
        if (processInstanceId == null) {
            return null;
        }
        Long key = this.dbClient.findKeyByIdAndType(processInstanceId, IdKeyMapper.TYPE.HISTORY_PROCESS_INSTANCE);
        if (key == null) {
            return null;
        }
        return this.processInstanceMapper.findOne(key);
    }

    protected DecisionInstanceEntity findDecisionInstance(String decisionInstanceId) {
        if (decisionInstanceId == null) {
            return null;
        }
        Long key = this.dbClient.findKeyByIdAndType(decisionInstanceId, IdKeyMapper.TYPE.HISTORY_DECISION_INSTANCE);
        if (key == null) {
            return null;
        }
        return this.decisionInstanceMapper.search(DecisionInstanceDbQuery.of(b -> b.filter(value -> value.decisionInstanceKeys(new Long[]{key})))).stream().findFirst().orElse(null);
    }

    protected DecisionDefinitionEntity findDecisionDefinition(String decisionDefinitionId) {
        Long key = this.dbClient.findKeyByIdAndType(decisionDefinitionId, IdKeyMapper.TYPE.HISTORY_DECISION_DEFINITION);
        if (key == null) {
            return null;
        }
        return this.decisionDefinitionMapper.search(DecisionDefinitionDbQuery.of(b -> b.filter(value -> value.decisionDefinitionKeys(new Long[]{key})))).stream().findFirst().orElse(null);
    }

    private Long findProcessDefinitionKey(String processDefinitionId) {
        Long key = this.dbClient.findKeyByIdAndType(processDefinitionId, IdKeyMapper.TYPE.HISTORY_PROCESS_DEFINITION);
        if (key == null) {
            return null;
        }
        List processDefinitions = this.processDefinitionMapper.search(ProcessDefinitionDbQuery.of(b -> b.filter(value -> value.processDefinitionKeys(key, new Long[0]))));
        if (!processDefinitions.isEmpty()) {
            return ((ProcessDefinitionEntity)processDefinitions.getFirst()).processDefinitionKey();
        }
        return null;
    }

    private Long findFlowNodeInstanceKey(String activityId, String processInstanceId) {
        Long key = this.dbClient.findKeyByIdAndType(processInstanceId, IdKeyMapper.TYPE.HISTORY_PROCESS_INSTANCE);
        if (key == null) {
            return null;
        }
        List flowNodes = this.flowNodeMapper.search(FlowNodeInstanceDbQuery.of(b -> b.filter(FlowNodeInstanceFilter.of(f -> f.flowNodeIds(new String[]{activityId}).flowNodeInstanceKeys(new Long[]{key})))));
        if (!flowNodes.isEmpty()) {
            return ((FlowNodeInstanceDbModel)flowNodes.getFirst()).flowNodeInstanceKey();
        }
        return null;
    }

    protected Long findFlowNodeInstanceKey(String activityInstanceId) {
        return Optional.ofNullable(this.findFlowNodeInstance(activityInstanceId)).map(FlowNodeInstanceDbModel::flowNodeInstanceKey).orElse(null);
    }

    protected FlowNodeInstanceDbModel findFlowNodeInstance(String activityInstanceId) {
        Long key = this.dbClient.findKeyByIdAndType(activityInstanceId, IdKeyMapper.TYPE.HISTORY_FLOW_NODE);
        if (key == null) {
            return null;
        }
        return this.flowNodeMapper.search(FlowNodeInstanceDbQuery.of(b -> b.filter(f -> f.flowNodeInstanceKeys(new Long[]{key})))).stream().findFirst().orElse(null);
    }

    private Long findScopeKey(String instanceId) {
        Long key = this.findFlowNodeInstanceKey(instanceId);
        if (key != null) {
            return key;
        }
        Long processInstanceKey = this.dbClient.findKeyByIdAndType(instanceId, IdKeyMapper.TYPE.HISTORY_PROCESS_INSTANCE);
        if (processInstanceKey == null) {
            return null;
        }
        List processInstances = this.processInstanceMapper.search(ProcessInstanceDbQuery.of(b -> b.filter(value -> value.processInstanceKeys(processInstanceKey, new Long[0]))));
        return processInstances.isEmpty() ? null : processInstanceKey;
    }

    private boolean isMigrated(String id, IdKeyMapper.TYPE type) {
        return this.dbClient.checkHasKeyByIdAndType(id, type);
    }

    private boolean shouldMigrate(String id, IdKeyMapper.TYPE type) {
        if (this.mode == MigratorMode.RETRY_SKIPPED) {
            return !this.dbClient.checkHasKeyByIdAndType(id, type);
        }
        return !this.dbClient.checkExistsByIdAndType(id, type);
    }

    protected void saveRecord(String entityId, Long entityKey, IdKeyMapper.TYPE type) {
        if (MigratorMode.RETRY_SKIPPED.equals((Object)this.mode)) {
            this.dbClient.updateKeyByIdAndType(entityId, entityKey, type);
        } else if (MigratorMode.MIGRATE.equals((Object)this.mode)) {
            this.dbClient.insert(entityId, entityKey, type);
        }
    }

    protected void saveRecord(String entityId, Date date, Long entityKey, IdKeyMapper.TYPE type) {
        if (MigratorMode.RETRY_SKIPPED.equals((Object)this.mode)) {
            this.dbClient.updateKeyByIdAndType(entityId, entityKey, type);
        } else if (MigratorMode.MIGRATE.equals((Object)this.mode)) {
            this.dbClient.insert(entityId, date, entityKey, type);
        }
    }

    public void setMode(MigratorMode mode) {
        this.mode = mode;
    }

    public void setRequestedEntityTypes(List<IdKeyMapper.TYPE> requestedEntityTypes) {
        this.requestedEntityTypes = requestedEntityTypes;
    }
}

