/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.database.rubyrep;

import brooklyn.config.BrooklynProperties;
import brooklyn.entity.Application;
import brooklyn.entity.basic.ApplicationBuilder;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.database.DatabaseNode;
import brooklyn.entity.database.VogellaExampleAccess;
import brooklyn.entity.database.mysql.MySqlIntegrationTest;
import brooklyn.entity.database.mysql.MySqlNode;
import brooklyn.entity.database.postgresql.PostgreSqlIntegrationTest;
import brooklyn.entity.database.postgresql.PostgreSqlNode;
import brooklyn.entity.database.rubyrep.RubyRepNode;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.location.Location;
import brooklyn.location.basic.LocalhostMachineProvisioningLocation;
import brooklyn.management.ManagementContext;
import brooklyn.management.internal.LocalManagementContext;
import brooklyn.test.entity.TestApplication;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class RubyRepIntegrationTest {
    public static final Logger log = LoggerFactory.getLogger(RubyRepIntegrationTest.class);
    protected BrooklynProperties brooklynProperties;
    protected ManagementContext managementContext;
    protected TestApplication tapp;

    @BeforeMethod(alwaysRun=true)
    public void setUp() {
        this.brooklynProperties = BrooklynProperties.Factory.newDefault();
        this.managementContext = new LocalManagementContext(this.brooklynProperties);
        this.tapp = (TestApplication)ApplicationBuilder.newManagedApp(TestApplication.class, (ManagementContext)this.managementContext);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        if (this.tapp != null) {
            Entities.destroyAll((Application)this.tapp);
        }
        this.tapp = null;
    }

    @Test(groups={"Integration"})
    public void test_localhost_mysql() throws Exception {
        MySqlNode db1 = (MySqlNode)this.tapp.createAndManageChild(EntitySpec.create(MySqlNode.class).configure((CharSequence)"creationScriptContents", (Object)MySqlIntegrationTest.CREATION_SCRIPT).configure((CharSequence)"port", (Object)"9111"));
        MySqlNode db2 = (MySqlNode)this.tapp.createAndManageChild(EntitySpec.create(MySqlNode.class).configure((CharSequence)"creationScriptContents", (Object)MySqlIntegrationTest.CREATION_SCRIPT).configure((CharSequence)"port", (Object)"9112"));
        RubyRepIntegrationTest.startInLocation(this.tapp, (DatabaseNode)db1, (DatabaseNode)db2, new Location[]{new LocalhostMachineProvisioningLocation()});
        RubyRepIntegrationTest.testReplication((DatabaseNode)db1, (DatabaseNode)db2);
    }

    @Test(groups={"Integration"})
    public void test_localhost_postgres() throws Exception {
        String createTwoDbsScript = String.valueOf(PostgreSqlIntegrationTest.CREATION_SCRIPT) + PostgreSqlIntegrationTest.CREATION_SCRIPT.replaceAll("CREATE USER.*", "").replaceAll(" feedback", " feedback1");
        PostgreSqlNode db1 = (PostgreSqlNode)this.tapp.createAndManageChild(EntitySpec.create(PostgreSqlNode.class).configure((CharSequence)"creationScriptContents", (Object)createTwoDbsScript).configure((CharSequence)"port", (Object)"9113"));
        RubyRepIntegrationTest.startInLocation(this.tapp, (DatabaseNode)db1, "feedback", (DatabaseNode)db1, "feedback1", new Location[]{new LocalhostMachineProvisioningLocation()});
        RubyRepIntegrationTest.testReplication((DatabaseNode)db1, "feedback", (DatabaseNode)db1, "feedback1");
    }

    @Test(enabled=false, groups={"Integration"})
    public void test_localhost_postgres_mysql() throws Exception {
        PostgreSqlNode db1 = (PostgreSqlNode)this.tapp.createAndManageChild(EntitySpec.create(PostgreSqlNode.class).configure((CharSequence)"creationScriptContents", (Object)PostgreSqlIntegrationTest.CREATION_SCRIPT).configure((CharSequence)"port", (Object)"9115"));
        MySqlNode db2 = (MySqlNode)this.tapp.createAndManageChild(EntitySpec.create(MySqlNode.class).configure((CharSequence)"creationScriptContents", (Object)MySqlIntegrationTest.CREATION_SCRIPT).configure((CharSequence)"port", (Object)"9116"));
        RubyRepIntegrationTest.startInLocation(this.tapp, (DatabaseNode)db1, (DatabaseNode)db2, new Location[]{new LocalhostMachineProvisioningLocation()});
        RubyRepIntegrationTest.testReplication((DatabaseNode)db1, (DatabaseNode)db2);
    }

    public static void startInLocation(TestApplication tapp, DatabaseNode db1, DatabaseNode db2, Location ... locations) throws Exception {
        RubyRepIntegrationTest.startInLocation(tapp, db1, "feedback", db2, "feedback", locations);
    }

    public static void startInLocation(TestApplication tapp, DatabaseNode db1, String dbName1, DatabaseNode db2, String dbName2, Location ... locations) throws Exception {
        tapp.createAndManageChild(EntitySpec.create(RubyRepNode.class).configure((CharSequence)"leftDatabase", (Object)db1).configure((CharSequence)"rightDatabase", (Object)db2).configure((CharSequence)"leftUsername", (Object)"sqluser").configure((CharSequence)"rightUsername", (Object)"sqluser").configure((CharSequence)"rightPassword", (Object)"sqluserpw").configure((CharSequence)"leftPassword", (Object)"sqluserpw").configure((CharSequence)"leftDatabaseName", (Object)dbName1).configure((CharSequence)"rightDatabaseName", (Object)dbName2).configure((CharSequence)"replicationInterval", (Object)1));
        tapp.start(Arrays.asList(locations));
    }

    public static void testReplication(DatabaseNode db1, DatabaseNode db2) throws Exception {
        RubyRepIntegrationTest.testReplication(db1, "feedback", db2, "feedback");
    }

    public static void testReplication(DatabaseNode db1, String dbName1, DatabaseNode db2, String dbName2) throws Exception {
        String db1Url = (String)db1.getAttribute(DatabaseNode.DB_URL);
        String db2Url = (String)db2.getAttribute(DatabaseNode.DB_URL);
        log.info("Testing replication between " + db1Url + " and " + db2Url);
        VogellaExampleAccess vea1 = new VogellaExampleAccess(db1 instanceof MySqlNode ? "com.mysql.jdbc.Driver" : "org.postgresql.Driver", db1Url, dbName1);
        VogellaExampleAccess vea2 = new VogellaExampleAccess(db2 instanceof MySqlNode ? "com.mysql.jdbc.Driver" : "org.postgresql.Driver", db2Url, dbName2);
        try {
            vea1.connect();
            List<List<String>> rs = vea1.readDataBase();
            Assert.assertEquals((int)rs.size(), (int)1);
            vea2.connect();
            rs = vea2.readDataBase();
            Assert.assertEquals((int)rs.size(), (int)1);
            log.info("Modifying left database");
            vea1.modifyDataBase();
            log.info("Reading left database");
            rs = vea1.readDataBase();
            Assert.assertEquals((int)rs.size(), (int)2);
            log.info("Reading right database");
            rs = vea2.readDataBase();
            int i = 0;
            while (i < 60 && rs.size() != 2) {
                log.info("Sleeping for a second");
                Thread.sleep(1000L);
                rs = vea2.readDataBase();
                ++i;
            }
            Assert.assertEquals((int)rs.size(), (int)2);
        }
        finally {
            vea1.close();
            vea2.close();
        }
    }
}

