/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.database.postgresql;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.chef.ChefLiveTestSupport;
import brooklyn.entity.database.VogellaExampleAccess;
import brooklyn.entity.database.postgresql.PostgreSqlIntegrationTest;
import brooklyn.entity.database.postgresql.PostgreSqlNode;
import brooklyn.entity.database.postgresql.PostgreSqlSpecs;
import brooklyn.entity.effector.EffectorTasks;
import brooklyn.entity.software.SshEffectorTasks;
import brooklyn.location.PortRange;
import brooklyn.location.basic.PortRanges;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.management.TaskFactory;
import brooklyn.util.task.system.ProcessTaskWrapper;
import brooklyn.util.time.Duration;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PostgreSqlChefTest
extends ChefLiveTestSupport {
    private static final Logger log = LoggerFactory.getLogger(PostgreSqlChefTest.class);
    PostgreSqlNode psql;

    @Test(groups={"Live"})
    public void testPostgresStartsAndStops() throws Exception {
        ChefLiveTestSupport.installBrooklynChefHostedConfig((Entity)this.app);
        this.psql = (PostgreSqlNode)this.app.createAndManageChild(PostgreSqlSpecs.specChef());
        this.app.start((Collection)ImmutableList.of((Object)this.targetLocation));
        Entities.submit((Entity)this.psql, (TaskFactory)SshEffectorTasks.ssh((String[])new String[]{"ps aux | grep [p]ostgres"}).requiringExitCodeZero());
        SshMachineLocation targetMachine = EffectorTasks.getSshMachine((Entity)this.psql);
        this.psql.stop();
        try {
            ProcessTaskWrapper t = (ProcessTaskWrapper)Entities.submit((Entity)this.app, (TaskFactory)((SshEffectorTasks.SshEffectorTaskFactory)SshEffectorTasks.ssh((String[])new String[]{"ps aux | grep [p]ostgres"}).machine(targetMachine)).allowingNonZeroExitCode());
            t.getTask().blockUntilEnded(Duration.TEN_SECONDS);
            if (!t.isDone()) {
                Assert.fail((String)("Task not finished yet: " + t.getTask()));
            }
            Assert.assertNotEquals((Object)t.get(), (Object)0, (String)("Task ended with code " + t.get() + "; output: " + t.getStdout()));
        }
        catch (Exception e) {
            log.info("Machine " + targetMachine + " destroyed on stop (expected - " + e + ")");
        }
    }

    @Test(groups={"Live"})
    public void testPostgresScriptAndAccess() throws Exception {
        ChefLiveTestSupport.installBrooklynChefHostedConfig((Entity)this.app);
        PortRange randomPort = PortRanges.fromString((String)(5420 + new Random().nextInt(10) + "+"));
        this.psql = (PostgreSqlNode)this.app.createAndManageChild(PostgreSqlSpecs.specChef().configure(PostgreSqlNode.CREATION_SCRIPT_CONTENTS, (Object)PostgreSqlIntegrationTest.CREATION_SCRIPT).configure((ConfigKey.HasConfigKey)PostgreSqlNode.POSTGRESQL_PORT, (Object)randomPort));
        this.app.start((Collection)ImmutableList.of((Object)this.targetLocation));
        String url = (String)this.psql.getAttribute(PostgreSqlNode.DB_URL);
        log.info("Trying to connect to " + this.psql + " at " + url);
        Assert.assertNotNull((Object)url);
        Assert.assertTrue((boolean)url.contains("542"));
        new VogellaExampleAccess("org.postgresql.Driver", url).readModifyAndRevertDataBase();
    }
}

