/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.database.mariadb;

import brooklyn.entity.database.VogellaExampleAccess;
import brooklyn.entity.database.mariadb.MariaDbIntegrationTest;
import brooklyn.entity.database.mariadb.MariaDbNode;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.location.jclouds.JcloudsLocation;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.testng.annotations.Test;

public class MariaDbLiveRackspaceTest
extends MariaDbIntegrationTest {
    @Test(groups={"Live"})
    public void test_Debian_6() throws Exception {
        this.test("Debian 6");
    }

    @Test(groups={"Live"})
    public void test_Ubuntu_10_0() throws Exception {
        this.test("Ubuntu 10.0");
    }

    @Test(groups={"Live"})
    public void test_Ubuntu_11_0() throws Exception {
        this.test("Ubuntu 11.0");
    }

    @Test(groups={"Live", "Live-sanity"})
    public void test_Ubuntu_12_0() throws Exception {
        this.test("Ubuntu 12.0");
    }

    @Test(groups={"Live"})
    public void test_CentOS_6_0() throws Exception {
        this.test("CentOS 6.0");
    }

    @Test(groups={"Live"})
    public void test_CentOS_5_6() throws Exception {
        this.test("CentOS 5.6");
    }

    @Test(groups={"Live"})
    public void test_Fedora_17() throws Exception {
        this.test("Fedora 17");
    }

    @Test(groups={"Live"})
    public void test_Red_Hat_Enterprise_Linux_6() throws Exception {
        this.test("Red Hat Enterprise Linux 6");
    }

    @Override
    @Test(groups={"Live"})
    public void test_localhost() throws Exception {
        super.test_localhost();
    }

    public void test(String osRegex) throws Exception {
        MariaDbNode mariadb = (MariaDbNode)this.tapp.createAndManageChild(EntitySpec.create(MariaDbNode.class).configure((CharSequence)"creationScriptContents", (Object)CREATION_SCRIPT));
        this.brooklynProperties.put((Object)"brooklyn.jclouds.rackspace-cloudservers-uk.image-name-regex", (Object)osRegex);
        this.brooklynProperties.remove((Object)"brooklyn.jclouds.rackspace-cloudservers-uk.image-id");
        this.brooklynProperties.put((Object)"inboundPorts", (Object)"22, 3306");
        JcloudsLocation jcloudsLocation = (JcloudsLocation)this.managementContext.getLocationRegistry().resolve("jclouds:rackspace-cloudservers-uk");
        this.tapp.start((Collection)ImmutableList.of((Object)jcloudsLocation));
        SshMachineLocation l = (SshMachineLocation)mariadb.getLocations().iterator().next();
        l.exec((List)ImmutableList.of((Object)"iptables -I INPUT -p tcp --dport 3306 -j ACCEPT"));
        new VogellaExampleAccess("com.mysql.jdbc.Driver", (String)mariadb.getAttribute(MariaDbNode.DB_URL)).readModifyAndRevertDataBase();
    }
}

