/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.database;

import com.beust.jcommander.internal.Lists;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VogellaExampleAccess {
    public static final Logger log = LoggerFactory.getLogger(VogellaExampleAccess.class);
    private Connection connect = null;
    private Statement statement = null;
    private final String url;
    private final String dbName;

    public VogellaExampleAccess(String driverClass, String url) throws ClassNotFoundException {
        this(driverClass, url, "feedback");
    }

    public VogellaExampleAccess(String driverClass, String url, String dbName) throws ClassNotFoundException {
        Class.forName(driverClass);
        this.url = url;
        this.dbName = dbName;
    }

    public void readModifyAndRevertDataBase() throws Exception {
        this.connect();
        this.readDataBase();
        this.modifyDataBase();
        this.revertDatabase();
        this.close();
    }

    public void connect() throws Exception {
        try {
            String jdbcUrl = "jdbc:" + this.url + this.dbName + "?" + "user=sqluser&password=sqluserpw";
            log.info("Connecting to " + jdbcUrl);
            this.connect = DriverManager.getConnection(jdbcUrl);
            this.statement = this.connect.createStatement();
        }
        catch (Exception ex) {
            this.close();
            throw ex;
        }
    }

    public List<List<String>> readDataBase() throws Exception {
        List results = Lists.newArrayList();
        ResultSet resultSet = this.statement.executeQuery("SELECT myuser, webpage, datum, summary, COMMENTS from COMMENTS");
        while (resultSet.next()) {
            List row = Lists.newArrayList();
            int i = 1;
            while (i <= resultSet.getMetaData().getColumnCount()) {
                row.add(resultSet.getObject(i).toString());
                ++i;
            }
            results.add(row);
        }
        resultSet.close();
        this.writeResultSet(results);
        return results;
    }

    public void modifyDataBase() throws Exception {
        PreparedStatement preparedStatement = this.connect.prepareStatement("insert into  COMMENTS values (?, ?, ?, ?, ? , ?, ?)");
        preparedStatement.setInt(1, 2);
        preparedStatement.setString(2, "Test");
        preparedStatement.setString(3, "TestEmail");
        preparedStatement.setString(4, "TestWebpage");
        preparedStatement.setDate(5, new java.sql.Date(new Date().getTime()));
        preparedStatement.setString(6, "TestSummary");
        preparedStatement.setString(7, "TestComment");
        preparedStatement.executeUpdate();
        this.writeResultSet(this.readDataBase());
    }

    public void revertDatabase() throws Exception {
        PreparedStatement preparedStatement = this.connect.prepareStatement("delete from COMMENTS where myuser= ? ; ");
        preparedStatement.setString(1, "Test");
        preparedStatement.executeUpdate();
        ResultSet resultSet = this.statement.executeQuery("select * from COMMENTS");
        this.writeMetaData(resultSet);
        resultSet.close();
    }

    private void writeMetaData(ResultSet resultSet) throws SQLException {
        log.info("The columns in the table are: ");
        log.info("Table: " + resultSet.getMetaData().getTableName(1));
        int i = 1;
        while (i <= resultSet.getMetaData().getColumnCount()) {
            log.info("Column " + i + " " + resultSet.getMetaData().getColumnName(i));
            ++i;
        }
    }

    private void writeResultSet(List<List<String>> resultSet) throws SQLException {
        for (List<String> row : resultSet) {
            String user = row.get(0);
            String website = row.get(1);
            String date = row.get(2);
            String summary = row.get(3);
            String comment = row.get(4);
            log.info("User: " + user);
            log.info("Website: " + website);
            log.info("Summary: " + summary);
            log.info("Date: " + date);
            log.info("Comment: " + comment);
        }
    }

    public void close() throws Exception {
        if (this.statement != null) {
            this.statement.close();
            this.statement = null;
        }
        if (this.connect != null) {
            this.connect.close();
            this.connect = null;
        }
    }
}

