/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.database.rubyrep;

import brooklyn.config.BrooklynProperties;
import brooklyn.entity.database.DatabaseNode;
import brooklyn.entity.database.postgresql.PostgreSqlIntegrationTest;
import brooklyn.entity.database.postgresql.PostgreSqlNode;
import brooklyn.entity.database.rubyrep.RubyRepIntegrationTest;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.entity.proxying.EntitySpecs;
import brooklyn.location.basic.LocationRegistry;
import brooklyn.location.basic.SshMachineLocation;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Map;
import org.testng.annotations.Test;

public class RubyRepRackspaceLiveTest
extends RubyRepIntegrationTest {
    @Test(groups={"Live"})
    public void test_Debian_6() throws Exception {
        this.test("Debian 6");
    }

    @Test(groups={"Live"})
    public void test_Ubuntu_10_0() throws Exception {
        this.test("Ubuntu 10.0");
    }

    @Test(groups={"Live"})
    public void test_Ubuntu_11_0() throws Exception {
        this.test("Ubuntu 11.0");
    }

    @Test(groups={"Live"})
    public void test_Ubuntu_12_0() throws Exception {
        this.test("Ubuntu 12.0");
    }

    @Test(groups={"Live"})
    public void test_CentOS_6_0() throws Exception {
        this.test("CentOS 6.0");
    }

    @Test(groups={"Live"})
    public void test_CentOS_5_6() throws Exception {
        this.test("CentOS 5.6");
    }

    @Test(groups={"Live"})
    public void test_Fedora_17() throws Exception {
        this.test("Fedora 17");
    }

    @Test(groups={"Live"})
    public void test_Red_Hat_Enterprise_Linux_6() throws Exception {
        this.test("Red Hat Enterprise Linux 6");
    }

    public void test(String osRegex) throws Exception {
        PostgreSqlNode db1 = (PostgreSqlNode)this.tapp.createAndManageChild((EntitySpec)EntitySpecs.spec(PostgreSqlNode.class).configure((CharSequence)"creationScriptContents", (Object)PostgreSqlIntegrationTest.CREATION_SCRIPT).configure((CharSequence)"port", (Object)9111));
        PostgreSqlNode db2 = (PostgreSqlNode)this.tapp.createAndManageChild((EntitySpec)EntitySpecs.spec(PostgreSqlNode.class).configure((CharSequence)"creationScriptContents", (Object)PostgreSqlIntegrationTest.CREATION_SCRIPT).configure((CharSequence)"port", (Object)9111));
        BrooklynProperties brooklynProperties = BrooklynProperties.Factory.newDefault();
        brooklynProperties.put((Object)"brooklyn.jclouds.cloudservers-uk.image-name-regex", (Object)osRegex);
        brooklynProperties.remove((Object)"brooklyn.jclouds.cloudservers-uk.image-id");
        brooklynProperties.put((Object)"inboundPorts", (Object)new int[]{22, 9111});
        LocationRegistry locationRegistry = new LocationRegistry((Map)brooklynProperties);
        RubyRepRackspaceLiveTest.startInLocation(this.tapp, (DatabaseNode)db1, (DatabaseNode)db2, locationRegistry.resolve("cloudservers-uk"));
        for (DatabaseNode node : ImmutableSet.of((Object)db1, (Object)db2)) {
            SshMachineLocation l = (SshMachineLocation)node.getLocations().iterator().next();
            l.exec(Arrays.asList("iptables -I INPUT -p tcp --dport 9111 -j ACCEPT"));
        }
        RubyRepRackspaceLiveTest.testReplication((DatabaseNode)db1, (DatabaseNode)db2);
    }

    @Override
    @Test(enabled=false, groups={"Integration"})
    public void test_localhost_mysql() throws Exception {
        super.test_localhost_mysql();
    }

    @Override
    @Test(enabled=false, groups={"Integration"})
    public void test_localhost_postgres() throws Exception {
        super.test_localhost_postgres();
    }

    @Override
    @Test(enabled=false, groups={"Integration"})
    public void test_localhost_postgres_mysql() throws Exception {
        super.test_localhost_postgres_mysql();
    }
}

